/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.client.model.tour.TourModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import org.ktde.util.StringUtil;

public class TourListModel
extends DefaultListModel {
    private static final long serialVersionUID = 7246958065068867311L;
    private List<TourModel> data = new ArrayList<TourModel>(){
        private static final long serialVersionUID = 8393936004972758871L;

        @Override
        public boolean add(TourModel e) {
            if (super.add(e)) {
                Collections.sort(this, new Comparator<TourModel>(){

                    @Override
                    public int compare(TourModel o1, TourModel o2) {
                        return StringUtil.getNotNull(o1.getName()).compareTo(StringUtil.getNotNull(o2.getName()));
                    }
                });
                return true;
            }
            return false;
        }
    };

    public TourListModel(List<TourModel> data) {
        this.data = data;
    }

    @Override
    public int getSize() {
        return this.data.size();
    }

    @Override
    public String getElementAt(int index) {
        return this.getObjectAt(index) == null ? "" : this.getObjectAt(index).getName() + "    ";
    }

    public TourModel getObjectAt(int index) {
        return index == -1 ? null : this.data.get(index);
    }

    public void addElement(TourModel tourModel) {
        this.data.add(this.getSize(), tourModel);
        this.setSize(this.data.size());
    }

    @Override
    public void removeElementAt(int index) {
        this.data.remove(index);
        this.setSize(this.data.size());
    }

    public void setData(List<TourModel> data) {
        if (this.data == null) {
            this.data = new ArrayList<TourModel>(data);
        } else {
            this.data.clear();
            for (TourModel t : data) {
                this.addElement(t);
            }
        }
    }

    public void removeElementWithId(Long id) {
        for (int index = 0; index < this.data.size(); ++index) {
            if (!this.data.get(index).getTempUUID().equals(id)) continue;
            this.removeElementAt(index);
            return;
        }
    }

    public List<TourModel> getData() {
        return this.data;
    }
}

