/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.tour.TourListModel;
import de.datomino.peppergis.tourmanager.util.TourTimeBucketModel;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.time.TimeUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.ktde.util.datatypes.Tupel;

public class TourListGui {
    private JList tourGuiJList;
    private List<TourModel> unplannedTours;
    private TourListModel tourListModel;
    private TourTimeBucketModel tourBucket;

    public JScrollPane createTourGui(TourManagerCalendarGui tourManagerCalendarGui) {
        ModelEnviroment modelEnviroment = tourManagerCalendarGui.getModelEnviroment();
        this.tourBucket = new TourTimeBucketModel(modelEnviroment, tourManagerCalendarGui.getBusyHandler());
        TourCaller tourCaller = modelEnviroment.getAllCaller().getTourCaller();
        this.unplannedTours = tourCaller.fetchToursInTimeWindows(null, null, true);
        this.tourListModel = new TourListModel(new ArrayList<TourModel>(this.unplannedTours));
        this.tourGuiJList = new JList(this.tourListModel);
        this.tourGuiJList.setSelectionMode(1);
        JScrollPane listView = new JScrollPane(this.tourGuiJList);
        listView.setPreferredSize(FormUtil.SIZEOFLISTANDTREE);
        return listView;
    }

    public boolean isInList(Point location) {
        Point retangleList = this.tourGuiJList.getLocationOnScreen();
        int width = this.tourGuiJList.getWidth();
        int height = this.tourGuiJList.getHeight();
        return location.x > retangleList.x && location.x < retangleList.x + width && location.y > retangleList.y && location.y < retangleList.y + height;
    }

    public Set<TourModel> getPlannedToursInWeek(Date ... plannedTimes) {
        HashSet<TourModel> plannedToursInWeek = new HashSet<TourModel>();
        for (Date plannedTime : plannedTimes) {
            plannedToursInWeek.addAll(this.getTousInSamedWeek(plannedTime));
        }
        return plannedToursInWeek;
    }

    public Set<TourModel> getPlannedToursInDay(Date ... plannedTimes) {
        HashSet<TourModel> plannedToursInDay = new HashSet<TourModel>();
        for (Date plannedTime : plannedTimes) {
            Date start = TimeUtil.normalize(plannedTime);
            Date end = TimeUtil.setTime(plannedTime, 23, 59, 59);
            plannedToursInDay.addAll(this.tourBucket.findObjects(start, end));
        }
        return plannedToursInDay;
    }

    public JList getTourJList() {
        return this.tourGuiJList;
    }

    public List<TourModel> getToursForTable() {
        return this.tourListModel.getData();
    }

    public TourListModel getTourListModel() {
        return this.tourListModel;
    }

    public Set<TourModel> getAllTours() {
        HashSet<TourModel> allTours = new HashSet<TourModel>();
        allTours.addAll(this.tourBucket.getAllObject());
        allTours.addAll(this.unplannedTours);
        return allTours;
    }

    public TourModel getSelTour() {
        int selIndex = this.tourGuiJList.getSelectedIndex();
        return this.tourListModel.getObjectAt(selIndex);
    }

    public void setEnabled(Boolean enabled) {
        this.tourGuiJList.setEnabled(enabled);
    }

    public void createTourList() {
        for (TourModel tour : this.tourBucket.getAllObject()) {
            if (tour.getPlannedStartTime() != null && tour.getDeliverer() != null || this.unplannedTours.contains(tour)) continue;
            this.unplannedTours.add(tour);
        }
        HashSet<TourModel> deleted = new HashSet<TourModel>();
        for (TourModel tour : this.unplannedTours) {
            if (tour == null || tour.isDeleted()) {
                deleted.add(tour);
                continue;
            }
            if (tour.getPlannedStartTime() == null || tour.getDeliverer() == null) continue;
            this.tourBucket.addObject(tour);
        }
        this.unplannedTours.removeAll(deleted);
        this.tourListModel.setData(this.unplannedTours);
    }

    public void clearTourList() {
        this.tourListModel.clear();
    }

    public void addNewTour(TourModel newTour) {
        if (newTour.getPlannedStartTime() == null && !this.unplannedTours.contains(newTour)) {
            this.unplannedTours.add(newTour);
            this.tourListModel.addElement(newTour);
        } else {
            this.tourBucket.addObject(newTour);
        }
        this.tourGuiJList.clearSelection();
    }

    private Collection<TourModel> getTousInSamedWeek(Date date) {
        Tupel<Date, Date> weekTupel = TimeUtil.getWeekTupel(date);
        return this.tourBucket.findObjects(weekTupel.getElement1(), weekTupel.getElement2());
    }

    public void remove(TourModel tour) {
        this.tourBucket.removeObject(tour);
        this.unplannedTours.remove(tour);
        this.getTourListModel().removeElement(tour);
    }
}

