/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.common.DialogDisposeAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.TourDifficultyLevelModel;
import de.datomino.peppergis.client.model.tour.TourDifficultyLevelModelImpl;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.type.TourDifficultyLevelType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Tupel;

public class TourDifficultyLevelConfigurationDialog
extends CommonDialog {
    private static final long serialVersionUID = -2016028168193189035L;
    private ModelEnviroment modelEnviroment;
    private List<Tupel<TourDifficultyLevelModel, JPanel>> difficultyLevels;
    private JPanel difficultyLevelsPane;

    public TourDifficultyLevelConfigurationDialog(Component parent, ModelEnviroment modelEnviroment) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.difficultyLevel.config", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.pack();
        this.center();
        UndoManager undoManager = this.modelEnviroment.getUndoManager();
        undoManager.finishTransaction("");
        undoManager.startTransaction();
        Collection<TourDifficultyLevelModel> allTourDifficultyLevels = this.modelEnviroment.getAllCaller().getTourCaller().fetchAllTourDifficultyLevels();
        this.difficultyLevels = new ArrayList<Tupel<TourDifficultyLevelModel, JPanel>>(allTourDifficultyLevels.size());
        boolean foundDefault = false;
        for (TourDifficultyLevelModel dl : allTourDifficultyLevels) {
            if (dl.getType() == TourDifficultyLevelType.DEFAULT) {
                foundDefault = true;
            }
            this.difficultyLevels.add(new Tupel<TourDifficultyLevelModel, Object>(dl, null));
        }
        if (!foundDefault) {
            TourDifficultyLevelModelImpl newDl = new TourDifficultyLevelModelImpl();
            newDl.setValue(100.0);
            newDl.setType(TourDifficultyLevelType.DEFAULT);
            this.difficultyLevels.add(new Tupel<TourDifficultyLevelModelImpl, Object>(newDl, null));
        }
        this.fillData();
        this.setVisible(true);
    }

    private void fillData() {
        this.sortDifficultyLevels();
        this.difficultyLevelsPane.removeAll();
        JPanel header = new JPanel(new GridLayout(1, 4));
        header.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.difficultyLevel", new Serializable[0]) + "(%)"));
        header.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.lower.limit", new Serializable[0])));
        header.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.attributevaluedescriptor.upper.limit", new Serializable[0])));
        header.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.type", new Serializable[0])));
        header.setMinimumSize(new Dimension(10, 30));
        header.setMaximumSize(new Dimension(10000, 30));
        this.difficultyLevelsPane.add(header);
        for (Tupel<TourDifficultyLevelModel, JPanel> tupel : this.difficultyLevels) {
            JPanel pane = tupel.getElement2();
            if (pane == null) {
                pane = new JPanel(new GridLayout(1, 4));
                TourDifficultyLevelModel dl = tupel.getElement1();
                if (dl.getType() == null) {
                    dl.setType(TourDifficultyLevelType.AVERAGE_DISTANCE);
                }
                Holder<TourDifficultyLevelModel> holder = new Holder<TourDifficultyLevelModel>(dl);
                pane.add(ClientSwingUtil.createParameterTextField(10, ClientFormUtil.getNumberString(dl.getValue()), true, "Value", holder, this.getParent()));
                if (dl.getType() == TourDifficultyLevelType.DEFAULT) {
                    JTextField textField = new JTextField();
                    textField.setEditable(false);
                    pane.add(textField);
                    textField = new JTextField();
                    textField.setEditable(false);
                    pane.add(textField);
                } else {
                    pane.add(ClientSwingUtil.createParameterTextField(10, ClientFormUtil.getNumberString(dl.getLowerLimit()), true, "LowerLimit", holder, this.getParent()));
                    pane.add(ClientSwingUtil.createParameterTextField(10, ClientFormUtil.getNumberString(dl.getUpperLimit()), true, "UpperLimit", holder, this.getParent()));
                }
                pane.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessageForEnum(dl.getType())));
                pane.setMinimumSize(new Dimension(10, 30));
                pane.setMaximumSize(new Dimension(10000, 30));
                tupel.setElement2(pane);
            }
            this.difficultyLevelsPane.add(pane);
        }
        this.difficultyLevelsPane.validate();
        this.repaint(10L);
    }

    private void sortDifficultyLevels() {
        Collections.sort(this.difficultyLevels, new Comparator<Tupel<TourDifficultyLevelModel, JPanel>>(){

            @Override
            public int compare(Tupel<TourDifficultyLevelModel, JPanel> o1, Tupel<TourDifficultyLevelModel, JPanel> o2) {
                if (o1.getElement1().getType() == TourDifficultyLevelType.DEFAULT) {
                    return -1;
                }
                if (o2.getElement1().getType() == TourDifficultyLevelType.DEFAULT) {
                    return 1;
                }
                double d1 = TourDifficultyLevelConfigurationDialog.this.getLowerLimit(o1.getElement1());
                double d2 = TourDifficultyLevelConfigurationDialog.this.getLowerLimit(o2.getElement1());
                return Double.compare(d1, d2);
            }
        });
    }

    private boolean checkValid() {
        this.sortDifficultyLevels();
        boolean b = true;
        double lastUpperLimit = -1.0;
        for (Tupel<TourDifficultyLevelModel, JPanel> tupel : this.difficultyLevels) {
            double upperLimit;
            TourDifficultyLevelModel difficultyLevel = tupel.getElement1();
            if (difficultyLevel.getType() == TourDifficultyLevelType.DEFAULT) continue;
            double lowerLimit = this.getLowerLimit(difficultyLevel);
            double d = upperLimit = difficultyLevel.getUpperLimit() == null ? Double.MAX_VALUE : difficultyLevel.getUpperLimit();
            if (lowerLimit >= upperLimit || lastUpperLimit >= lowerLimit) {
                b = false;
            }
            lastUpperLimit = upperLimit;
        }
        if (!b) {
            JOptionPane.showMessageDialog(this.getParent(), ModelEnviroment.getMessageResolver().resolveMessage("messages.error.invalidConfiguration", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.warning", new Serializable[0]), 2);
        }
        return b;
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 7098722661210720603L;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!TourDifficultyLevelConfigurationDialog.this.checkValid()) {
                    return;
                }
                UndoManager undoManager = TourDifficultyLevelConfigurationDialog.this.modelEnviroment.getUndoManager();
                undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.difficultyLevel.config", new Serializable[0]));
                try {
                    undoManager.storeTransactions();
                    TourDifficultyLevelConfigurationDialog.this.dispose();
                }
                catch (ValidateException ex) {
                    undoManager.handleValidateException(ex);
                }
            }
        };
    }

    @Override
    protected Action getCancelAction() {
        return new DialogDisposeAction(this){
            private static final long serialVersionUID = 5159193120169120226L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = TourDifficultyLevelConfigurationDialog.this.modelEnviroment.getUndoManager();
                undoManager.rollbackTransaction();
                TourDifficultyLevelConfigurationDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        JPanel buttonPane = new JPanel(new GridLayout(1, 2));
        JButton add = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 2801580650971816191L;

            @Override
            public void actionPerformed(ActionEvent e) {
                TourDifficultyLevelModelImpl newDl = new TourDifficultyLevelModelImpl();
                newDl.setType(TourDifficultyLevelType.AVERAGE_DISTANCE);
                TourDifficultyLevelConfigurationDialog.this.difficultyLevels.add(new Tupel<TourDifficultyLevelModelImpl, Object>(newDl, null));
                TourDifficultyLevelConfigurationDialog.this.fillData();
            }
        });
        add.setText("+");
        buttonPane.add(add);
        JButton remove = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 8274177167380769548L;

            @Override
            public void actionPerformed(ActionEvent e) {
                List dls = TourDifficultyLevelConfigurationDialog.this.difficultyLevels;
                if (dls != null && !dls.isEmpty()) {
                    Tupel last = (Tupel)dls.remove(dls.size() - 1);
                    ((TourDifficultyLevelModel)last.getElement1()).delete();
                }
                TourDifficultyLevelConfigurationDialog.this.fillData();
            }
        });
        remove.setText("-");
        buttonPane.add(remove);
        this.difficultyLevelsPane = new JPanel();
        BoxLayout boxLayout = new BoxLayout(this.difficultyLevelsPane, 1);
        this.difficultyLevelsPane.setLayout(boxLayout);
        JScrollPane scrollPane = new JScrollPane(this.difficultyLevelsPane);
        scrollPane.setPreferredSize(new Dimension(700, 200));
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)scrollPane, "Center");
        main.add((Component)buttonPane, "South");
        return main;
    }

    private double getLowerLimit(TourDifficultyLevelModel difficultyLevel) {
        if (difficultyLevel.getType() != null && difficultyLevel.getType() == TourDifficultyLevelType.DEFAULT) {
            return 0.0;
        }
        if (difficultyLevel.getLowerLimit() == null && difficultyLevel.getUpperLimit() == null) {
            return Double.MAX_VALUE;
        }
        if (difficultyLevel.getLowerLimit() == null) {
            return 0.0;
        }
        return difficultyLevel.getLowerLimit();
    }
}

