/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.DelivererModelImpl;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import javax.swing.table.DefaultTableModel;

public class PlanTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 7246958065068867311L;

    @Override
    public String getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            DelivererModel delivererModel = (DelivererModel)this.getObjectAt(rowIndex, columnIndex);
            if (delivererModel == null) {
                return "";
            }
            return this.getContentStringInMultiLineForDeliverer(delivererModel);
        }
        TourModel tourModel = (TourModel)this.getObjectAt(rowIndex, columnIndex);
        return this.getContentStringInMultiLineForTour(tourModel);
    }

    public Object getObjectAt(int rowIndex, int columnIndex) {
        return this.getDataVector().get(rowIndex).get(columnIndex);
    }

    public void setObjectAt(Object object, int rowIndex, int columnIndex) {
        this.getDataVector().get(rowIndex).setElementAt(object, columnIndex);
    }

    public Class<? extends Object> getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void addNullRow() {
        Object[] rowData = new Object[this.getColumnCount()];
        rowData[0] = new DelivererModelImpl(new Long(0L), null);
        for (int col = 1; col < this.getColumnCount(); ++col) {
            rowData[col] = new TourModelImpl(new Long(0L), null);
        }
        this.addRow(rowData);
    }

    private String getContentStringInMultiLineForDeliverer(DelivererModel delivererModel) {
        if (delivererModel.getTempUUID().equals(new Long(0L))) {
            return "";
        }
        String displayContent = DelivererModelUtil.getDisplayForPlanTable(delivererModel, true, "") + "\n";
        return displayContent;
    }

    private String getContentStringInMultiLineForTour(TourModel tourModel) {
        if (tourModel == null || tourModel.getTempUUID().equals(new Long(0L))) {
            return "";
        }
        return TourModelUtil.getDisplayForPlanTable(tourModel);
    }
}

