/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.AbstractRoutingWithComboBoxDialog;
import de.datomino.peppergis.tourmanager.handler.action.routing.CalculateTourWithComboBoxAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class CalculateSettingDialog
extends AbstractRoutingWithComboBoxDialog {
    private static final long serialVersionUID = -2850361194772334944L;
    private static boolean update;

    public CalculateSettingDialog(Collection<TourModel> tours, TourCaller tourCaller, boolean importOrder, RouteVehicleType routeVehicleType, RouteType routeType, boolean poiSelectionActive, Component parent, ModelEnviroment modelEnviroment) {
        super(tours, tourCaller, routeVehicleType, routeType, importOrder, poiSelectionActive, parent, modelEnviroment);
    }

    @Override
    protected JPanel createSettingPanel() {
        int rows = 10;
        if (this.poiSelectionActive) {
            rows += 2;
        }
        if (this.saveSelectionActive) {
            ++rows;
        }
        JPanel settingPanel = new JPanel(new GridLayout(rows, 1));
        JLabel startPointLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.start", new Serializable[0]));
        settingPanel.add(startPointLabel);
        this.startPointComboBox = new JComboBox<String>(TourModelUtil.CALCULATESTARTITEMS);
        this.startPointComboBox.setActionCommand("startpoint");
        this.startPointComboBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        this.startPointComboBox.setSelectedIndex(1);
        settingPanel.add(this.startPointComboBox);
        JLabel endPointLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.end", new Serializable[0]));
        settingPanel.add(endPointLabel);
        this.endPointComboBox = new JComboBox<String>(TourModelUtil.CALCULATEENDITEMS);
        this.endPointComboBox.setActionCommand("endpoint");
        this.endPointComboBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        this.endPointComboBox.setSelectedIndex(1);
        settingPanel.add(this.endPointComboBox);
        super.addPoiComboBox(settingPanel);
        super.addStartTimeSelection(settingPanel);
        super.addSaveSelection(settingPanel);
        settingPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return settingPanel;
    }

    @Override
    protected JPanel createButtonPanel() {
        String name = ModelEnviroment.getMessageResolver().resolveMessage("gui.route.calculate", new Serializable[]{""});
        if (this.importOrder) {
            name = ModelEnviroment.getMessageResolver().resolveMessage("gui.route.reset", new Serializable[0]);
        }
        JButton calculateButton = new JButton(new CalculateTourWithComboBoxAction(name, this, this.parent));
        JButton cancelButton = new JButton(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.cancel", new Serializable[0])){
            private static final long serialVersionUID = 6620270720282784243L;

            @Override
            public void actionPerformed(ActionEvent e) {
                CalculateSettingDialog.this.cancel();
            }
        });
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.add((Component)calculateButton, "West");
        buttonPanel.add((Component)cancelButton, "East");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        return buttonPanel;
    }

    @Override
    protected void updateDialog() {
        if (this.getCalculateType().isStartWithPoi() || this.getCalculateType().isEndWithPoi()) {
            this.poiComboBox.setEnabled(true);
        } else {
            this.poiComboBox.setEnabled(false);
        }
    }

    protected void cancel() {
        update = false;
        this.dispose();
    }

    public static boolean createAndShow(Collection<TourModel> tours, TourCaller tourCaller, Component owner, boolean importOrder, RouteVehicleType routeVehicleType, RouteType routeType, boolean poiSelectionActive, ModelEnviroment modelEnviroment) {
        update = true;
        CalculateSettingDialog calculateSettingDialog = new CalculateSettingDialog(tours, tourCaller, importOrder, routeVehicleType, routeType, poiSelectionActive, owner, modelEnviroment);
        Point location = owner.getLocationOnScreen();
        calculateSettingDialog.setLocation(location.x + 25, location.y + 25);
        calculateSettingDialog.setModal(true);
        calculateSettingDialog.pack();
        calculateSettingDialog.setVisible(true);
        return update;
    }
}

