/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.tour;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourModelImpl;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.tourmanager.gui.base.BranchModelListCellRenderer;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.handler.action.tour.AddTourActions;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.ktde.util.datatypes.Tripel;

public class AddTourDialog
extends JDialog {
    private static final long serialVersionUID = -1695099873480570247L;
    private AddTourActions addTourActions;
    private TourModel tourModel;
    private boolean editable;
    private boolean savePressend;
    private JButton saveTourButton;
    private JButton cancelTourButton;
    private JButton addTourPartButton;
    private JButton removeTourPartButton;
    private JTextField nameField = new JTextField("");
    private JTextArea infoArea = new JTextArea();
    private List<Tripel<JLabel, JTextField, JTextArea>> tourPartFields = new ArrayList<Tripel<JLabel, JTextField, JTextArea>>(1);
    private JPanel tourPartsPanel = new JPanel(null);
    private JComboBox branchComboBox = new JComboBox();
    private JPanel inputPanel = new JPanel(null);
    private TourManagerCalendarGui tourManagerCalendarGui;

    public AddTourDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
    }

    public AddTourDialog(TourManagerCalendarGui tourManagerCalendarGui) {
        this((Frame)null, ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.newTour", new Serializable[0]) + " ...", true);
        try {
            this.setIconImage(ImageIO.read(AddTourDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.tourManagerCalendarGui = tourManagerCalendarGui;
    }

    private void createPanel() {
        TourCaller tourCaller = this.tourManagerCalendarGui.getActions().getTourCaller();
        this.addTourActions = new AddTourActions(this);
        JLabel nameLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]) + ": ");
        nameLabel.setBounds(5, 10, 100, 25);
        this.inputPanel.add(nameLabel);
        this.nameField.setBounds(105, 10, 480, 25);
        this.inputPanel.add(this.nameField);
        JLabel branchLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.group", new Serializable[0]) + ": ");
        branchLabel.setBounds(5, 45, 100, 25);
        this.inputPanel.add(branchLabel);
        List<BranchModel> branchs = tourCaller.fetchAllBranchs();
        branchs.add(0, null);
        this.branchComboBox = new JComboBox<Object>(branchs.toArray());
        this.branchComboBox.setRenderer(new BranchModelListCellRenderer());
        this.branchComboBox.setBounds(105, 45, 480, 25);
        this.inputPanel.add(this.branchComboBox);
        JLabel infoLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]) + ": ");
        infoLabel.setBounds(5, 80, 100, 25);
        this.inputPanel.add(infoLabel);
        this.inputPanel.add(ClientSwingUtil.scrollTextArea(this.infoArea, new Rectangle(105, 80, 480, 50), true));
        JLabel tourpartsLabel = new JLabel("<html>" + ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.tourPart", new Serializable[0]) + ": </html>");
        tourpartsLabel.setBounds(5, 140, 100, 25);
        this.inputPanel.add(tourpartsLabel);
        this.addTourPartButton = new JButton(this.addTourActions.getAddTourPartAction());
        this.addTourPartButton.setText("+");
        this.addTourPartButton.setBounds(5, 175, 15, 15);
        this.addTourPartButton.setBorder(BorderFactory.createEmptyBorder());
        this.inputPanel.add(this.addTourPartButton);
        this.removeTourPartButton = new JButton(this.addTourActions.getRemoveTourPartAction());
        this.removeTourPartButton.setText("-");
        this.removeTourPartButton.setBounds(25, 175, 15, 15);
        this.removeTourPartButton.setBorder(BorderFactory.createEmptyBorder());
        this.inputPanel.add(this.removeTourPartButton);
        this.tourPartFields.add(new Tripel<JLabel, JTextField, JTextArea>(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.part", new Serializable[0]) + "1: "), new JTextField(""), new JTextArea("")));
        this.tourPartFields.get(0).getElement1().setBounds(0, 0, 50, 25);
        this.tourPartsPanel.add(this.tourPartFields.get(0).getElement1());
        this.tourPartFields.get(0).getElement2().setBounds(50, 0, 410, 25);
        this.tourPartsPanel.add(this.tourPartFields.get(0).getElement2());
        this.tourPartsPanel.add(ClientSwingUtil.scrollTextArea(this.tourPartFields.get(0).getElement3(), new Rectangle(0, 30, 460, 50), true));
        JScrollPane tourPartsScrollPane = new JScrollPane(this.tourPartsPanel);
        tourPartsScrollPane.setBounds(105, 140, 480, 270);
        tourPartsScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.inputPanel.add(tourPartsScrollPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.saveTourButton = new JButton(this.addTourActions.getSaveTourModelAction());
        this.saveTourButton.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0]));
        buttonPanel.add(this.saveTourButton);
        this.cancelTourButton = new JButton(this.addTourActions.getCanelTourModelAction());
        this.cancelTourButton.setText(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.close", new Serializable[0]));
        buttonPanel.add(this.cancelTourButton);
        this.inputPanel.setSize(590, 450);
        this.inputPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.inputPanel, "Center");
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    public TourModel showDialog() {
        this.createPanel();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        this.setLocation(Math.max(0, (screenSize.width - frameSize.width) / 4 - 300), (screenSize.height - frameSize.height) / 4);
        this.setLocale(Locale.GERMAN);
        this.setPreferredSize(new Dimension(600, 500));
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.pack();
        this.setVisible(true);
        if (this.savePressend) {
            this.addTourActions.updateTourModel();
        }
        return this.tourModel;
    }

    public void setSavePressend(boolean savePressend) {
        this.savePressend = savePressend;
    }

    public JTextField getNameField() {
        return this.nameField;
    }

    public JTextArea getInfoArea() {
        return this.infoArea;
    }

    public List<Tripel<JLabel, JTextField, JTextArea>> getTourPartFields() {
        return this.tourPartFields;
    }

    public JPanel getTourPartsPanel() {
        return this.tourPartsPanel;
    }

    public JPanel getInputPanel() {
        return this.inputPanel;
    }

    public TourModel getTourModel() {
        if (this.tourModel == null) {
            this.tourModel = new TourModelImpl();
        }
        return this.tourModel;
    }

    public JComboBox getBranchComboBox() {
        return this.branchComboBox;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public ModelEnviroment getModelEnviroment() {
        return this.tourManagerCalendarGui.getModelEnviroment();
    }
}

