/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.timeline;

import de.datomino.logistic.LogisticException;
import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.communication.tour.SimpleTourRoutingContext;
import de.datomino.peppergis.client.gui.common.TimeBarChartPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import de.datomino.peppergis.tourmanager.gui.timeline.TourTimeLineGui;
import de.datomino.peppergis.tourmanager.gui.tracking.TourTrackingResult;
import de.datomino.peppergis.tourmanager.handler.action.stop.SearchStopsAction;
import de.datomino.peppergis.type.MobileGpsStatus;
import de.datomino.peppergis.type.RendererType;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.util.NumericUtil;
import de.datomino.util.swing.ExceptionMessageDialog;
import de.datomino.util.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

public class TourTimeLinePane
extends TimeBarChartPane<TourTrackingResult> {
    private static final long serialVersionUID = -4008768281339357834L;
    private TourTimeLineGui tourTimeLineGui;
    private ModelEnviroment modelEnviroment;
    private Map<TourTrackingResult, List<TimeBarChartPane.TimeBar>> trackingBarMap = new HashMap<TourTrackingResult, List<TimeBarChartPane.TimeBar>>();
    private Map<TourModel, List<TimeBarChartPane.TimeBar>> serviceBarMap = new HashMap<TourModel, List<TimeBarChartPane.TimeBar>>();
    private Map<StopModel, Color> stopColorCache = new HashMap<StopModel, Color>();

    public TourTimeLinePane(TourTimeLineGui tourTimeLineGui, Date currentTime, ModelEnviroment modelEnviroment) {
        super(currentTime, currentTime, tourTimeLineGui.timeBlockSize, tourTimeLineGui.timeBlockCount, false);
        this.tourTimeLineGui = tourTimeLineGui;
        this.modelEnviroment = modelEnviroment;
    }

    @Override
    protected List<TimeBarChartPane.TimeBar> createTimeBarList(TourTrackingResult o) {
        ArrayList<TimeBarChartPane.TimeBar> list = new ArrayList<TimeBarChartPane.TimeBar>();
        list.addAll(this.getTrackingBars(o));
        list.addAll(this.getServiceBars(o.getTour()));
        return list;
    }

    private List<TimeBarChartPane.TimeBar> getTrackingBars(TourTrackingResult o) {
        if (!this.tourTimeLineGui.trackingTimeline) {
            return Collections.emptyList();
        }
        List<TimeBarChartPane.TimeBar> list = this.trackingBarMap.get(o);
        if (list == null || o.getIntervall() != this.tourTimeLineGui.trackingIntervall.intValue()) {
            Date barStart = o.getTour().getPlannedStartTime();
            Date barEnd = TourModelUtil.getPlannedEndTime(o.getTour());
            if (barStart != null && barEnd != null) {
                list = new ArrayList<TimeBarChartPane.TimeBar>();
                o.createTourTrackingList(Collections.emptySet(), this.tourTimeLineGui.trackingIntervall);
                int barHeight = this.tourTimeLineGui.tourTable.getRowHeight() / 2;
                for (TourTrackingResult.TourTrackingObject object : o.getTourTrackingList()) {
                    if (object.getStartTime() == null || object.getEndTime() == null) continue;
                    int duration = (int)((object.getEndTime().getTime() - object.getStartTime().getTime()) / 1000L);
                    TimeBarChartPane.TimeBar timeBar = new TimeBarChartPane.TimeBar(object, object.getStartTime(), duration, object.getColor(), barHeight);
                    list.add(timeBar);
                }
                if (!list.isEmpty()) {
                    list.get(0).addStart();
                    list.get(list.size() - 1).addEnd();
                }
                this.trackingBarMap.put(o, list);
            }
        }
        return list;
    }

    private List<TimeBarChartPane.TimeBar> getServiceBars(TourModel tour) {
        if (!this.tourTimeLineGui.serviceTimeline) {
            return Collections.emptyList();
        }
        List<TimeBarChartPane.TimeBar> list = this.serviceBarMap.get(tour);
        if (list == null) {
            list = new ArrayList<TimeBarChartPane.TimeBar>();
            for (TourPartModel part : tour.iterableTourParts()) {
                for (StopModel stop : part.iterableStops()) {
                    this.addServiceTimeBar(stop, list);
                }
            }
            this.serviceBarMap.put(tour, list);
        }
        return list;
    }

    private void addServiceTimeBar(final StopModel stop, List<TimeBarChartPane.TimeBar> list) {
        Date arrival = stop.getEstimatedTimeOfArrival();
        int duration = NumericUtil.getIntegerValue(stop.getEstimatedDurationSeconds());
        if (arrival == null || duration == 0) {
            return;
        }
        int barHeight = this.tourTimeLineGui.tourTable.getRowHeight() * 2 / 3;
        TimeBarChartPane.TimeBar timeBar = new TimeBarChartPane.TimeBar(stop, arrival, duration, Color.BLACK, barHeight){

            @Override
            protected Color getColor(Date date) {
                Date arrival;
                Color color = StopModelUtil.getColorOfStatus(stop, TourTimeLinePane.this.stopColorCache);
                Set<MobileGpsStatus> ss = StopModelUtil.getGpsStatuses(stop);
                if (color.equals(PeppergisConstants.SERVICE_NOT_DONE_COLOR) && date.before(arrival = stop.getEstimatedTimeOfArrival())) {
                    color = PeppergisConstants.SERVICE_OPEN_COLOR;
                }
                if (ss.contains((Object)MobileGpsStatus.OK)) {
                    color = PeppergisConstants.SERVICE_NOT_DONE_COLOR;
                    this.setRendererType(RendererType.HATCH_LINE);
                } else {
                    this.setRendererType(RendererType.PLAIN);
                }
                return color;
            }
        };
        timeBar.setAllowedMouseClick(true);
        list.add(timeBar);
    }

    @Override
    protected List<String> getObjectInfos(Collection<Object> os) {
        ArrayList<String> infos = new ArrayList<String>();
        for (Object o : os) {
            if (!(o instanceof TourTrackingResult)) continue;
            TourModel tour = ((TourTrackingResult)o).getTour();
            infos.add(tour.getName());
            infos.add(ClientFormUtil.dateToString(tour.getPlannedStartTime()) + " - " + ClientFormUtil.dateToString(TourModelUtil.getPlannedEndTime(tour)));
        }
        return infos;
    }

    @Override
    protected void handleDoubleClicked(Collection<Object> os) {
        ArrayList<StopModel> list = new ArrayList<StopModel>();
        for (Object o : os) {
            if (!(o instanceof StopModel)) continue;
            list.add((StopModel)o);
        }
        Collections.sort(list, new StringComparator<StopModel>(false){

            @Override
            protected String getString(StopModel o) {
                return o.getName();
            }
        });
        AddAndUpdateStopDialog stopDialog = new AddAndUpdateStopDialog(this.modelEnviroment, true, null);
        stopDialog.showDialog(list, true, (Component)this.tourTimeLineGui);
    }

    @Override
    protected void fireDragAndDrop(Date time, Collection<Object> os) {
        UndoManager undoManager = this.modelEnviroment.getUndoManager();
        undoManager.startTransaction();
        HashSet<TourModel> updatedTours = new HashSet<TourModel>();
        for (Object o : os) {
            if (o instanceof StopModel) {
                StopModel stop = (StopModel)o;
                if (!this.tourTimeLineGui.updateStopSortOrder(time, stop)) continue;
                updatedTours.add(stop.getTourPart().getTour());
                continue;
            }
            if (!(o instanceof TourModel)) continue;
            TourModel tour = (TourModel)o;
            tour.setPlannedStartTime(time);
            updatedTours.add(tour);
        }
        this.afterUpdate(updatedTours);
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.afterRouting", Integer.valueOf(updatedTours.size())));
    }

    @Override
    protected JPopupMenu createPopupMenu(Date time, final Collection<Object> os) {
        StopModel first = null;
        for (Object o : os) {
            if (!(o instanceof StopModel)) continue;
            first = (StopModel)o;
            break;
        }
        if (first == null) {
            return null;
        }
        final StopModel middle = first;
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.add(new SearchStopsAction(this.modelEnviroment, this, ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.insert.before", new Serializable[0])){
            private static final long serialVersionUID = 7914297747081668040L;

            @Override
            protected void fireSelection(Collection<StopModel> stops) {
                TourTimeLinePane.this.insertStops(stops, middle, true);
            }
        });
        popupMenu.add(new SearchStopsAction(this.modelEnviroment, this, ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.insert.after", new Serializable[0])){
            private static final long serialVersionUID = 7914297747081668040L;

            @Override
            protected void fireSelection(Collection<StopModel> stops) {
                TourTimeLinePane.this.insertStops(stops, middle, false);
            }
        });
        popupMenu.add(new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.removefromroute", new Serializable[0])){
            private static final long serialVersionUID = 1263603028851487966L;

            @Override
            public void actionPerformed(ActionEvent e) {
                UndoManager undoManager = TourTimeLinePane.this.modelEnviroment.getUndoManager();
                undoManager.startTransaction();
                HashSet<TourModel> updatedTours = new HashSet<TourModel>();
                for (Object o : os) {
                    if (!(o instanceof StopModel)) continue;
                    StopModel stop = (StopModel)o;
                    TourPartModel tourPart = stop.getTourPart();
                    tourPart.removeStop(stop);
                    updatedTours.add(tourPart.getTour());
                }
                TourTimeLinePane.this.afterUpdate(updatedTours);
                undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.afterRouting", Integer.valueOf(updatedTours.size())));
            }
        });
        return popupMenu;
    }

    private void afterUpdate(Set<TourModel> updatedTours) {
        TourCaller tourCaller = this.modelEnviroment.getAllCaller().getTourCaller();
        for (TourModel tour : updatedTours) {
            if (tour == null) continue;
            TourPartModel firstPart = tour.getTourPartAt(0);
            try {
                tourCaller.calculateTour(tour, firstPart.getRouteVehicleType(), firstPart.getRouteType(), true, this.modelEnviroment, null, true, SimpleTourRoutingContext.INSTANCE);
            }
            catch (LogisticException e) {
                BufferedImage image;
                TourTimeLineGui.LOGGER.error("", e);
                try {
                    image = ImageIO.read(TourTimeLinePane.class.getResourceAsStream("/images/pepper.png"));
                }
                catch (IOException ioEx) {
                    throw new RuntimeException(ioEx);
                }
                ExceptionMessageDialog dialog = new ExceptionMessageDialog(SwingUtils.findWindowParent(this), e, image);
                dialog.setVisible(true);
            }
            this.serviceBarMap.remove(tour);
        }
        this.clearCache(updatedTours);
    }

    protected void clearCache(Collection<TourModel> tours) {
        for (TourModel tour : tours) {
            if (tour == null) continue;
            TourTrackingResult foundTracking = null;
            for (TourTrackingResult tracking : this.trackingBarMap.keySet()) {
                if (!tracking.getTour().equals(tour)) continue;
                foundTracking = tracking;
                break;
            }
            this.trackingBarMap.remove(foundTracking);
            this.serviceBarMap.remove(tour);
            for (StopModel stop : TourModelUtil.getAllStops(tour, true)) {
                this.stopColorCache.remove(stop);
            }
        }
        this.repaint(10L);
    }

    private void insertStops(Collection<StopModel> stops, StopModel middle, boolean before) {
        UndoManager undoManager = this.modelEnviroment.getUndoManager();
        undoManager.startTransaction();
        HashSet<TourModel> updatedTours = new HashSet<TourModel>();
        TourPartModel tourPart = middle.getTourPart();
        updatedTours.add(tourPart.getTour());
        int sortOrder = middle.getSortOrder() + (before ? 0 : 1);
        for (StopModel stop : stops) {
            TourPartModel oldPart = stop.getTourPart();
            if (oldPart != null) {
                updatedTours.add(oldPart.getTour());
            }
            tourPart.insertStop(stop, sortOrder);
        }
        this.afterUpdate(updatedTours);
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.afterRouting", Integer.valueOf(updatedTours.size())));
    }
}

