/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop.locationcapturing.overwrite;

import de.datomino.peppergis.client.gui.address.BlockAdressPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.common.DefaultSimplePointRenderer;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.base.ImportedLocationModelImpl;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.mobile.LocationCapturingModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.ParcelModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.client.util.model.location.ParcelLocationWrapper;
import de.datomino.peppergis.tourmanager.gui.stop.locationcapturing.overwrite.EqualOrSimilarPane;
import de.datomino.peppergis.type.ImportedLocationStatus;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.international.country.Country;
import de.datomino.util.international.country.CountryUtil;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class LocationCapturingOverwritePane
extends JPanel {
    private static final long serialVersionUID = 7606018296298817414L;
    private static final String EMPTY = "EMPTY";
    private static final String EQUAL_OR_SIMILAR = "EQUAL_OR_SIMILAR";
    private StopModel stop;
    private LocationCapturingModel locationCapturing;
    private NavigatorPanel navigatorPanel;
    private ModelEnviroment modelEnviroment;
    private JRadioButton useAddress;
    private JRadioButton useCoords;
    private JRadioButton useAddressAndCoords;
    private JRadioButton useEqualOrSimilar;
    private JRadioButton useCreateNewImportedLocation;
    private CardLayout solutionDetailLayout;
    private JPanel solutionDetailPanel;
    private EqualOrSimilarPane equalOrSimilarPane;
    private DefaultSimplePointRenderer equalOrSimilarRenderer;
    private DefaultSimplePointRenderer stopRenderer;

    public LocationCapturingOverwritePane(StopModel stop, LocationCapturingModel locationCapturing, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.stop = stop;
        this.locationCapturing = locationCapturing;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel upperPanel = new JPanel(new SpringLayout());
        JPanel upperPanel1 = this.createAddressPanel();
        upperPanel.add(upperPanel1);
        JPanel upperPanel2 = this.createSolutionPanel();
        upperPanel.add(upperPanel2);
        SpringUtilities.makeCompactGrid(upperPanel, 2, 1, 2, 2, 2, 2);
        this.add((Component)upperPanel, "North");
        this.createNavigatorPanel();
        this.add((Component)this.navigatorPanel, "Center");
        if (this.equalOrSimilarPane != null) {
            this.equalOrSimilarPane.setNavigatorPanel(this.navigatorPanel);
            this.equalOrSimilarPane.setLocationCapturingRenderer(this.equalOrSimilarRenderer);
        }
    }

    private void createNavigatorPanel() {
        this.navigatorPanel = new NavigatorPanel(0.0, 0.0, OpenStreetmapViewFactory.INSTANCE, (Container)this);
        this.navigatorPanel.setSize(200, 200);
        this.navigatorPanel.setPreferredSize(new Dimension(200, 200));
        this.navigatorPanel.setPanning(true);
        this.navigatorPanel.getPanningAction().setSelected(true);
        this.navigatorPanel.setCursor(Cursor.getDefaultCursor());
        this.navigatorPanel.addRenderer(new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties()));
        this.stopRenderer = new DefaultSimplePointRenderer(Color.GREEN);
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(this.stop.getLocation());
        final ImmutablePoint stopGeom = locationWrapper.getGeoLocation();
        this.stopRenderer.setPoint(stopGeom);
        this.navigatorPanel.addRenderer(this.stopRenderer);
        DefaultSimplePointRenderer capRenderer = new DefaultSimplePointRenderer(Color.RED);
        final ImmutablePoint capGeom = this.locationCapturing.getGeoLocation();
        capRenderer.setPoint(capGeom);
        this.navigatorPanel.addRenderer(capRenderer);
        this.equalOrSimilarRenderer = new DefaultSimplePointRenderer(Color.BLUE);
        this.navigatorPanel.addRenderer(this.equalOrSimilarRenderer);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LocationCapturingOverwritePane.this.navigatorPanel.center(Arrays.asList(stopGeom.getCoordinate(), capGeom.getCoordinate()), 10);
            }
        });
    }

    private JPanel createSolutionPanel() {
        LocationWrapper stopLocationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(this.stop.getLocation());
        LocationWrapper captLocationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(this.locationCapturing);
        boolean addressEqual = stopLocationWrapper.isAddressEqual(captLocationWrapper, false);
        boolean coordsEqual = stopLocationWrapper.isCoordEqual(captLocationWrapper, 1.0);
        boolean isParcel = stopLocationWrapper instanceof ParcelLocationWrapper;
        if (isParcel) {
            ParcelModel parcel = ((ParcelLocationWrapper)stopLocationWrapper).getParcel();
            addressEqual = addressEqual || ParcelModelUtil.isEqualToAtLeastOneAlias(parcel, captLocationWrapper, false);
        }
        JPanel solutionPanel = new JPanel(new BorderLayout());
        JPanel solutionSelectionPanel = new JPanel(new BorderLayout());
        JPanel solutionSelectionPanel1 = new JPanel(new SpringLayout());
        this.solutionDetailLayout = new CardLayout();
        this.solutionDetailPanel = new JPanel(this.solutionDetailLayout);
        this.solutionDetailPanel.add((Component)new JPanel(), EMPTY);
        if (!addressEqual || !coordsEqual) {
            int rowCount = 0;
            SolutionSelectionActionListener solutionSelectionActionListener = new SolutionSelectionActionListener();
            ButtonGroup buttonGroup = new ButtonGroup();
            if (!coordsEqual) {
                this.useCoords = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.locationCapturing.useCoords", new Serializable[0]));
                buttonGroup.add(this.useCoords);
                solutionSelectionPanel1.add(this.useCoords);
                this.useCoords.addActionListener(solutionSelectionActionListener);
                ++rowCount;
            }
            if (!addressEqual && !isParcel) {
                this.useAddress = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.locationCapturing.useAddress", new Serializable[0]));
                buttonGroup.add(this.useAddress);
                solutionSelectionPanel1.add(this.useAddress);
                this.useAddress.addActionListener(solutionSelectionActionListener);
                ++rowCount;
            }
            if (!(addressEqual || coordsEqual || isParcel)) {
                this.useAddressAndCoords = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.locationCapturing.useAddressAndCoords", new Serializable[0]));
                buttonGroup.add(this.useAddressAndCoords);
                solutionSelectionPanel1.add(this.useAddressAndCoords);
                this.useAddressAndCoords.addActionListener(solutionSelectionActionListener);
                ++rowCount;
            }
            if (!addressEqual) {
                Collection<ImportedLocationModel> equalImportedLocations = this.modelEnviroment.getAllCaller().getStreetNetCaller().findImportLocationsExact(captLocationWrapper.getCountry(), captLocationWrapper.getPostcode(), captLocationWrapper.getCity(), captLocationWrapper.getDistrict(), captLocationWrapper.getStreet(), captLocationWrapper.getHousenumber(), captLocationWrapper.getHousenumberExtension(), true);
                List<Tupel<ParcelModel, Double>> parcelTupels = this.modelEnviroment.getAllCaller().getStreetSearchCaller().searchParcelsFuzzy(captLocationWrapper.getCountry(), captLocationWrapper.getPostcode(), captLocationWrapper.getCity(), captLocationWrapper.getDistrict(), captLocationWrapper.getCity(), StringUtil.nullToFallback(captLocationWrapper.getHousenumber(), null), captLocationWrapper.getHousenumberExtension());
                boolean equalImportedLocationsExisting = !equalImportedLocations.isEmpty();
                boolean parcelsExisting = !parcelTupels.isEmpty();
                ArrayList<ParcelModel> parcels = new ArrayList<ParcelModel>(parcelTupels.size());
                LinkedList<ParcelModel> equalParcels = new LinkedList<ParcelModel>();
                for (Tupel<ParcelModel, Double> parcelTupel : parcelTupels) {
                    ParcelModel parcel = parcelTupel.getElement1();
                    parcels.add(parcel);
                    Double matching = parcelTupel.getElement2();
                    if (!(matching > 99.9999999)) continue;
                    equalParcels.add(parcel);
                }
                if (equalImportedLocationsExisting || parcelsExisting) {
                    this.useEqualOrSimilar = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.locationCapturing.useEqualOrSimilar", new Serializable[0]));
                    buttonGroup.add(this.useEqualOrSimilar);
                    solutionSelectionPanel1.add(this.useEqualOrSimilar);
                    this.useEqualOrSimilar.addActionListener(solutionSelectionActionListener);
                    this.equalOrSimilarPane = new EqualOrSimilarPane(equalImportedLocations, parcels, equalParcels, this.stop, this.locationCapturing, this.modelEnviroment);
                    this.solutionDetailPanel.add((Component)this.equalOrSimilarPane, EQUAL_OR_SIMILAR);
                    ++rowCount;
                }
                if (!equalImportedLocationsExisting) {
                    this.useCreateNewImportedLocation = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.locationCapturing.useCreateNewImportedLocation", new Serializable[0]));
                    buttonGroup.add(this.useCreateNewImportedLocation);
                    solutionSelectionPanel1.add(this.useCreateNewImportedLocation);
                    this.useCreateNewImportedLocation.addActionListener(solutionSelectionActionListener);
                    ++rowCount;
                }
            }
            SpringUtilities.makeCompactGrid(solutionSelectionPanel1, rowCount, 1, 2, 2, 2, 2);
        }
        solutionSelectionPanel.add((Component)solutionSelectionPanel1, "North");
        solutionPanel.add((Component)solutionSelectionPanel, "West");
        if (this.useCoords != null) {
            this.useCoords.setSelected(true);
        } else if (this.useAddress != null) {
            this.useAddress.setSelected(true);
        } else if (this.useAddressAndCoords != null) {
            this.useAddressAndCoords.setSelected(true);
        } else if (this.useCreateNewImportedLocation != null) {
            this.useCreateNewImportedLocation.setSelected(true);
        } else if (this.useEqualOrSimilar != null) {
            this.useEqualOrSimilar.setSelected(true);
        }
        this.solutionDetailLayout.show(this.solutionDetailPanel, EMPTY);
        solutionPanel.add((Component)this.solutionDetailPanel, "Center");
        return solutionPanel;
    }

    private JPanel createAddressPanel() {
        JPanel upperPanel1 = new JPanel(new BorderLayout());
        WidthUnifier labelWidthUnifier = new WidthUnifier();
        WidthUnifier fieldWidthUnifier = new WidthUnifier();
        LocationWrapper stopLocationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(this.stop.getLocation());
        boolean isParcel = stopLocationWrapper instanceof ParcelLocationWrapper;
        BlockAdressPane stopAdressPane = new BlockAdressPane(isParcel, true, true, ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stop", new Serializable[0]), labelWidthUnifier, fieldWidthUnifier, true, this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry());
        stopAdressPane.setEditable(false);
        stopAdressPane.setLocation(this.stop.getLocation(), this.modelEnviroment);
        upperPanel1.add((Component)stopAdressPane, "West");
        BlockAdressPane locationCapturingAddressPane = new BlockAdressPane(false, false, true, ModelEnviroment.getMessageResolver().resolveMessage("messages.locationCapturing", new Serializable[0]), labelWidthUnifier, fieldWidthUnifier, true, this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry());
        locationCapturingAddressPane.setEditable(false);
        locationCapturingAddressPane.setLocation(LocationWrapperFactory.INSTANCE.createLocationWrapper(this.locationCapturing), this.modelEnviroment);
        upperPanel1.add((Component)locationCapturingAddressPane, "East");
        labelWidthUnifier.unifyWidth();
        fieldWidthUnifier.unifyWidth();
        return upperPanel1;
    }

    public String executeAction() {
        if (this.useAddress != null && this.useAddress.isSelected()) {
            this.executeUseAdress();
        } else if (this.useAddressAndCoords != null && this.useAddressAndCoords.isSelected()) {
            this.executeUseAdressAndCoords();
        } else if (this.useCoords != null && this.useCoords.isSelected()) {
            this.executeUseCoords();
        } else if (this.useCreateNewImportedLocation != null && this.useCreateNewImportedLocation.isSelected()) {
            this.executeUseCreateNewImportedLocation();
        } else if (this.useEqualOrSimilar != null && this.useEqualOrSimilar.isSelected()) {
            return this.executeUseEqualOrSimilar();
        }
        return null;
    }

    private String executeUseEqualOrSimilar() {
        LocationModel location = this.stop.getLocation();
        ImportedLocationModel ip = this.equalOrSimilarPane.getSelectedImportedLocation();
        if (ip == null) {
            ParcelModel parcel = this.equalOrSimilarPane.getSelectedParcel();
            if (parcel == null) {
                return ModelEnviroment.getMessageResolver().resolveMessage("messages.chooseLocation", new Serializable[0]);
            }
            location.setParcel(parcel);
        } else {
            location.setParcel(null);
            location.setExternalLocation(null);
            location.setImportedLocation(ip);
        }
        return null;
    }

    private void executeUseCreateNewImportedLocation() {
        ImportedLocationModelImpl importedLocationModel = new ImportedLocationModelImpl();
        importedLocationModel.setCity(this.locationCapturing.getCity());
        importedLocationModel.setDistrict(this.locationCapturing.getDistrict());
        String housenumberString = this.locationCapturing.getHousenumber();
        Integer housenumber = null;
        try {
            housenumber = Integer.valueOf(housenumberString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        importedLocationModel.setHousenumber(housenumber);
        importedLocationModel.setHousenumberExtension(this.locationCapturing.getHousenumberExtension());
        importedLocationModel.setPostcode(this.locationCapturing.getPostcode());
        importedLocationModel.setStatus(ImportedLocationStatus.CHECKED);
        String countryString = this.locationCapturing.getCountry();
        Country country = CountryUtil.searchCountryFuzzy(countryString);
        importedLocationModel.setCountry(country);
        importedLocationModel.setStreet(this.locationCapturing.getStreet());
        importedLocationModel.setGeoLocation(this.locationCapturing.getGeoLocation());
        LocationModel location = this.stop.getLocation();
        location.setParcel(null);
        location.setExternalLocation(null);
        location.setImportedLocation(importedLocationModel);
        this.stopRenderer.setPoint(importedLocationModel.getGeoLocation());
        this.navigatorPanel.repaint(10L);
    }

    private void executeUseCoords() {
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(this.stop.getLocation());
        locationWrapper.setGeoLocation(this.locationCapturing.getGeoLocation());
        locationWrapper.setFootSegment(null);
        locationWrapper.setBikeSegment(null);
        locationWrapper.setMotorSegment(null);
        this.stopRenderer.setPoint(locationWrapper.getGeoLocation());
        this.navigatorPanel.repaint(10L);
    }

    private void executeUseAdressAndCoords() {
        this.executeUseCoords();
        this.executeUseAdress();
    }

    private void executeUseAdress() {
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(this.stop.getLocation());
        locationWrapper.setCountry(this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry());
        locationWrapper.setCity(this.locationCapturing.getCity());
        locationWrapper.setDistrict(this.locationCapturing.getDistrict());
        String housenumberString = this.locationCapturing.getHousenumber();
        Integer housenumber = null;
        try {
            housenumber = Integer.valueOf(housenumberString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        locationWrapper.setHousenumber(housenumber);
        locationWrapper.setHousenumberExtension(this.locationCapturing.getHousenumberExtension());
        locationWrapper.setPostcode(this.locationCapturing.getPostcode());
        locationWrapper.setStreet(this.locationCapturing.getStreet());
    }

    private class SolutionSelectionActionListener
    implements ActionListener {
        private SolutionSelectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String card = LocationCapturingOverwritePane.EMPTY;
            if (e.getSource() == LocationCapturingOverwritePane.this.useEqualOrSimilar) {
                card = LocationCapturingOverwritePane.EQUAL_OR_SIMILAR;
                ImmutablePoint selectedLocation = null;
                ImportedLocationModel ip = LocationCapturingOverwritePane.this.equalOrSimilarPane.getSelectedImportedLocation();
                if (ip == null) {
                    ParcelModel parcel = LocationCapturingOverwritePane.this.equalOrSimilarPane.getSelectedParcel();
                    if (parcel != null) {
                        selectedLocation = parcel.getGeom();
                    }
                } else {
                    selectedLocation = ip.getGeoLocation();
                }
                LocationCapturingOverwritePane.this.equalOrSimilarRenderer.setPoint(selectedLocation);
            } else {
                LocationCapturingOverwritePane.this.equalOrSimilarRenderer.setPoint(null);
                LocationCapturingOverwritePane.this.navigatorPanel.repaint(10L);
            }
            LocationCapturingOverwritePane.this.solutionDetailLayout.show(LocationCapturingOverwritePane.this.solutionDetailPanel, card);
        }
    }
}

