/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop.locationcapturing.overwrite;

import de.datomino.peppergis.client.gui.address.BlockAdressPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.common.DefaultSimplePointRenderer;
import de.datomino.peppergis.client.model.base.ImportedLocationModel;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.model.mobile.LocationCapturingModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.StringUtil;

public class EqualOrSimilarPane
extends JPanel {
    private static final long serialVersionUID = -2258822107984701941L;
    private JList importedLocationList;
    private JList parcelList;
    private BlockAdressPane blockAdressPane;
    private LocationWrapper selected;
    private ModelEnviroment modelEnviroment;
    private Set<ParcelModel> equalParcels;
    private DefaultSimplePointRenderer locationCapturingRenderer;
    private NavigatorPanel navigatorPanel;
    private StopModel stop;
    private LocationCapturingModel locationCapturingModel;

    public EqualOrSimilarPane(Collection<ImportedLocationModel> importedLocations, Collection<ParcelModel> parcels, Collection<ParcelModel> equalParcels, StopModel stop, LocationCapturingModel locationCapturingModel, ModelEnviroment modelEnviroment) {
        super(new SpringLayout());
        this.modelEnviroment = modelEnviroment;
        this.equalParcels = new HashSet<ParcelModel>(equalParcels);
        this.locationCapturingModel = locationCapturingModel;
        this.stop = stop;
        this.buildLayout();
        this.fillValues(importedLocations, parcels);
    }

    private void fillValues(Collection<ImportedLocationModel> importedLocations, Collection<ParcelModel> parcels) {
        DefaultListModel dlm = (DefaultListModel)this.importedLocationList.getModel();
        for (ImportedLocationModel ip : importedLocations) {
            dlm.addElement(ip);
        }
        dlm = (DefaultListModel)this.parcelList.getModel();
        for (ParcelModel parcel : parcels) {
            dlm.addElement(parcel);
        }
    }

    private void buildLayout() {
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.addresses", new Serializable[0])));
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.parcel.parcels", new Serializable[0])));
        this.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.locationCapturing.selectedLocations", new Serializable[0])));
        EqualOrSimilarListSelectionListener listSelectionListener = new EqualOrSimilarListSelectionListener();
        WidthUnifier widthUnifier = new WidthUnifier();
        this.importedLocationList = new JList(new DefaultListModel());
        this.importedLocationList.setSelectionMode(0);
        this.importedLocationList.addListSelectionListener(listSelectionListener);
        this.importedLocationList.setCellRenderer(new EqualsOrSimilarImportedLocationRenderer(this.importedLocationList.getCellRenderer()));
        JScrollPane scroll = new JScrollPane(this.importedLocationList);
        widthUnifier.add(scroll);
        this.add(scroll);
        this.parcelList = new JList(new DefaultListModel());
        this.parcelList.setSelectionMode(0);
        this.parcelList.addListSelectionListener(listSelectionListener);
        this.parcelList.setCellRenderer(new EqualsOrSimilarParcelRenderer(this.parcelList.getCellRenderer()));
        scroll = new JScrollPane(this.parcelList);
        widthUnifier.add(scroll);
        this.add(scroll);
        widthUnifier.unifyWidth();
        this.blockAdressPane = new BlockAdressPane(true, true, true, null, null, null, true, this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry());
        this.blockAdressPane.setEditable(false);
        this.add(this.blockAdressPane);
        SpringUtilities.makeCompactGrid(this, 2, 3, 2, 2, 2, 2);
    }

    private StringBuilder getStringRepresentation(Country country, String postcode, String city, String district, String street, String housenumber, String housenumberExtension) {
        StringBuilder sb = new StringBuilder();
        if (country != null) {
            sb.append(country.getVehicleSign()).append(" ");
        }
        if (!StringUtil.isBlank(postcode)) {
            sb.append(postcode).append(" ");
        }
        if (!StringUtil.isBlank(city)) {
            sb.append(city);
        }
        if (!StringUtil.isBlank(district)) {
            sb.append(" - ").append(district);
        }
        sb.append(", ");
        if (!StringUtil.isBlank(street)) {
            sb.append(street).append(" ");
        }
        sb.append(housenumber).append(StringUtil.nullToEmpty(housenumberExtension));
        return sb;
    }

    public ImportedLocationModel getSelectedImportedLocation() {
        return (ImportedLocationModel)this.importedLocationList.getSelectedValue();
    }

    public ParcelModel getSelectedParcel() {
        return (ParcelModel)this.parcelList.getSelectedValue();
    }

    public void setLocationCapturingRenderer(DefaultSimplePointRenderer locationCapturingRenderer) {
        this.locationCapturingRenderer = locationCapturingRenderer;
    }

    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    private class EqualOrSimilarListSelectionListener
    implements ListSelectionListener {
        private EqualOrSimilarListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ImmutablePoint selectedPoint = null;
            Object source = e.getSource();
            if (source == EqualOrSimilarPane.this.importedLocationList) {
                EqualOrSimilarPane.this.parcelList.setSelectedIndices(new int[0]);
                ImportedLocationModel il = (ImportedLocationModel)EqualOrSimilarPane.this.importedLocationList.getSelectedValue();
                EqualOrSimilarPane.this.selected = LocationWrapperFactory.INSTANCE.createLocationWrapper(il);
                EqualOrSimilarPane.this.blockAdressPane.setLocation(EqualOrSimilarPane.this.selected, EqualOrSimilarPane.this.modelEnviroment);
                selectedPoint = il.getGeoLocation();
            } else if (source == EqualOrSimilarPane.this.parcelList) {
                EqualOrSimilarPane.this.importedLocationList.setSelectedIndices(new int[0]);
                ParcelModel parcel = (ParcelModel)EqualOrSimilarPane.this.parcelList.getSelectedValue();
                EqualOrSimilarPane.this.selected = LocationWrapperFactory.INSTANCE.createLocationWrapper(parcel);
                EqualOrSimilarPane.this.blockAdressPane.setLocation(EqualOrSimilarPane.this.selected, EqualOrSimilarPane.this.modelEnviroment);
                selectedPoint = parcel.getGeom();
            }
            EqualOrSimilarPane.this.locationCapturingRenderer.setPoint(selectedPoint);
            LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(EqualOrSimilarPane.this.stop.getLocation());
            ArrayList<Coordinate> list = new ArrayList<Coordinate>(Arrays.asList(locationWrapper.getGeoLocation().getCoordinate(), EqualOrSimilarPane.this.locationCapturingModel.getGeoLocation().getCoordinate()));
            if (selectedPoint != null) {
                list.add(selectedPoint.getCoordinate());
            }
            EqualOrSimilarPane.this.navigatorPanel.center(list, 10);
        }
    }

    private class EqualsOrSimilarImportedLocationRenderer
    implements ListCellRenderer {
        private ListCellRenderer listCellRenderer;

        public EqualsOrSimilarImportedLocationRenderer(ListCellRenderer listCellRenderer) {
            this.listCellRenderer = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object nValue = value;
            if (value != null) {
                ImportedLocationModel importedLocationModel = (ImportedLocationModel)value;
                Country country = importedLocationModel.getCountry();
                String postcode = importedLocationModel.getPostcode();
                String city = importedLocationModel.getCity();
                String district = importedLocationModel.getDistrict();
                String street = importedLocationModel.getStreet();
                String housenumber = StringUtil.nullToEmpty(importedLocationModel.getHousenumber());
                String housenumberExtension = importedLocationModel.getHousenumberExtension();
                StringBuilder sb = EqualOrSimilarPane.this.getStringRepresentation(country, postcode, city, district, street, housenumber, housenumberExtension);
                nValue = sb.toString();
            }
            Component c = this.listCellRenderer.getListCellRendererComponent(list, nValue, index, isSelected, cellHasFocus);
            c.setForeground(Color.GREEN);
            return c;
        }
    }

    private class EqualsOrSimilarParcelRenderer
    implements ListCellRenderer {
        private ListCellRenderer listCellRenderer;

        public EqualsOrSimilarParcelRenderer(ListCellRenderer listCellRenderer) {
            this.listCellRenderer = listCellRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object nValue = value;
            boolean isEqual = false;
            if (value != null) {
                ParcelModel parcelModel = (ParcelModel)value;
                String housenumber = parcelModel.getHouseNumber();
                String housenumberExtension = parcelModel.getHouseNumberExtension();
                String street = "";
                String city = "";
                String district = "";
                String postcode = "";
                Country country = null;
                StreetModel streetModel = parcelModel.getStreet();
                if (streetModel != null) {
                    street = streetModel.getName();
                    PostcodeDistrictRelationModel pdr = streetModel.getPostcodeDistrictRelation();
                    if (pdr != null) {
                        DistrictModel districtModel;
                        PostcodeModel postcodeModel = pdr.getPostcode();
                        if (postcodeModel != null) {
                            postcode = postcodeModel.getName();
                            country = postcodeModel.getCountry();
                        }
                        if ((districtModel = pdr.getDistrict()) != null) {
                            district = districtModel.getName();
                            CityModel cityModel = districtModel.getCity();
                            if (cityModel != null) {
                                city = cityModel.getName();
                            }
                        }
                    }
                }
                nValue = EqualOrSimilarPane.this.getStringRepresentation(country, postcode, city, district, street, housenumber, housenumberExtension);
                isEqual = EqualOrSimilarPane.this.equalParcels.contains(parcelModel);
            }
            Component c = this.listCellRenderer.getListCellRendererComponent(list, nValue, index, isSelected, cellHasFocus);
            if (isEqual) {
                c.setForeground(Color.GREEN);
            }
            return c;
        }
    }
}

