/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop.locationcapturing;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.common.DefaultSimplePointRenderer;
import de.datomino.peppergis.client.model.mobile.LocationCapturingModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.tourmanager.gui.stop.locationcapturing.LocationCapturingTableModel;
import de.datomino.peppergis.tourmanager.gui.stop.locationcapturing.overwrite.LocationCapturingOverwritePane;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.swing.navigator.NavigatorPanel;

public class StopLocationCapturingPane
extends JPanel {
    private static final long serialVersionUID = 7925897852712517103L;
    private StopModel stop;
    private JTable locationCapturingTable;
    private NavigatorPanel navigatorPanel;
    private Action overwriteAction;
    private Action deleteAction;
    private ModelEnviroment modelEnviroment;
    private DefaultSimplePointRenderer locationCapturingRenderer;
    private DefaultSimplePointRenderer stopLocationCapturingRenderer;

    public StopLocationCapturingPane(StopModel stop, ModelEnviroment modelEnviroment) {
        super(new BorderLayout());
        this.stop = stop;
        this.modelEnviroment = modelEnviroment;
        this.buildLayout();
        this.fillData();
    }

    private void fillData() {
        ImmutablePoint geoLocation;
        LocationCapturingTableModel locationCapturingTableModel = (LocationCapturingTableModel)this.locationCapturingTable.getModel();
        ArrayList<LocationCapturingModel> locs = new ArrayList<LocationCapturingModel>(this.stop.countLocationCapturings());
        for (LocationCapturingModel locationCapturingModel : this.stop.iterableLocationCapturings()) {
            locs.add(locationCapturingModel);
        }
        locationCapturingTableModel.setLocationCapturings(locs);
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(this.stop.getLocation());
        if (locationWrapper != null && (geoLocation = locationWrapper.getGeoLocation()) != null) {
            this.navigatorPanel.center(geoLocation.getCoordinate());
        }
    }

    private void buildLayout() {
        JSplitPane splitPane = new JSplitPane(0);
        this.locationCapturingTable = new JTable(new LocationCapturingTableModel());
        this.locationCapturingTable.getTableHeader().setReorderingAllowed(false);
        ListSelectionModel selectionModel = this.locationCapturingTable.getSelectionModel();
        selectionModel.setSelectionMode(0);
        TableSelectionListener tableSelectionListener = new TableSelectionListener();
        selectionModel.addListSelectionListener(tableSelectionListener);
        this.locationCapturingTable.addMouseListener(tableSelectionListener);
        splitPane.setLeftComponent(new JScrollPane(this.locationCapturingTable));
        JPanel nPanel = new JPanel(new BorderLayout());
        this.navigatorPanel = this.initializeNavigatorPanel(nPanel);
        nPanel.add((Component)this.navigatorPanel, "Center");
        splitPane.setRightComponent(nPanel);
        splitPane.setDividerLocation(150);
        this.add((Component)splitPane, "Center");
        JPanel panel = new JPanel(new BorderLayout());
        JPanel panel2 = new JPanel(new FlowLayout());
        this.overwriteAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.take", new Serializable[0])){
            private static final long serialVersionUID = 1250760597795815149L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StopLocationCapturingPane.this.overwrite();
            }
        };
        JButton button = new JButton(this.overwriteAction);
        this.overwriteAction.setEnabled(false);
        panel2.add(button);
        this.deleteAction = new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.delete", new Serializable[0])){
            private static final long serialVersionUID = -2659317458362029948L;

            @Override
            public void actionPerformed(ActionEvent e) {
                StopLocationCapturingPane.this.delete();
            }
        };
        button = new JButton(this.deleteAction);
        this.deleteAction.setEnabled(false);
        panel2.add(button);
        panel.add((Component)panel2, "Center");
        this.add((Component)panel, "South");
    }

    private void delete() {
        int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.locationCapturing.question.deleteLocationCapturing", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
        if (d == 0) {
            int index = this.locationCapturingTable.getSelectedRow();
            LocationCapturingTableModel locationCapturingTableModel = (LocationCapturingTableModel)this.locationCapturingTable.getModel();
            LocationCapturingModel loc = locationCapturingTableModel.getLocationCapturingAt(index);
            loc.setStop(null);
            loc.delete();
            locationCapturingTableModel.removeElementAt(index);
        }
    }

    private NavigatorPanel initializeNavigatorPanel(Container mapPanel) {
        NavigatorPanel navigatorPanel = new NavigatorPanel(MercatorFactory.INSTANCE.createCoordinate(1293576.0, 6116444.0), OpenStreetmapViewFactory.INSTANCE, mapPanel);
        navigatorPanel.setSize(200, 200);
        navigatorPanel.setPreferredSize(new Dimension(200, 200));
        navigatorPanel.setPanning(true);
        navigatorPanel.getPanningAction().setSelected(true);
        navigatorPanel.setCursor(Cursor.getDefaultCursor());
        navigatorPanel.addRenderer(new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties()));
        this.stopLocationCapturingRenderer = new DefaultSimplePointRenderer(Color.GREEN);
        if (this.stop.getLocation() != null) {
            this.stopLocationCapturingRenderer.setPoint(LocationWrapperFactory.INSTANCE.createLocationWrapper(this.stop.getLocation()).getGeoLocation());
        }
        navigatorPanel.addRenderer(this.stopLocationCapturingRenderer);
        this.locationCapturingRenderer = new DefaultSimplePointRenderer(Color.RED);
        navigatorPanel.addRenderer(this.locationCapturingRenderer);
        return navigatorPanel;
    }

    private void overwrite() {
        int index = this.locationCapturingTable.getSelectedRow();
        LocationCapturingTableModel locationCapturingTableModel = (LocationCapturingTableModel)this.locationCapturingTable.getModel();
        LocationCapturingModel loc = locationCapturingTableModel.getLocationCapturingAt(index);
        final LocationCapturingOverwritePane locationCapturingOverwritePane = new LocationCapturingOverwritePane(this.stop, loc, this.modelEnviroment);
        CommonDialog dialog = new CommonDialog(SwingUtils.findWindowParent(this), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.take", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL){
            private static final long serialVersionUID = 78613561530106595L;

            @Override
            protected Action getOkAction() {
                return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
                    private static final long serialVersionUID = 2971923184489758481L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String errorMessage = locationCapturingOverwritePane.executeAction();
                        if (errorMessage == null) {
                            LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(StopLocationCapturingPane.this.stop.getLocation());
                            StopLocationCapturingPane.this.stopLocationCapturingRenderer.setPoint(locationWrapper.getGeoLocation());
                            StopLocationCapturingPane.this.navigatorPanel.repaint(10L);
                            this.dispose();
                        } else {
                            JOptionPane.showMessageDialog(SwingUtils.findWindowParent((Component)e.getSource()), errorMessage, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                        }
                    }
                };
            }

            @Override
            protected Component getMainComponent() {
                return locationCapturingOverwritePane;
            }

            @Override
            protected Action getCancelAction() {
                return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
                    private static final long serialVersionUID = -6074120289838723372L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.dispose();
                    }
                };
            }
        };
        dialog.buildLayout();
        dialog.pack();
        SwingUtils.center((Window)dialog, SwingUtils.findWindowParent(this));
        dialog.setVisible(true);
    }

    public void refreshPoint() {
        LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(this.stop.getLocation());
        this.stopLocationCapturingRenderer.setPoint(locationWrapper.getGeoLocation());
        this.navigatorPanel.repaint(10L);
    }

    private class TableSelectionListener
    extends MouseAdapter
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int index = StopLocationCapturingPane.this.locationCapturingTable.getSelectedRow();
            if (index >= 0) {
                LocationCapturingTableModel locationCapturingTableModel = (LocationCapturingTableModel)StopLocationCapturingPane.this.locationCapturingTable.getModel();
                LocationCapturingModel loc = locationCapturingTableModel.getLocationCapturingAt(index);
                LocationWrapper locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(StopLocationCapturingPane.this.stop.getLocation());
                StopLocationCapturingPane.this.navigatorPanel.center(Arrays.asList(loc.getGeoLocation().getCoordinate(), locationWrapper.getGeoLocation().getCoordinate()), 50);
                StopLocationCapturingPane.this.overwriteAction.setEnabled(true);
                StopLocationCapturingPane.this.deleteAction.setEnabled(true);
                StopLocationCapturingPane.this.locationCapturingRenderer.setPoint(loc.getGeoLocation());
            } else {
                StopLocationCapturingPane.this.overwriteAction.setEnabled(false);
                StopLocationCapturingPane.this.deleteAction.setEnabled(false);
                StopLocationCapturingPane.this.locationCapturingRenderer.setPoint(null);
            }
            StopLocationCapturingPane.this.navigatorPanel.repaint(10L);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int index;
            super.mouseClicked(e);
            if (e.getClickCount() > 1 && e.getButton() == 1 && (index = StopLocationCapturingPane.this.locationCapturingTable.rowAtPoint(e.getPoint())) >= 0) {
                StopLocationCapturingPane.this.overwrite();
            }
        }
    }
}

