/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop.history;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.base.StaticChoiceValueModel;
import de.datomino.peppergis.client.model.mobile.AccountModel;
import de.datomino.peppergis.client.model.tour.ServiceValueHistoryModel;
import de.datomino.peppergis.type.MobileChangeSource;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.ktde.util.StringUtil;

public class ServiceValueHistoryTableModel
implements TableModel {
    private List<ServiceValueHistoryModel> serviceValueHistoryModels;
    private List<TableModelListener> tableModelListeners = new ArrayList<TableModelListener>();

    @Override
    public int getRowCount() {
        return this.serviceValueHistoryModels == null ? 0 : this.serviceValueHistoryModels.size();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int columnIndex) {
        String s = null;
        switch (columnIndex) {
            case 0: {
                s = ModelEnviroment.getMessageResolver().resolveMessage("messages.serviceValues.name", new Serializable[0]);
                break;
            }
            case 1: {
                s = ModelEnviroment.getMessageResolver().resolveMessage("messages.serviceValues.entryTime", new Serializable[0]);
                break;
            }
            case 2: {
                s = ModelEnviroment.getMessageResolver().resolveMessage("gui.serviceticket.value", new Serializable[0]);
                break;
            }
            case 3: {
                s = ModelEnviroment.getMessageResolver().resolveMessage("messages.serviceValues.changeType", new Serializable[0]);
                break;
            }
            case 4: {
                s = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.user", new Serializable[0]);
            }
        }
        return s;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ServiceValueHistoryModel serviceValueHistoryModel = this.serviceValueHistoryModels.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return serviceValueHistoryModel.getServiceValueDescriptor().getName();
            }
            case 1: {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm").format(serviceValueHistoryModel.getChangeTime());
            }
            case 2: {
                return this.getValue(serviceValueHistoryModel);
            }
            case 3: {
                return ModelEnviroment.getMessageResolver().resolveMessageForEnum(serviceValueHistoryModel.getChangeSource());
            }
            case 4: {
                MobileChangeSource changeSource = serviceValueHistoryModel.getChangeSource();
                if (changeSource != null) {
                    switch (changeSource) {
                        case ACCOUNT: {
                            AccountModel account = serviceValueHistoryModel.getAccount();
                            return account == null ? "???" : account.getLogin();
                        }
                        case IMPORT: {
                            return "";
                        }
                        case USER: {
                            UserModel user = serviceValueHistoryModel.getUser();
                            return user == null ? "???" : user.getLogin();
                        }
                    }
                }
                return "";
            }
        }
        return "";
    }

    private Object getValue(ServiceValueHistoryModel serviceValueHistoryModel) {
        ServiceValueDescriptorModel serviceValueDescriptor = serviceValueHistoryModel.getServiceValueDescriptor();
        switch (serviceValueDescriptor.getServiceValueType()) {
            case BOOLEAN: {
                Boolean b = serviceValueHistoryModel.getBooleanValue();
                if (b == null) {
                    return "";
                }
                return ModelEnviroment.getMessageResolver().resolveMessage(b != false ? "messages.default.yes" : "messages.default.no", new Serializable[0]);
            }
            case DATE: {
                Long l = serviceValueHistoryModel.getLongValue();
                if (l == null) {
                    return "";
                }
                Date date = new Date(l);
                return new SimpleDateFormat("yyyy-MM-dd HH:mm").format(date);
            }
            case FLOAT: {
                Double d = serviceValueHistoryModel.getFloatValue();
                if (d == null) {
                    return "";
                }
                return d.toString();
            }
            case IMAGE: {
                byte[] imageValue = serviceValueHistoryModel.getImageValue();
                if (imageValue == null) {
                    return "";
                }
                return imageValue;
            }
            case INTEGER: {
                Integer i = serviceValueHistoryModel.getIntegerValue();
                if (i == null) {
                    return "";
                }
                return i.toString();
            }
            case MULTIPLE_LIST_CHOICE: {
                return StringUtil.nullToEmpty(serviceValueHistoryModel.getSelectedMultipleListChoiceValues());
            }
            case STATIC_CHOICE: {
                StaticChoiceValueModel staticChoiceValue = serviceValueHistoryModel.getStaticChoiceValue();
                if (staticChoiceValue == null) {
                    return "";
                }
                return staticChoiceValue.getName();
            }
            case STRING: {
                return StringUtil.nullToEmpty(serviceValueHistoryModel.getStringValue());
            }
            case TEXT: {
                return StringUtil.nullToEmpty(serviceValueHistoryModel.getTextValue());
            }
            case PDF_DOWN: {
                byte[] pdfValue = serviceValueHistoryModel.getPdfValue();
                return pdfValue == null ? "" : (Object)pdfValue;
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.tableModelListeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.tableModelListeners.remove(l);
    }

    protected void fireTableModelEvent(TableModelEvent e) {
        for (TableModelListener l : this.tableModelListeners) {
            l.tableChanged(e);
        }
    }

    public void setServiceValueHistoryModels(List<ServiceValueHistoryModel> serviceValueHistoryModels) {
        this.serviceValueHistoryModels = serviceValueHistoryModels;
        this.fireTableModelEvent(new TableModelEvent(this));
    }
}

