/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop.history;

import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceValueHistoryModel;
import de.datomino.peppergis.tourmanager.gui.stop.history.ServiceValueHistoryComparator;
import de.datomino.peppergis.tourmanager.gui.stop.history.ServiceValueHistoryRenderer;
import de.datomino.peppergis.tourmanager.gui.stop.history.ServiceValueHistoryTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ServiceValueHistoryPanel
extends JPanel {
    private static final long serialVersionUID = -7892290077603496291L;
    private ServiceTicketStopRelationModel relationModel;
    private JTable historyTable;

    public ServiceValueHistoryPanel(ServiceTicketStopRelationModel relationModel) {
        super(new BorderLayout());
        this.relationModel = relationModel;
        this.buildLayout();
        this.fillValues();
    }

    private void fillValues() {
        ArrayList<ServiceValueHistoryModel> histories = new ArrayList<ServiceValueHistoryModel>(this.relationModel.countServiceValueHistoryEntries());
        for (ServiceValueHistoryModel history : this.relationModel.iterableServiceValueHistoryEntries()) {
            histories.add(history);
        }
        Collections.sort(histories, new ServiceValueHistoryComparator());
        ServiceValueHistoryTableModel model = (ServiceValueHistoryTableModel)this.historyTable.getModel();
        model.setServiceValueHistoryModels(histories);
    }

    private void buildLayout() {
        this.historyTable = new JTable(new ServiceValueHistoryTableModel());
        this.historyTable.setDefaultRenderer(Object.class, new ServiceValueHistoryRenderer(this.historyTable.getDefaultRenderer(String.class), this));
        this.historyTable.getTableHeader().setReorderingAllowed(false);
        this.add((Component)new JScrollPane(this.historyTable), "Center");
    }
}

