/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop;

import de.datomino.peppergis.PeppergisConstants;
import de.datomino.peppergis.client.gui.renderer.AbstractTableRenderer;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.stop.StopTablePanel;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.ktde.util.datatypes.Tupel;

public class StopTableCellRenderer
extends AbstractTableRenderer {
    private StopTablePanel stopTablePanel;
    private Map<StopModel, Color> stopColorCache = new HashMap<StopModel, Color>();

    public StopTableCellRenderer(StopTablePanel stopTablePanel) {
        this.stopTablePanel = stopTablePanel;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel textField = new JLabel(value == null ? "" : value.toString());
        if (column == 0 && value instanceof Tupel) {
            textField.setText(((String)((Tupel)value).getElement1()).toString());
        }
        textField.setOpaque(true);
        textField.setFont(table.getFont());
        textField.setBorder(BorderFactory.createEmptyBorder());
        List<Tupel<Integer, Integer>> invalidEstimatedTime = this.stopTablePanel.getInvalidEstimatedTime();
        if (invalidEstimatedTime != null && invalidEstimatedTime.contains(new Tupel<Integer, Integer>(row, column))) {
            textField.setForeground(PeppergisConstants.INVALID_TIME_COLOR);
        }
        StopModel stop = this.stopTablePanel.getStopModelInTableAt(row);
        ImmutablePoint point = StopModelUtil.getGeom(stop);
        if (stop != null && GeoUtil.isNullPoint(point)) {
            textField.setForeground(PeppergisConstants.NULL_GEOM_COLOR);
        }
        if (column == 4 && stop != null && stop.countLocationCapturings() > 0) {
            textField.setBackground(new Color(195, 0, 255).brighter());
        }
        if (column == 0) {
            textField.setHorizontalAlignment(0);
            textField.setBackground(StopModelUtil.getColorOfStatus(stop, this.stopColorCache));
            if (StopModelUtil.hasBadTimeWindow(stop)) {
                textField.setIcon(TourModelUtil.icon_bad_window);
            }
        }
        if (this.stopTablePanel.getSelectedStops().contains(stop)) {
            textField.setBackground(PeppergisConstants.SELECTION_COLOR);
        }
        return textField;
    }
}

