/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop;

import de.datomino.peppergis.client.gui.common.EnumComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.admin.UserModel;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceTicketModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.ServiceValueModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.client.util.ServiceModelUtil;
import de.datomino.peppergis.tourmanager.gui.stop.AddAndUpdateStopDialog;
import de.datomino.peppergis.tourmanager.gui.stop.history.ServiceValueHistoryPanel;
import de.datomino.peppergis.tourmanager.handler.action.stop.UpdateServiceValueAction;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.MobileChangeSource;
import de.datomino.peppergis.type.MobileGpsStatus;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.ktde.util.StringUtil;

public class ServiceTicketRelationPanel {
    private AddAndUpdateStopDialog addAndUpdateStopDialog;
    private Map<ServiceValueModel, Object> oldValueMap;
    private StopModel stopModel;

    public ServiceTicketRelationPanel(AddAndUpdateStopDialog addAndUpdateStopDialog) {
        this.addAndUpdateStopDialog = addAndUpdateStopDialog;
    }

    public void loadServiceStopRelations(StopModel stopModel, JTabbedPane tabbedPane) {
        this.stopModel = stopModel;
        Iterator<ServiceTicketStopRelationModel> relationModelsIter = null;
        if (stopModel != null) {
            relationModelsIter = stopModel.iterateServiceStopRelations();
        }
        this.oldValueMap = new HashMap<ServiceValueModel, Object>();
        if (relationModelsIter != null) {
            while (relationModelsIter.hasNext()) {
                ServiceTicketStopRelationModel relationModel = relationModelsIter.next();
                Component serviceTicketPanel = this.createServiceTicketPanel(relationModel, false);
                ServiceTicketModel serviceTicket = relationModel.getServiceTicket();
                String name = serviceTicket.getName();
                if (StringUtil.isBlank(name)) {
                    name = serviceTicket.getService().getServiceNumber();
                }
                tabbedPane.addTab(name, serviceTicketPanel);
                for (ServiceValueModel value : relationModel.iterableServiceValues()) {
                    this.addServiceValueToMap(value);
                }
            }
        }
    }

    public void createServiceValueHistories() {
        Iterator<ServiceTicketStopRelationModel> relationModelsIter = null;
        if (this.stopModel != null) {
            relationModelsIter = this.stopModel.iterateServiceStopRelations();
        }
        if (relationModelsIter != null) {
            Date date = this.addAndUpdateStopDialog.getModelEnviroment().getAllCaller().getBaseCaller().getCurrentServerTime();
            UserModel userModel = ModelEnviroment.getUserInformation().getUserModel();
            while (relationModelsIter.hasNext()) {
                ServiceTicketStopRelationModel relationModel = relationModelsIter.next();
                for (ServiceValueModel value : relationModel.iterableServiceValues()) {
                    Object object = this.oldValueMap.remove(value);
                    if (value.isDeleted()) continue;
                    boolean create = false;
                    if (object == null) {
                        create = true;
                    } else {
                        Object sValue = this.getValue(value);
                        AttributeValueType serviceValueType = value.getServiceValueDescriptor().getServiceValueType();
                        if (serviceValueType == AttributeValueType.IMAGE || serviceValueType == AttributeValueType.PDF_DOWN) {
                            byte[] b = (byte[])object;
                            byte[] sB = (byte[])sValue;
                            create = Arrays.equals(b, sB);
                        } else {
                            boolean bl = create = !new EqualsBuilder().append(object, sValue).isEquals();
                        }
                    }
                    if (!create) continue;
                    ServiceModelUtil.createServiceValueHistory(value, date, MobileChangeSource.USER, null, userModel);
                }
            }
        }
    }

    private void addServiceValueToMap(ServiceValueModel value) {
        Object sValue = this.getValue(value);
        if (sValue != null) {
            this.oldValueMap.put(value, sValue);
        }
    }

    private Object getValue(ServiceValueModel value) {
        Object sValue = null;
        switch (value.getServiceValueDescriptor().getServiceValueType()) {
            case BOOLEAN: {
                sValue = value.getBooleanValue();
                break;
            }
            case DATE: {
                sValue = value.getLongValue();
                break;
            }
            case FLOAT: {
                sValue = value.getFloatValue();
                break;
            }
            case IMAGE: {
                sValue = value.getImageValue();
                break;
            }
            case INTEGER: {
                sValue = value.getIntegerValue();
                break;
            }
            case MULTIPLE_LIST_CHOICE: {
                sValue = value.getSelectedMultipleListChoiceValues();
                break;
            }
            case STATIC_CHOICE: {
                sValue = value.getStaticChoiceValue();
                break;
            }
            case STRING: {
                sValue = value.getStringValue();
                break;
            }
            case TEXT: {
                sValue = value.getTextValue();
                break;
            }
            case PDF_DOWN: {
                sValue = value.getPdfValue();
                break;
            }
        }
        return sValue;
    }

    private Component createServiceTicketPanel(ServiceTicketStopRelationModel relationModel, boolean editable) {
        JTabbedPane tab = new JTabbedPane();
        tab.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.currentValues", new Serializable[0]), this.createMainServiceTicketPanel(relationModel, editable));
        tab.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.history", new Serializable[0]), new ServiceValueHistoryPanel(relationModel));
        return tab;
    }

    private JPanel createMainServiceTicketPanel(ServiceTicketStopRelationModel relationModel, boolean editable) {
        JPanel serviceTicketPanel = new JPanel(new SpringLayout());
        JLabel serviceTicketNameLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]) + ": ");
        serviceTicketPanel.add(serviceTicketNameLabel);
        JTextField serviceTicketNameField = new JTextField("");
        serviceTicketNameField.setEditable(editable);
        serviceTicketPanel.add(serviceTicketNameField);
        JLabel serviceTicketIncomingTimeLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.serviceticket.incomingTime", new Serializable[0]) + ": ");
        serviceTicketPanel.add(serviceTicketIncomingTimeLabel);
        JTextField serviceTicketIncomingTimeField = new JTextField("");
        serviceTicketIncomingTimeField.setEditable(editable);
        serviceTicketPanel.add(serviceTicketIncomingTimeField);
        JLabel serviceTicketServiceLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.service", new Serializable[0]) + ": ");
        serviceTicketPanel.add(serviceTicketServiceLabel);
        JTextField serviceTicketServiceField = new JTextField("");
        serviceTicketServiceField.setEditable(editable);
        serviceTicketPanel.add(serviceTicketServiceField);
        JLabel serviceTicketCustomerLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.client", new Serializable[0]) + ": ");
        serviceTicketPanel.add(serviceTicketCustomerLabel);
        JTextField serviceTicketCustomerField = new JTextField("");
        serviceTicketCustomerField.setEditable(editable);
        serviceTicketPanel.add(serviceTicketCustomerField);
        serviceTicketPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessageForEnum(MobileGpsStatus.class) + ": "));
        EnumComboBox<MobileGpsStatus> gpsStatusComboBox = new EnumComboBox<MobileGpsStatus>(MobileGpsStatus.class, false);
        gpsStatusComboBox.setEnabled(false);
        serviceTicketPanel.add(gpsStatusComboBox);
        serviceTicketPanel.add(new JLabel(" "));
        JPanel gpsTimePane = new JPanel(new BorderLayout());
        JTextField gpsEnterTime = new JTextField(20);
        gpsEnterTime.setEditable(false);
        gpsTimePane.add((Component)gpsEnterTime, "West");
        gpsTimePane.add((Component)new JLabel(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0]) + " "), "Center");
        JTextField gpsExitTime = new JTextField(20);
        gpsExitTime.setEditable(false);
        gpsTimePane.add((Component)gpsExitTime, "East");
        serviceTicketPanel.add(gpsTimePane);
        JLabel serviceTicketValueLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.serviceticket.value", new Serializable[0]) + ": ");
        serviceTicketPanel.add(serviceTicketValueLabel);
        UpdateServiceValueAction updateServiceValueAction = new UpdateServiceValueAction(relationModel);
        if (relationModel != null) {
            ServiceTicketModel serviceTicket = relationModel.getServiceTicket();
            serviceTicketNameField.setText(serviceTicket.getName());
            serviceTicketIncomingTimeField.setText(ClientFormUtil.dateToString(serviceTicket.getIncomingTime()));
            ServiceModel service = serviceTicket.getService();
            serviceTicketServiceField.setText(service.getName() + " (" + service.getServiceNumber() + ")");
            serviceTicketCustomerField.setText(ServiceModelUtil.getCustomerDisplay(relationModel));
            MobileGpsStatus gpsStatus = relationModel.getGpsStatus() == null ? MobileGpsStatus.NONE : relationModel.getGpsStatus();
            gpsStatusComboBox.setSelectedValue(gpsStatus);
            switch (gpsStatus) {
                case DONE: {
                    gpsEnterTime.setText(ClientFormUtil.dateToString(relationModel.getGpsEnterTime()));
                    gpsExitTime.setText(ClientFormUtil.dateToString(relationModel.getGpsExitTime()));
                    break;
                }
            }
            serviceTicketPanel.add(updateServiceValueAction.createServiceValuesPanel(this.addAndUpdateStopDialog.isEditable()));
        }
        SpringUtilities.makeCompactGrid(serviceTicketPanel, 7, 2, 5, 5, 5, 5);
        JPanel mainServiceTicketPanel = new JPanel(new BorderLayout());
        mainServiceTicketPanel.add((Component)serviceTicketPanel, "North");
        return mainServiceTicketPanel;
    }
}

