/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.stop;

import de.datomino.peppergis.client.gui.Pausable;
import de.datomino.peppergis.client.gui.common.ScrollablePopupMenu;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.base.BranchModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.tour.ServiceTicketStopRelationModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.StopModelImpl;
import de.datomino.peppergis.tourmanager.gui.base.BranchModelListCellRenderer;
import de.datomino.peppergis.tourmanager.gui.stop.ServiceTicketRelationPanel;
import de.datomino.peppergis.tourmanager.gui.stop.StopInformationPanel;
import de.datomino.peppergis.tourmanager.gui.stop.StopTablePanel;
import de.datomino.peppergis.tourmanager.gui.stop.locationcapturing.StopLocationCapturingPane;
import de.datomino.peppergis.tourmanager.handler.action.stop.AddAndUpdateStopActions;
import de.datomino.peppergis.tourmanager.listener.stop.AddAndUpdateStopListener;
import de.datomino.peppergis.type.UserRole;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.plaf.basic.BasicArrowButton;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Quad;

public class AddAndUpdateStopDialog
extends JDialog
implements Pausable {
    private static final long serialVersionUID = 4419680245323735218L;
    private AddAndUpdateStopActions addAndUpdateStopActions;
    private ModelEnviroment modelEnviroment;
    private StopModel stopModel;
    private StopTablePanel stopTablePanel;
    private JTextField nameField = new JTextField("");
    private JComboBox branchComboBox = new JComboBox();
    private List<LocationModel> allLocations = new ArrayList<LocationModel>();
    private JLabel messageField = new JLabel("");
    private JPanel timeWindowsPanel = new JPanel(null);
    private List<Quad<JLabel, JSpinner, JLabel, JSpinner>> timeWindowFields = new ArrayList<Quad<JLabel, JSpinner, JLabel, JSpinner>>(1);
    private JButton addTimeWindowButton;
    private JButton removeTimeWindowButton;
    private JLabel serviceTicketStopRelationMessage = new JLabel("");
    private JTextField locationCountry = new JTextField("");
    private JTextField locationCity = new JTextField("");
    private JTextField locationPost = new JTextField("");
    private JTextField locationStreet = new JTextField("");
    private JTextField locationNumber = new JTextField("");
    private JTextField locationNumberEx = new JTextField("");
    private JTextField locationXField = new JTextField("");
    private JTextField locationYField = new JTextField("");
    private ScrollablePopupMenu locationSelectMenu;
    private AddAndUpdateStopListener addAndUpdateStopListener;
    private boolean editable;
    private boolean parentUndoManagerStarted;
    private JTabbedPane stopTabbedPane;
    private ServiceTicketRelationPanel serviceTicketRealtionPanel;
    private JPanel stopPane;
    private StopLocationCapturingPane stopLocationCapturingPane;

    private AddAndUpdateStopDialog(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
    }

    public AddAndUpdateStopDialog(ModelEnviroment modelEnviroment, boolean parentUndoManagerStarted, StopTablePanel stopTablePanel) {
        this((Frame)null, ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.newStop", new Serializable[0]) + " ...", true);
        this.modelEnviroment = modelEnviroment;
        this.parentUndoManagerStarted = parentUndoManagerStarted;
        this.stopTablePanel = stopTablePanel;
        this.modelEnviroment = modelEnviroment;
        this.setLocale(Locale.GERMAN);
        try {
            this.setIconImage(ImageIO.read(AddAndUpdateStopDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void createServiceValueHistories() {
        this.serviceTicketRealtionPanel.createServiceValueHistories();
    }

    private JTabbedPane createStopPanel() {
        JPanel inputPanel = new JPanel(new SpringLayout());
        JLabel nameLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]) + ": ");
        inputPanel.add(nameLabel);
        this.nameField.setEditable(this.editable);
        inputPanel.add(this.nameField);
        JLabel branchLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.project", new Serializable[0]) + ": ");
        inputPanel.add(branchLabel);
        List<BranchModel> branchs = this.modelEnviroment.getAllCaller().getTourCaller().fetchAllBranchs();
        branchs.add(0, null);
        this.branchComboBox = new JComboBox<Object>(branchs.toArray());
        this.branchComboBox.setRenderer(new BranchModelListCellRenderer());
        this.branchComboBox.setEnabled(this.editable);
        inputPanel.add(this.branchComboBox);
        JLabel timeWindowLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.timewindow", new Serializable[0]) + ": ");
        inputPanel.add(timeWindowLabel);
        inputPanel.add(this.createTimeWindowsPanel());
        this.createLocationPanel(inputPanel);
        inputPanel.add(new JLabel(" "));
        this.messageField.setForeground(Color.RED);
        inputPanel.add(this.messageField);
        SpringUtilities.makeCompactGrid(inputPanel, 13, 2, 5, 5, 5, 5);
        JPanel stopPanel = new JPanel(new BorderLayout());
        stopPanel.add((Component)inputPanel, "North");
        JTabbedPane stopTabbedPane = new JTabbedPane();
        stopTabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stop", new Serializable[0]), stopPanel);
        return stopTabbedPane;
    }

    private JScrollPane createTimeWindowsPanel() {
        this.addTimeWindowButton = new JButton(this.addAndUpdateStopActions.getAddTimeWindowAction());
        this.addTimeWindowButton.setText("+");
        this.addTimeWindowButton.setBorder(BorderFactory.createEmptyBorder());
        this.addTimeWindowButton.setEnabled(this.editable);
        this.timeWindowsPanel.add(this.addTimeWindowButton);
        this.removeTimeWindowButton = new JButton(this.addAndUpdateStopActions.getRemoveTimeWindowAction());
        this.removeTimeWindowButton.setText("-");
        this.removeTimeWindowButton.setBorder(BorderFactory.createEmptyBorder());
        this.removeTimeWindowButton.setEnabled(this.editable);
        this.timeWindowsPanel.add(this.removeTimeWindowButton);
        JScrollPane scrollPane = new JScrollPane(this.timeWindowsPanel);
        return scrollPane;
    }

    private void createLocationPanel(JPanel pane) {
        JLabel locationCountryLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0]) + ": ");
        pane.add(locationCountryLabel);
        this.locationCountry.setEditable(false);
        pane.add(this.locationCountry);
        JLabel locationPostLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0]) + ": ");
        pane.add(locationPostLabel);
        this.locationPost.setEditable(false);
        pane.add(this.locationPost);
        JLabel locationCityLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0]) + ": ");
        pane.add(locationCityLabel);
        this.locationCity.setEditable(false);
        pane.add(this.locationCity);
        JLabel locationStreetLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0]) + ": ");
        pane.add(locationStreetLabel);
        this.locationStreet.setEditable(false);
        pane.add(this.locationStreet);
        JLabel locationHausnumberLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0]) + ": ");
        pane.add(locationHausnumberLabel);
        this.locationNumber.setEditable(false);
        pane.add(this.locationNumber);
        JLabel locationHausnumberExLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0]) + ": ");
        pane.add(locationHausnumberExLabel);
        this.locationNumberEx.setEditable(false);
        pane.add(this.locationNumberEx);
        JLabel locationXLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.x", new Serializable[0]) + " ");
        pane.add(locationXLabel);
        this.locationXField.setEditable(false);
        pane.add(this.locationXField);
        JLabel locationYLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gis.coordinate.y", new Serializable[0]) + " ");
        pane.add(locationYLabel);
        this.locationYField.setEditable(false);
        pane.add(this.locationYField);
        pane.add(new JLabel(""));
        JButton editCoordinateButton = new JButton(this.addAndUpdateStopActions.getEditCoordinateAction());
        pane.add(editCoordinateButton);
        if (!this.editable) {
            editCoordinateButton.setEnabled(false);
        }
    }

    public void showDialog(StopModel stopModel, boolean editable, Component parent) {
        this.editable = editable;
        if (!ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DELIVERER_ACTIVE, UserRole.ADMIN, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.POST_WORK)) {
            this.editable = false;
        }
        this.addAndUpdateStopActions = new AddAndUpdateStopActions(this);
        if (this.editable) {
            this.addAndUpdateStopListener = new AddAndUpdateStopListener(this);
            this.addWindowListener(this.addAndUpdateStopListener);
            this.setDefaultCloseOperation(0);
        } else {
            this.setDefaultCloseOperation(2);
        }
        if (this.parentUndoManagerStarted) {
            String stopName;
            String name = "";
            if (stopModel != null && (stopName = stopModel.getName()) != null) {
                name = stopName;
            }
            this.getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.message.changeStop", new Serializable[]{name}));
            this.getUndoManager().startTransaction();
        } else {
            this.getUndoManager().startTransaction();
        }
        this.getContentPane().add((Component)this.createMainPane(stopModel), "Center");
        this.pack();
        SwingUtils.center((Window)this, parent);
        this.setVisible(true);
    }

    private JPanel createMainPane(StopModel stopModel) {
        this.stopModel = stopModel;
        this.stopPane = new JPanel(new BorderLayout());
        if (stopModel.getName() != null) {
            this.setTitle(ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stop", new Serializable[0]) + " " + stopModel.getName());
        }
        this.stopTabbedPane = this.createStopPanel();
        this.stopPane.add((Component)this.stopTabbedPane, "Center");
        this.addAndUpdateStopActions.loadStopModel();
        this.addAndUpdateStopActions.setStopDialogEditable(this.editable);
        this.serviceTicketRealtionPanel = new ServiceTicketRelationPanel(this);
        this.serviceTicketRealtionPanel.loadServiceStopRelations(this.stopModel, this.stopTabbedPane);
        StopInformationPanel stopInformationPanel = new StopInformationPanel(this);
        stopInformationPanel.loadInformation(this.stopModel, this.stopTabbedPane);
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_SUPER)) {
            this.stopLocationCapturingPane = new StopLocationCapturingPane(stopModel, this.modelEnviroment);
            this.stopTabbedPane.addTab(ModelEnviroment.getMessageResolver().resolveMessage("messages.locationCapturings", new Serializable[0]), this.stopLocationCapturingPane);
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel innerButtonPanel = new JPanel(new FlowLayout());
        JButton b = new JButton(this.addAndUpdateStopActions.getCancelStopModelAction());
        innerButtonPanel.add(b);
        b = new JButton(this.addAndUpdateStopActions.getSaveStopModelAction());
        innerButtonPanel.add(b);
        buttonPanel.add((Component)innerButtonPanel, "East");
        this.stopPane.add((Component)buttonPanel, "South");
        return this.stopPane;
    }

    public void showDialog(List<StopModel> stops, boolean editable, Component parent) {
        if (stops == null || stops.isEmpty()) {
            return;
        }
        if (stops.size() > 1) {
            this.createControlPanel(stops);
        }
        this.showDialog(stops.iterator().next(), editable, parent);
    }

    private void createControlPanel(final List<StopModel> stops) {
        final Holder<Integer> index = new Holder<Integer>(0);
        final JLabel indexLabel = new JLabel(index.getElement() + 1 + "/" + stops.size());
        this.setTitle(stops.get(index.getElement()).getName());
        JPanel controlPanel = new JPanel(new FlowLayout());
        BasicArrowButton leftButton = new BasicArrowButton(7);
        leftButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        leftButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = 5995062268335285662L;

            @Override
            public void actionPerformed(ActionEvent e) {
                index.setElement(Math.max((Integer)index.getElement() - 1, 0));
                AddAndUpdateStopDialog.this.changeStop((StopModel)stops.get((Integer)index.getElement()));
                indexLabel.setText((Integer)index.getElement() + 1 + "/" + stops.size());
            }
        });
        controlPanel.add(leftButton);
        controlPanel.add(indexLabel);
        BasicArrowButton rightButton = new BasicArrowButton(3);
        rightButton.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        rightButton.setAction(new AbstractAction(){
            private static final long serialVersionUID = -3131380238598237820L;

            @Override
            public void actionPerformed(ActionEvent e) {
                index.setElement(Math.min((Integer)index.getElement() + 1, stops.size() - 1));
                AddAndUpdateStopDialog.this.changeStop((StopModel)stops.get((Integer)index.getElement()));
                indexLabel.setText((Integer)index.getElement() + 1 + "/" + stops.size());
            }
        });
        controlPanel.add(rightButton);
        this.getContentPane().add((Component)controlPanel, "North");
    }

    private void changeStop(StopModel stop) {
        this.getContentPane().remove(this.stopPane);
        this.getContentPane().add((Component)this.createMainPane(stop), "Center");
        this.pack();
    }

    public JButton getAddTimeWindowButton() {
        return this.addTimeWindowButton;
    }

    public JButton getRemoveTimeWindowButton() {
        return this.removeTimeWindowButton;
    }

    public UndoManager getUndoManager() {
        return this.modelEnviroment.getUndoManager();
    }

    public JTextField getNameField() {
        return this.nameField;
    }

    public JLabel getMessageField() {
        return this.messageField;
    }

    public JPanel getTimeWindowsPanel() {
        return this.timeWindowsPanel;
    }

    public List<Quad<JLabel, JSpinner, JLabel, JSpinner>> getTimeWindowFields() {
        return this.timeWindowFields;
    }

    public JTextField getLocationCountry() {
        return this.locationCountry;
    }

    public JTextField getLocationCity() {
        return this.locationCity;
    }

    public JTextField getLocationPost() {
        return this.locationPost;
    }

    public JTextField getLocationStreet() {
        return this.locationStreet;
    }

    public JTextField getLocationNumber() {
        return this.locationNumber;
    }

    public JTextField getLocationNumberEx() {
        return this.locationNumberEx;
    }

    public JTextField getLocationXField() {
        return this.locationXField;
    }

    public JTextField getLocationYField() {
        return this.locationYField;
    }

    public ScrollablePopupMenu getLocationSelectMenu() {
        return this.locationSelectMenu;
    }

    public List<LocationModel> getAllLocations() {
        return this.allLocations;
    }

    public JLabel getServiceTicketStopRelationMessage() {
        return this.serviceTicketStopRelationMessage;
    }

    public Iterator<ServiceTicketStopRelationModel> getServiceTicketStopRelationFields() {
        return this.stopModel.iterateServiceStopRelations();
    }

    public JComboBox getBranchComboBox() {
        return this.branchComboBox;
    }

    public StopModel getStopModel() {
        return this.stopModel;
    }

    public void setStopModel(StopModelImpl stopModelImpl) {
        this.stopModel = stopModelImpl;
    }

    public AddAndUpdateStopListener getAddAndUpdateStopListener() {
        return this.addAndUpdateStopListener;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public AddAndUpdateStopActions getAddAndUpdateStopActions() {
        return this.addAndUpdateStopActions;
    }

    public boolean isParentUndoManagerStarted() {
        return this.parentUndoManagerStarted;
    }

    public StopTablePanel getStopTablePanel() {
        return this.stopTablePanel;
    }

    public ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }

    @Override
    public void pause() {
        this.setVisible(false);
    }

    @Override
    public void resume() {
        this.addAndUpdateStopActions.loadStopModel();
        if (this.stopLocationCapturingPane != null) {
            this.stopLocationCapturingPane.refreshPoint();
        }
        this.setVisible(true);
    }
}

