/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.map.legend;

import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.map.legend.TourAttribute;
import de.datomino.peppergis.tourmanager.gui.map.legend.TourAttributeNode;
import java.awt.Color;
import javax.swing.tree.DefaultMutableTreeNode;

public class TourNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -1860899659723908172L;
    private Color color;
    private String trackingInfo;

    public TourNode(TourModel tourModel, Color color) {
        super(tourModel);
        this.color = color;
    }

    public TourModel getTourModel() {
        return (TourModel)this.getUserObject();
    }

    public Color getColor() {
        return this.color;
    }

    public void createAndAddAttributeNodes() {
        DefaultMutableTreeNode infoNode = new DefaultMutableTreeNode("Tour-Informationen");
        infoNode.add(new TourAttributeNode(this.getTourModel(), TourAttribute.TIME, Color.BLACK));
        infoNode.add(new TourAttributeNode(this.getTourModel(), TourAttribute.DURATION, Color.BLACK));
        infoNode.add(new TourAttributeNode(this.getTourModel(), TourAttribute.DISTANCE, Color.BLACK));
        if (TourModelUtil.tour_weight_active) {
            infoNode.add(new TourAttributeNode(this.getTourModel(), TourAttribute.WEIGHT, Color.BLACK));
        }
        if (TourModelUtil.tourWeightPeakActive) {
            infoNode.add(new TourAttributeNode(this.getTourModel(), TourAttribute.WEIGHT_PEAK, Color.BLACK));
        }
        if (TourModelUtil.tour_cost_active) {
            infoNode.add(new TourAttributeNode(this.getTourModel(), TourAttribute.COST, Color.BLACK));
        }
        this.add(infoNode);
    }

    public String getTrackingInfo() {
        return this.trackingInfo;
    }

    public void setTrackingInfo(String trackingInfo) {
        this.trackingInfo = trackingInfo;
    }
}

