/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.map;

import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.manager.ManagerPointRenderer;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TimeWindowModel;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class UnsortedStopLayerRenderer
implements NavigatorRenderer {
    private NavigatorPanel navigatorPanel;
    private Collection<StopModel> unsortedStops;
    private Map<StopModel, Rectangle2D.Double> drawedStopsOnMap = new HashMap<StopModel, Rectangle2D.Double>();
    private Tupel<StopModel, Point2D.Double> mouseMoved;
    private boolean active;
    private TourMapGui mapGui;
    private StopFilterEntity filterEntity;
    private List<NavigatorRendererActiveListener> navigatorPanelActiveListeners = new ArrayList<NavigatorRendererActiveListener>();
    private int sortOrder = Integer.MAX_VALUE;

    public UnsortedStopLayerRenderer(boolean active, TourMapGui tourMapGui) {
        this.active = active;
        this.mapGui = tourMapGui;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        ManagerPointRenderer pointRenderer = new ManagerPointRenderer(g2d, upp, this.navigatorPanel.getCoordinateFactory(), null){

            @Override
            protected boolean isSelected(Object o) {
                if (!(UnsortedStopLayerRenderer.this.mapGui instanceof TourMapGui)) {
                    return false;
                }
                if (UnsortedStopLayerRenderer.this.mapGui.getSelectedStopsForAdd().contains(o)) {
                    return true;
                }
                return UnsortedStopLayerRenderer.this.mapGui.getSelectedStopsForRemove().contains(o);
            }
        };
        double margin = 35.0 * Math.pow(upp, -0.2) * upp;
        this.drawedStopsOnMap = new HashMap<StopModel, Rectangle2D.Double>();
        ArrayList<StopModel> drawedStops = new ArrayList<StopModel>();
        for (StopModel stop : this.getStopsInFilter()) {
            if (stop.getTourPart() != null || drawedStops.contains(stop) || stop.getTourPart() != null || stop.getLocation() == null) continue;
            List<StopModel> overlappedStops = this.getOverlappedStop(margin, stop, drawedStops);
            drawedStops.addAll(overlappedStops);
            Map<StopModel, Rectangle2D.Double> drawedStopsWithPosition = pointRenderer.drawUnsortedStopsWithStack(overlappedStops, margin, this.navigatorPanel.getCoordinateFactory());
            this.drawedStopsOnMap.putAll(drawedStopsWithPosition);
        }
        if (this.mouseMoved != null && this.mouseMoved.getElement1() != null) {
            String text = StopModelUtil.getDisplayString(this.mouseMoved.getElement1());
            Coordinate c = this.navigatorPanel.getCoordinateFactory().createCoordinate(this.mouseMoved.getElement2());
            pointRenderer.drawInfoBox(CollectionUtil.buildArrayList(text), c, Color.BLACK, 11.0 * upp);
        }
        return Collections.emptyList();
    }

    private Collection<StopModel> getStopsInFilter() {
        if (this.filterEntity == null) {
            return this.unsortedStops;
        }
        HashSet<StopModel> stopsInFilter = new HashSet<StopModel>();
        for (StopModel stop : this.unsortedStops) {
            if (!this.isInFilter(stop)) continue;
            stopsInFilter.add(stop);
        }
        return stopsInFilter;
    }

    private boolean isInFilter(StopModel stop) {
        boolean b = stop.isTimeWindowsEmpty();
        if (!b) {
            Date lower = this.filterEntity.getStartTime();
            Date upper = this.filterEntity.getEndTime();
            if (lower != null && upper != null) {
                for (TimeWindowModel timeWindowModel : stop.iterableTimeWindows()) {
                    Date lowerT = timeWindowModel.getStartTime();
                    Date upperT = timeWindowModel.getEndTime();
                    if (upperT.compareTo(lower) < 0 || lowerT.compareTo(upper) > 0) continue;
                    b = true;
                }
            } else {
                b = true;
            }
        }
        if (b) {
            LocationWrapper locationWrapper;
            String postcode;
            String startPostcode = StringUtil.emptyToNull(this.filterEntity.getStartPostcode());
            String endPostcode = StringUtil.emptyToNull(this.filterEntity.getEndPostcode());
            if ((startPostcode != null || endPostcode != null) && (postcode = (locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(stop.getLocation())).getPostcode()) != null && (startPostcode != null && startPostcode.compareTo(postcode.substring(0, Math.min(postcode.length(), startPostcode.length()))) > 0 || endPostcode != null && endPostcode.compareTo(postcode.substring(0, Math.min(postcode.length(), endPostcode.length()))) < 0)) {
                b = false;
            }
        }
        return b;
    }

    private List<StopModel> getOverlappedStop(double margin, StopModel stop0, List<StopModel> drawedStops) {
        ArrayList<StopModel> overlappedStops = new ArrayList<StopModel>();
        for (StopModel stop : this.unsortedStops) {
            if (drawedStops.contains(stop) || stop.getTourPart() != null || !ManagerPointRenderer.isOverlapped(margin, this.getPoint(stop), this.getPoint(stop0))) continue;
            overlappedStops.add(stop);
        }
        return overlappedStops;
    }

    private ImmutablePoint getPoint(StopModel stop) {
        if (stop.getLocation() == null) {
            return null;
        }
        ImmutablePoint point = LocationWrapperFactory.INSTANCE.createLocationWrapper(stop.getLocation()).getGeoLocation();
        point = point == null ? null : (ImmutablePoint)point.getTransformed(this.navigatorPanel.getCoordinateFactory());
        return point;
    }

    public void removePoint(StopModel stop) {
        this.drawedStopsOnMap.remove(stop);
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setUnsortedStops(Collection<StopModel> unsortedStops) {
        HashSet<StopModel> sortedStops = new HashSet<StopModel>();
        for (StopModel stop : unsortedStops) {
            if (stop.getTourPart() == null) continue;
            sortedStops.add(stop);
        }
        unsortedStops.removeAll(sortedStops);
        this.unsortedStops = unsortedStops;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    public Map<StopModel, Rectangle2D.Double> getDrawedPointsOnMap() {
        return this.drawedStopsOnMap;
    }

    public Tupel<StopModel, Point2D.Double> getMouseMoved() {
        if (this.mouseMoved == null) {
            this.mouseMoved = new Tupel<Object, Object>(null, null);
        }
        return this.mouseMoved;
    }

    public void setMouseMoved(Tupel<StopModel, Point2D.Double> mouseMoved) {
        this.mouseMoved = mouseMoved;
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.navigatorPanel.repaint(10L);
            this.fireActiveChanged();
        }
    }

    @Override
    public String getName() {
        return "StopLayerRenderer";
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.remove(navigatorPanelActiveListener);
    }

    protected void fireActiveChanged() {
        NavigatorRendererActivateEvent navigatorPanelActivateEvent = new NavigatorRendererActivateEvent(this, this.isActive());
        for (NavigatorRendererActiveListener navigatorPanelActiveListener : this.navigatorPanelActiveListeners) {
            navigatorPanelActiveListener.valueChanged(navigatorPanelActivateEvent);
        }
    }

    public void doMouseMoved(Point2D.Double real) {
        if (this.isActive()) {
            this.setMouseMoved(null);
            Set<StopModel> stops = this.getDrawedPointsOnMap().keySet();
            for (StopModel stop : stops) {
                Rectangle2D.Double rectangle = this.getDrawedPointsOnMap().get(stop);
                if (!rectangle.contains(real)) continue;
                this.setMouseMoved(new Tupel<StopModel, Point2D.Double>(stop, new Point2D.Double(rectangle.getCenterX(), rectangle.getCenterY())));
                break;
            }
        }
    }

    public void setFilterEntity(StopFilterEntity filterEntity) {
        this.filterEntity = filterEntity;
    }

    @Override
    public void close() {
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

