/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.map;

import de.datomino.peppergis.client.action.ChooseSubscriptionOnMapAction;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.gui.area.AreaObjectCompletableTextField;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.ThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.parcel.ParcelLayerRenderer;
import de.datomino.peppergis.client.gui.renderer.MapScaleRenderer;
import de.datomino.peppergis.client.gui.renderer.ZoomingRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.gui.subscription.SubscriptionLayerRenderer;
import de.datomino.peppergis.client.manager.AbstractManagerMapGui;
import de.datomino.peppergis.client.manager.handler.DisablingDoubleClickMouseListener;
import de.datomino.peppergis.client.manager.legend.FilterLegendListRenderer;
import de.datomino.peppergis.client.manager.legend.LegendObject;
import de.datomino.peppergis.client.manager.legend.LegendType;
import de.datomino.peppergis.client.manager.util.ManagerMapUtil;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.model.tour.TourPartModel;
import de.datomino.peppergis.client.util.AreaTourInfoObject;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.FilterEntity;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.client.util.model.subscription.SubscriptionLocationObject;
import de.datomino.peppergis.tourmanager.gui.filter.StopFilterLayerRenderer;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.gui.map.TourLayerRenderer;
import de.datomino.peppergis.tourmanager.gui.map.TourLegendTreeRenderer;
import de.datomino.peppergis.tourmanager.gui.map.UnsortedStopLayerRenderer;
import de.datomino.peppergis.tourmanager.gui.map.legend.StopAttribute;
import de.datomino.peppergis.tourmanager.gui.map.legend.StopAttributeNode;
import de.datomino.peppergis.tourmanager.gui.map.legend.StopNode;
import de.datomino.peppergis.tourmanager.gui.map.legend.TourAttributeNode;
import de.datomino.peppergis.tourmanager.gui.map.legend.TourNode;
import de.datomino.peppergis.tourmanager.gui.tracking.GeoTrackingLegendPane;
import de.datomino.peppergis.tourmanager.gui.tracking.GeoTrackingRenderer;
import de.datomino.peppergis.tourmanager.gui.tracking.TourTrackingRenderer;
import de.datomino.peppergis.tourmanager.handler.TourManagerJobManager;
import de.datomino.peppergis.tourmanager.handler.TourMapActions;
import de.datomino.peppergis.tourmanager.handler.action.routing.ToursRoutingAction;
import de.datomino.peppergis.tourmanager.listener.filter.FilterLegendListListener;
import de.datomino.peppergis.tourmanager.listener.map.TourLegendTreeListener;
import de.datomino.peppergis.tourmanager.listener.map.TourMapMouseListener;
import de.datomino.peppergis.tourmanager.listener.map.TourMapMouseManipulator;
import de.datomino.peppergis.type.UserRole;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.StringComparator;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import de.datomino.util.geo.model.StaticGeoObjectBucketsModel;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorPanningAction;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class TourMapGui
extends AbstractManagerMapGui<TourModel> {
    private static final long serialVersionUID = -4530128702418519803L;
    private Collection<TourModel> selectedTours;
    private LinkedHashMap<TourModel, Color> toursWithColor;
    private Set<StopModel> unsortedStops;
    private Set<StopModel> selectedStopsForRemove;
    private Set<StopModel> selectedStopsForAdd;
    private TourMapActions tourMapActions;
    private JScrollPane tourLegendPane;
    private DefaultTreeModel tourLegendTreeModel;
    private JTree tourLegendTree;
    private Set<Coordinate> areaRectangles;
    private JButton updateButton;
    private JList filterLegendList;
    private DefaultListModel filterLegendListModel;
    private JPanel filterLegendPane;
    private GeoTrackingLegendPane geoTrackingLegendPane;
    private JTabbedPane legendTabbedPane;
    private UnsortedStopLayerRenderer unsortedStopLayerRenderer;
    private StopFilterLayerRenderer stopFilterLayerRenderer;
    private ChooseSubscriptionOnMapAction chooseSubscriptionOnMapAction;
    private StaticGeoObjectBucketsModel<SubscriptionLocationObject, ImmutablePoint> subscriptionGeoObjectBucketsModel;
    private TourMapMouseManipulator mouseManipulator;
    private FilterEntity filter;
    private TourManagerCalendarGui tourManagerCalendarGui;
    private GeoTrackingRenderer geoTrackingRenderer;
    private TourLayerRenderer tourLayerRenderer;
    private AreaLayerRenderer postcodeLayerRenderer;
    protected AreaLayerModel postcodeAreaLayer;
    private AreaObjectCompletableTextField legendAreaObjectSelector;
    private TourTrackingRenderer tourTrackingRenderer;

    public TourMapGui(TourManagerCalendarGui tourManagerCalendarGui) throws IOException {
        super((LayoutManager)new BorderLayout(), tourManagerCalendarGui.getModelEnviroment());
        this.tourManagerCalendarGui = tourManagerCalendarGui;
        this.unsortedStops = this.tourManagerCalendarGui.getUnsortedStops();
        this.modelEnviroment = this.tourManagerCalendarGui.getModelEnviroment();
    }

    @Override
    public TourModel getSelectedModel() {
        DefaultMutableTreeNode selObject = this.getSelObjectFromLegendTree();
        if (selObject instanceof TourNode) {
            return ((TourNode)selObject).getTourModel();
        }
        return null;
    }

    @Override
    public void repaintGui(boolean tourUpdate) {
        if (this.toursWithColor == null || this.toursWithColor.isEmpty()) {
            return;
        }
        boolean updateLine = StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("tour.renderer.line.updateAlways"));
        boolean updateMap = updateLine || !tourUpdate;
        this.loadToursOnMap(updateMap);
        this.updateButton.setVisible(tourUpdate);
        this.updateButton.setEnabled(tourUpdate);
        this.repaint(10L);
    }

    public void initialized(Coordinate startCoordinate) throws IOException {
        this.initializedMapPanel(startCoordinate);
        JPanel tourLegendPanel = this.createTourLegendPanel();
        boolean toursInLegend = ((DefaultMutableTreeNode)this.tourLegendTreeModel.getRoot()).getChildCount() > 0;
        this.tourManagerCalendarGui.getActions().getExportSelectedToursInMapToServerAction().setEnabled(toursInLegend);
        this.geoTrackingLegendPane = new GeoTrackingLegendPane(this);
        this.legendTabbedPane = new JTabbedPane(1, 0);
        JPanel filterLegendPanel = null;
        JPanel routePlannerPanel = null;
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.ADMIN)) {
            filterLegendPanel = this.createFilterLegendPanel();
            routePlannerPanel = this.createRoutePlannerPane(this.legendTabbedPane);
        }
        this.legendTabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.tour", new Serializable[0]), tourLegendPanel);
        this.legendTabbedPane.add("Tracking", ClientSwingUtil.createPanelForComponent(this.geoTrackingLegendPane, "Legend f\u00fcr Tracking"));
        this.legendTabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("gui.filter.filter", new Serializable[0]), filterLegendPanel);
        this.legendTabbedPane.add(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.routePlanner", new Serializable[0]), routePlannerPanel);
        this.updateButton = new JButton(new ToursRoutingAction(this.tourManagerCalendarGui, this, this.tourManagerCalendarGui.getBusyHandler()){
            private static final long serialVersionUID = 3769715227434605125L;

            @Override
            protected void repaintGui() {
                TourMapGui.this.repaintGui(false);
                TourMapGui.this.getTourManagerCalendarGui().getTimeLineGui().refresh(this.getTours());
            }

            @Override
            protected Collection<TourModel> getTours() {
                return TourMapGui.this.getToursWithColor().keySet();
            }
        });
        this.updateButton.setForeground(Color.RED);
        this.updateButton.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        this.updateButton.setEnabled(false);
        this.updateButton.setVisible(false);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.updateButton, "North");
        leftPanel.add((Component)this.legendTabbedPane, "Center");
        JSplitPane splitPane = new JSplitPane(1, leftPanel, this.navigatorPanel);
        splitPane.setOneTouchExpandable(true);
        this.add((Component)splitPane, "Center");
        this.tourMapActions = new TourMapActions(this, this.tourManagerCalendarGui);
    }

    private JPanel createFilterLegendPanel() {
        this.filterLegendListModel = new DefaultListModel();
        this.filterLegendList = new JList(this.filterLegendListModel);
        this.filterLegendList.setCellRenderer(new FilterLegendListRenderer());
        FilterLegendListListener filterLegendListListener = new FilterLegendListListener(this, this.tourManagerCalendarGui.getBusyHandler());
        this.filterLegendList.addMouseListener(filterLegendListListener);
        this.filterLegendList.addMouseMotionListener(filterLegendListListener);
        this.filterLegendList.addKeyListener(filterLegendListListener);
        JScrollPane listPane = new JScrollPane(this.filterLegendList);
        listPane.setPreferredSize(FormUtil.SIZEOFLISTANDTREE);
        JPanel changeAreaPane = new JPanel(new BorderLayout());
        final BasicArrowButton lastAreaButton = new BasicArrowButton(7);
        final BasicArrowButton nextAreaButton = new BasicArrowButton(3);
        lastAreaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AreaObjectModel selectedItem;
                int selectedIndex;
                List dataList = TourMapGui.this.legendAreaObjectSelector.getDataList();
                if (!dataList.isEmpty() && (selectedIndex = dataList.indexOf(selectedItem = (AreaObjectModel)TourMapGui.this.legendAreaObjectSelector.getSelectedObject())) > 0) {
                    TourMapGui.this.legendAreaObjectSelector.setSelectedObject(null);
                    AreaObjectModel newArea = (AreaObjectModel)dataList.get(selectedIndex - 1);
                    TourMapGui.this.updateLegend(newArea);
                    nextAreaButton.setEnabled(true);
                }
            }
        });
        changeAreaPane.add((Component)lastAreaButton, "West");
        nextAreaButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedItem;
                int selectedIndex;
                List dataList = TourMapGui.this.legendAreaObjectSelector.getDataList();
                if (!dataList.isEmpty() && (selectedIndex = dataList.indexOf(selectedItem = TourMapGui.this.legendAreaObjectSelector.getSelectedObject())) < dataList.size() - 1) {
                    AreaObjectModel newArea = (AreaObjectModel)dataList.get(selectedIndex + 1);
                    TourMapGui.this.updateLegend(newArea);
                    lastAreaButton.setEnabled(true);
                }
            }
        });
        changeAreaPane.add((Component)nextAreaButton, "East");
        if (!NavigatorPanel.HEADLESS) {
            this.legendAreaObjectSelector = new AreaObjectCompletableTextField(this.modelEnviroment.getAllCaller().getAreaCaller(), SwingUtils.findWindowParent(this)){
                private static final long serialVersionUID = 5651706973448983388L;

                @Override
                public void makeSelection() {
                    super.makeSelection();
                    AreaObjectModel selectedObject = (AreaObjectModel)TourMapGui.this.legendAreaObjectSelector.getSelectedObject();
                    TourMapGui.this.updateLegend(selectedObject);
                    List dataList = TourMapGui.this.legendAreaObjectSelector.getDataList();
                    int index = dataList.indexOf(selectedObject);
                    if (index == -1) {
                        lastAreaButton.setEnabled(false);
                        nextAreaButton.setEnabled(false);
                    } else if (index == 0) {
                        lastAreaButton.setEnabled(false);
                    } else if (index == dataList.size() - 1) {
                        nextAreaButton.setEnabled(false);
                    } else {
                        lastAreaButton.setEnabled(true);
                        nextAreaButton.setEnabled(true);
                    }
                }
            };
            changeAreaPane.add((Component)this.legendAreaObjectSelector, "Center");
        }
        this.filterLegendPane = new JPanel(new BorderLayout());
        this.filterLegendPane.add((Component)listPane, "Center");
        return ClientSwingUtil.createPanelForComponent(this.filterLegendPane, ModelEnviroment.getMessageResolver().resolveMessage("gui.route.filterLegend", new Serializable[0]));
    }

    protected void updateLegend(AreaObjectModel newArea) {
        this.filter.getSelectedAreaObjects().clear();
        this.filter.getSelectedAreaObjects().add(newArea);
        if (this.filter.getType() == LegendType.PARCEL) {
            throw new RuntimeException("should not be called");
        }
        if (this.filter.getType() == LegendType.SUBSCRIPTION) {
            throw new RuntimeException("should not be called");
        }
    }

    private JPanel createTourLegendPanel() {
        MouseListener[] listeners;
        this.tourLegendTreeModel = new DefaultTreeModel(new DefaultMutableTreeNode(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.markingWithColor", new Serializable[0])));
        this.tourLegendTreeModel.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                this.setExportEnabled();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                this.setExportEnabled();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                this.setExportEnabled();
            }

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                this.setExportEnabled();
            }

            private void setExportEnabled() {
                boolean toursInLegend = ((DefaultMutableTreeNode)TourMapGui.this.tourLegendTreeModel.getRoot()).getChildCount() > 0;
                TourMapGui.this.tourManagerCalendarGui.getActions().getExportSelectedToursInMapToServerAction().setEnabled(toursInLegend);
            }
        });
        this.tourLegendTree = new JTree(this.tourLegendTreeModel);
        for (MouseListener listener : listeners = this.tourLegendTree.getMouseListeners()) {
            this.tourLegendTree.removeMouseListener(listener);
            this.tourLegendTree.addMouseListener(new DisablingDoubleClickMouseListener(listener));
        }
        this.tourLegendTree.setCellRenderer(new TourLegendTreeRenderer());
        this.tourLegendTree.setScrollsOnExpand(true);
        this.tourLegendTree.getSelectionModel().setSelectionMode(1);
        TourLegendTreeListener tourLegendTreeListener = new TourLegendTreeListener(this);
        this.tourLegendTree.addMouseListener(tourLegendTreeListener);
        this.tourLegendTree.addMouseMotionListener(tourLegendTreeListener);
        this.tourLegendPane = new JScrollPane(this.tourLegendTree);
        this.tourLegendPane.setPreferredSize(FormUtil.SIZEOFLISTANDTREE);
        return ClientSwingUtil.createPanelForComponent(this.tourLegendPane, ModelEnviroment.getMessageResolver().resolveMessage("gui.route.routeLegend", new Serializable[0]));
    }

    private void initializedMapPanel(Coordinate startCoordinate) throws IOException {
        if (startCoordinate == null) {
            startCoordinate = MercatorFactory.INSTANCE.createCoordinate(1293576.0, 6116444.0);
        }
        this.navigatorPanel = new NavigatorPanel(startCoordinate, OpenStreetmapViewFactory.INSTANCE, null);
        this.navigatorPanel.setPanning(true);
        NavigatorPanningAction panningAction = this.navigatorPanel.getPanningAction();
        if (panningAction != null) {
            panningAction.setSelected(true);
        }
        this.navigatorPanel.setCursor(Cursor.getDefaultCursor());
        this.addRenderers();
        if (ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER, UserRole.ADMIN)) {
            this.mouseManipulator = new TourMapMouseManipulator(this);
            this.navigatorPanel.setMouseManipulator(this.mouseManipulator);
            this.navigatorPanel.addPreferredMouseManipulatorForClick(this.mouseManipulator);
            this.navigatorPanel.addMouseListener(new TourMapMouseListener(this));
        }
    }

    private void addRenderers() throws IOException {
        ThreadingOsmNavigatorRenderer osmNavigatorRenderer = new ThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
        this.addRenderer(osmNavigatorRenderer);
        DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel = new DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(100000.0, this.getNavigatorPanel().getCoordinateFactory(), TourMapGui.createAreaGeomExtractor());
        bucketsModel.setFetchCallback(new BucketsFetchCallback<AreaObjectModel, ImmutablePolygonKind>(){

            @Override
            public Collection<AreaObjectModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                Collection<AreaObjectModel> areaObjects = Collections.emptySet();
                if (TourMapGui.this.getPostcodeAreaLayer() != null) {
                    AreaCaller areaCaller = TourMapGui.this.getModelEnviroment().getAllCaller().getAreaCaller();
                    areaObjects = areaCaller.fetchAreaObjects(TourMapGui.this.getPostcodeAreaLayer(), topLeft, bottomRight);
                }
                return areaObjects;
            }
        });
        bucketsModel.setBusyHandler(this.tourManagerCalendarGui.getBusyHandler());
        this.postcodeLayerRenderer = AreaLayerRenderer.createDefaultAreaLayerRenderer("Renderer for Postcodes", bucketsModel, TourMapGui.createAreaGeomExtractor(), "postcode", this.getModelEnviroment(), null, true, this.navigatorPanel);
        this.postcodeLayerRenderer.setActive(false);
        this.addRenderer(this.postcodeLayerRenderer);
        this.tourLayerRenderer = new TourLayerRenderer(this, this.modelEnviroment);
        this.addRenderer(this.tourLayerRenderer);
        this.unsortedStopLayerRenderer = new UnsortedStopLayerRenderer(false, this);
        this.addRenderer(this.unsortedStopLayerRenderer);
        this.stopFilterLayerRenderer = new StopFilterLayerRenderer(false, this);
        this.addRenderer(this.stopFilterLayerRenderer);
        ParcelLayerRenderer parcelLayerRenderer = new ParcelLayerRenderer(this, this.modelEnviroment, false);
        this.addRenderer(parcelLayerRenderer);
        SubscriptionLayerRenderer subscriptionLayerRenderer = new SubscriptionLayerRenderer(this, this.modelEnviroment, false);
        this.addRenderer(subscriptionLayerRenderer);
        this.subscriptionGeoObjectBucketsModel = new StaticGeoObjectBucketsModel<SubscriptionLocationObject, ImmutablePoint>(TourMapGui.createSubscriptionGeomExtractor(), this.navigatorPanel.getCoordinateFactory());
        this.chooseSubscriptionOnMapAction = new ChooseSubscriptionOnMapAction(this.navigatorPanel, this.subscriptionGeoObjectBucketsModel, this.modelEnviroment, false){
            private static final long serialVersionUID = 6505166528810449938L;

            @Override
            protected void renderHover(Collection<SubscriptionLocationObject> s) {
            }

            @Override
            protected Component getParent() {
                return TourMapGui.this;
            }
        };
        this.geoTrackingRenderer = new GeoTrackingRenderer(this);
        this.geoTrackingRenderer.setActive(false);
        this.addRenderer(this.geoTrackingRenderer);
        this.tourTrackingRenderer = new TourTrackingRenderer(this);
        this.addRenderer(this.tourTrackingRenderer);
        MapScaleRenderer renderer = new MapScaleRenderer(ModelEnviroment.getMessageResolver().resolveMessage("messages.common.mapScale", new Serializable[0]));
        this.addRenderer(renderer);
        ZoomingRenderer zoomingRenderer = new ZoomingRenderer(this.navigatorPanel);
        this.addRenderer(zoomingRenderer);
        this.navigatorPanel.addPreferredMouseManipulatorForClick(zoomingRenderer);
    }

    private static GeomExtractor<SubscriptionLocationObject, ImmutablePoint> createSubscriptionGeomExtractor() {
        return new GeomExtractor<SubscriptionLocationObject, ImmutablePoint>(){

            @Override
            public ImmutablePoint getGeom(SubscriptionLocationObject subscriptionModel) {
                return subscriptionModel.getImmutablePoint();
            }
        };
    }

    private void loadTourLegendPanel(Map<TourModel, Color> toursWithColorOnMap) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.tourLegendTreeModel.getRoot();
        TreePath rootPath = new TreePath(rootNode);
        Set<TourModel> expandedTours = this.getExpandedTours(rootNode);
        rootNode.removeAllChildren();
        HashSet<TreePath> expandedTreePath = new HashSet<TreePath>(expandedTours.size());
        ArrayList<TourModel> list = new ArrayList<TourModel>(toursWithColorOnMap.keySet());
        Collections.sort(list, new StringComparator<TourModel>(true){

            @Override
            protected String getString(TourModel o) {
                return o.getName();
            }
        });
        for (TourModel tour : list) {
            TourNode tourNode = new TourNode(tour, toursWithColorOnMap.get(tour));
            tourNode.createAndAddAttributeNodes();
            int index = 1;
            Iterator<TourPartModel> tourPartIter = tour.iterateTourParts();
            while (tourPartIter.hasNext()) {
                Iterator<StopModel> stopIter = tourPartIter.next().iterateStops();
                while (stopIter.hasNext()) {
                    StopModel next = stopIter.next();
                    StopNode stopNode = new StopNode(next, index, Color.BLACK);
                    this.createAndAddAttributeNodes(stopNode, next, Color.BLACK);
                    tourNode.add(stopNode);
                    ++index;
                }
            }
            rootNode.add(tourNode);
            if (!expandedTours.contains(tour)) continue;
            expandedTreePath.add(rootPath.pathByAddingChild(tourNode));
        }
        this.tourLegendTreeModel.reload();
        this.legendTabbedPane.setSelectedComponent(this.tourLegendPane.getParent());
        for (TreePath treePath : expandedTreePath) {
            this.tourLegendTree.expandPath(treePath);
        }
    }

    private void createAndAddAttributeNodes(DefaultMutableTreeNode stopNode, StopModel stopModel, Color color) {
        stopNode.add(new StopAttributeNode(stopModel, StopAttribute.TIME, color));
        stopNode.add(new StopAttributeNode(stopModel, StopAttribute.DURATION, color));
        stopNode.add(new StopAttributeNode(stopModel, StopAttribute.MILEAGE, color));
        if (TourModelUtil.tour_weight_active) {
            stopNode.add(new StopAttributeNode(stopModel, StopAttribute.WEIGHT, color));
        }
        try {
            String property = ModelEnviroment.getProperties().getProperty("stop.legend.company.active");
            if (property == null || Boolean.parseBoolean(property)) {
                stopNode.add(new StopAttributeNode(stopModel, StopAttribute.COMPANY, color));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stopNode.add(new StopAttributeNode(stopModel, StopAttribute.INFO, color));
    }

    private Set<TourModel> getExpandedTours(DefaultMutableTreeNode rootNode) {
        HashSet<TourModel> expandedTours = new HashSet<TourModel>();
        for (int i = 0; i < rootNode.getChildCount(); ++i) {
            Object object;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)rootNode.getChildAt(i);
            if (!this.tourLegendTree.isExpanded(new TreePath(node.getPath())) || !((object = node.getUserObject()) instanceof TourModel)) continue;
            expandedTours.add((TourModel)object);
        }
        return expandedTours;
    }

    private void addRenderer(NavigatorRenderer navigatorRenderer) {
        navigatorRenderer.setNavigatorPanel(this.navigatorPanel);
        this.navigatorPanel.addRenderer(navigatorRenderer);
    }

    public void removeRenderer(NavigatorRenderer navigatorRenderer) {
        navigatorRenderer.setNavigatorPanel(null);
        this.navigatorPanel.removeRenderer(navigatorRenderer);
    }

    public Map<TourModel, Color> getSelectedToursWithColor() {
        Component selectedComponent = this.tourManagerCalendarGui.getTabbedPane().getSelectedComponent();
        if (selectedComponent.equals(this)) {
            return this.getSelectedToursWithColorMap();
        }
        return this.getSelectedToursWithColorTab();
    }

    public Map<TourModel, Color> getSelectedToursWithColorTab() {
        Map<TourModel, Tupel<Integer, Integer>> selectedToursInTable = this.tourManagerCalendarGui.getPlanTableGui().getSelectedToursInTable();
        if (selectedToursInTable == null || selectedToursInTable.isEmpty()) {
            return Collections.emptyMap();
        }
        return ManagerMapUtil.getToursWithColor(selectedToursInTable.keySet());
    }

    public Map<TourModel, Color> getSelectedToursWithColorMap() {
        if (this.toursWithColor == null || this.toursWithColor.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.toursWithColor;
    }

    public void setSelectedTours(Collection<TourModel> tours) {
        this.clearSelectedStopsForRemove();
        this.selectedTours = new HashSet<TourModel>(tours);
        this.loadToursOnMap(true);
    }

    public void removeToursFromMap(Collection<TourModel> tours) {
        HashSet<StopModel> stops = new HashSet<StopModel>();
        for (StopModel stop : this.getSelectedStopsForRemove()) {
            if (stop.getTourPart() == null || !tours.contains(stop.getTourPart().getTour())) continue;
            stops.add(stop);
        }
        this.getSelectedStopsForRemove().removeAll(stops);
        this.selectedTours.removeAll(tours);
        for (TourModel tour : tours) {
            this.geoTrackingLegendPane.getTrackingMap().remove(tour);
            this.toursWithColor.remove(tour);
        }
        this.loadTourLegendPanel(this.toursWithColor);
        this.tourLayerRenderer.removeToursFromMap(tours);
        this.navigatorPanel.repaint(10L);
    }

    private void loadToursOnMap(boolean updateMap) {
        HashSet tourSet = new HashSet(this.selectedTours == null ? new HashSet() : this.selectedTours);
        this.toursWithColor = ManagerMapUtil.getToursWithColor(tourSet);
        this.loadTourLegendPanel(this.toursWithColor);
        if (updateMap) {
            this.tourLayerRenderer.setTourWithColorOnMap(this.toursWithColor);
            this.navigatorPanel.repaint(10L);
        }
    }

    public void loadUnsortedStopsOnMap() {
        this.unsortedStopLayerRenderer.setUnsortedStops(this.unsortedStops);
        this.unsortedStopLayerRenderer.setActive(true);
        this.navigatorPanel.repaint();
    }

    private void reloadUnsortedStopLayerRenderer() {
        this.unsortedStopLayerRenderer.setUnsortedStops(this.unsortedStops);
        this.navigatorPanel.repaint();
    }

    public void clearUnsortedStops() {
        this.clearSelectedStopsForAdd();
        this.unsortedStopLayerRenderer.setActive(false);
        this.navigatorPanel.repaint();
    }

    private void reloadStopFilter(Collection<StopModel> removed) {
        Model m;
        boolean updated = false;
        for (StopModel stop : removed) {
            Object found = null;
            for (int i = 0; i < this.filterLegendListModel.getSize(); ++i) {
                Object o = this.filterLegendListModel.getElementAt(i);
                if (!(o instanceof LegendObject) || !((m = (Model)((LegendObject)o).getM()) instanceof StopModel) || !stop.equals(m)) continue;
                found = o;
            }
            if (found == null) continue;
            this.filterLegendListModel.removeElement(found);
            updated = true;
        }
        if (updated) {
            ArrayList<StopModel> stops = new ArrayList<StopModel>();
            int count = 1;
            for (int i = 0; i < this.filterLegendListModel.getSize(); ++i) {
                LegendObject legendObject;
                Object o = this.filterLegendListModel.getElementAt(i);
                if (!(o instanceof LegendObject) || !((m = (Model)(legendObject = (LegendObject)o).getM()) instanceof StopModel)) continue;
                legendObject.setSortOrder(count++);
                stops.add((StopModel)m);
            }
            this.stopFilterLayerRenderer.setCurrentStops((List<StopModel>)stops);
            this.filterLegendList.repaint(10L);
            this.navigatorPanel.repaint(10L);
        }
    }

    public void center() {
        if (this.areaRectangles == null || this.areaRectangles.isEmpty()) {
            return;
        }
        this.navigatorPanel.center(this.areaRectangles, 10);
    }

    @Override
    public void setAreaRectangles(Set<Coordinate> areaRectangles) {
        this.areaRectangles = areaRectangles;
    }

    public void removeFiltersOnMap() {
        this.stopFilterLayerRenderer.setCurrentStops(Collections.EMPTY_SET);
        this.stopFilterLayerRenderer.setActive(false);
        this.unsortedStopLayerRenderer.setFilterEntity(null);
        this.subscriptionGeoObjectBucketsModel.clear();
        this.chooseSubscriptionOnMapAction.turnOff();
        this.navigatorPanel.setMouseManipulator(this.mouseManipulator);
        this.navigatorPanel.repaint();
        this.filterLegendListModel.clear();
    }

    public void applyStopFilterOnMap(StopFilterEntity stopFilterEntity) {
        int b;
        this.filter = stopFilterEntity;
        this.removeFiltersOnMap();
        TourCaller tourCaller = this.tourManagerCalendarGui.getActions().getTourCaller();
        List<StopModel> stopsWithFilter = tourCaller.fetchStopsWithFilter(stopFilterEntity);
        if (stopsWithFilter.size() > 100 && (b = JOptionPane.showConfirmDialog(this, ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.beforeDisplay", Integer.valueOf(stopsWithFilter.size())), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.confirm", new Serializable[0]), 2)) == 2) {
            return;
        }
        StopModelUtil.sortStopsWithStreet(stopsWithFilter);
        this.stopFilterLayerRenderer.setActive(true);
        this.stopFilterLayerRenderer.setCurrentStops(stopsWithFilter);
        this.areaRectangles = this.stopFilterLayerRenderer.getAreaRectangles();
        ArrayList<LegendObject<? extends Model>> legendObjects = new ArrayList<LegendObject<? extends Model>>(stopsWithFilter.size());
        int index = 1;
        for (StopModel stop : stopsWithFilter) {
            legendObjects.add(new LegendObject<StopModel>(stop, index));
            ++index;
        }
        AreaTourInfoObject header = new AreaTourInfoObject("Tourpunkte", null);
        this.loadFilterLegendPanel(header, legendObjects);
        this.center();
        this.repaint(10L);
    }

    public void loadFilterLegendPanel(AreaTourInfoObject information, List<LegendObject<? extends Model>> modelWithFilter) {
        this.filterLegendListModel.clear();
        if (information != null) {
            this.filterLegendListModel.addElement(information);
        }
        for (LegendObject<? extends Model> legendObject : modelWithFilter) {
            this.filterLegendListModel.addElement(legendObject);
        }
        this.filterLegendList.repaint(10L);
        this.legendTabbedPane.setSelectedComponent(this.filterLegendPane.getParent());
    }

    public void changeStopSymbol() {
        List<NavigatorRenderer> renderers = this.navigatorPanel.getRenderers();
        for (NavigatorRenderer renderer : renderers) {
            if (renderer instanceof TourLayerRenderer) {
                ((TourLayerRenderer)renderer).changeWithStock();
            }
            if (!(renderer instanceof StopFilterLayerRenderer)) continue;
            ((StopFilterLayerRenderer)renderer).changeIsWithStock();
        }
        this.navigatorPanel.repaint();
    }

    public void setStopSymbolWithStock(boolean b) {
        List<NavigatorRenderer> renderers = this.navigatorPanel.getRenderers();
        for (NavigatorRenderer renderer : renderers) {
            if (!(renderer instanceof TourLayerRenderer)) continue;
            ((TourLayerRenderer)renderer).setWithStack(b);
            this.navigatorPanel.repaint();
            return;
        }
    }

    public DefaultMutableTreeNode getSelObjectFromLegendTree() {
        int selRow = this.tourLegendTree.getLeadSelectionRow();
        if (selRow < 1) {
            return null;
        }
        DefaultMutableTreeNode treeMode = (DefaultMutableTreeNode)this.tourLegendTree.getLastSelectedPathComponent();
        return treeMode;
    }

    public Object getSelObjectInList() {
        int selIndex = this.filterLegendList.getSelectedIndex();
        if (selIndex < 0) {
            return null;
        }
        return this.filterLegendListModel.getElementAt(selIndex);
    }

    public void fireDragAndDrop(Point locationOfLegendTree, boolean removed) {
        DefaultMutableTreeNode node;
        DefaultMutableTreeNode object;
        TreePath treePath = this.getCurrentTreePath(locationOfLegendTree);
        DefaultMutableTreeNode defaultMutableTreeNode = object = treePath == null ? null : (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (object != null) {
            StopModel stopAtRelease = null;
            if (object instanceof StopNode) {
                stopAtRelease = ((StopNode)object).getStopModel();
            } else if (object instanceof StopAttributeNode) {
                stopAtRelease = ((StopAttributeNode)object).getStopModel();
            } else {
                DefaultMutableTreeNode node2 = object;
                TreeNode parent = node2.getParent();
                if (parent == null) {
                    parent = node2.getFirstChild();
                }
                if (parent instanceof StopNode) {
                    stopAtRelease = ((StopNode)parent).getStopModel();
                }
            }
            if (stopAtRelease != null && this.selectedStopsForAdd.contains(stopAtRelease)) {
                return;
            }
        }
        if (this.selectedStopsForAdd == null || this.selectedStopsForAdd.isEmpty() || treePath == null) {
            return;
        }
        if (removed && ModelEnviroment.getUserInformation().hasAtLeastOneRole(UserRole.ADMIN, UserRole.DISPONENT_LOCAL_ACTIVE, UserRole.DISPONENT_SUPER)) {
            this.removeSelectedStopsFromTour();
        }
        if (object instanceof StopNode) {
            this.addSelectedStopsBetween(((StopNode)object).getStopModel(), ((StopNode)object).getOrder());
        } else if (object instanceof TourNode) {
            this.addSelectedStopsByEnd(((TourNode)object).getTourModel());
        } else if (object instanceof StopAttributeNode) {
            node = (StopAttributeNode)object;
            this.addSelectedStopsBetween(((StopAttributeNode)object).getStopModel(), ((StopNode)node.getParent()).getOrder());
        } else if (object instanceof TourAttributeNode) {
            this.addSelectedStopsByEnd(((TourAttributeNode)object).getTourModel());
        } else {
            node = object;
            TreeNode parent = node.getParent();
            if (parent == null) {
                parent = node.getFirstChild();
            }
            if (parent instanceof StopNode) {
                this.addSelectedStopsBetween(((StopNode)parent).getStopModel(), ((StopNode)parent).getOrder());
            } else if (parent instanceof TourNode) {
                this.addSelectedStopsByEnd(((TourNode)parent).getTourModel());
            }
        }
        this.clearSelectedStopsForAdd();
        this.clearSelectedStopsForRemove();
        this.tourLegendTree.setCursor(Cursor.getDefaultCursor());
        this.tourLegendTree.repaint(10L);
        this.getNavigatorPanel().setCursor(Cursor.getDefaultCursor());
        this.getNavigatorPanel().repaint(10L);
    }

    private TreePath getCurrentTreePath(Point point) {
        Component selectedComponent = this.legendTabbedPane.getSelectedComponent();
        if (!selectedComponent.equals(this.tourLegendPane.getParent())) {
            return null;
        }
        Point location = this.tourLegendTree.getLocationOnScreen();
        TreePath treePath = this.tourLegendTree.getPathForLocation(point.x - location.x, point.y - location.y);
        return treePath;
    }

    private void addSelectedStopsByEnd(TourModel tour) {
        TourPartModel tourPart = tour.getTourPartAt(0);
        StopModel lastStop = null;
        if (tourPart.countStops() != 0) {
            lastStop = tourPart.getStopAt(tourPart.countStops() - 1);
        }
        if (lastStop == null || lastStop.getPoi() == null) {
            this.addSelectedStopsAtTourPart(tourPart, null);
        } else {
            this.addSelectedStopsAtTourPart(tourPart, tourPart.countStops() - 1);
        }
        this.repaintGui(true);
    }

    private void addSelectedStopsBetween(StopModel stop0, int sortOrder) {
        TourPartModel tourPart = stop0.getTourPart();
        if (stop0.getPoi() != null) {
            if (tourPart.getStopAt(0).equals(stop0)) {
                this.addSelectedStopsAtTourPart(tourPart, stop0.getSortOrder() + 1);
            } else {
                this.addSelectedStopsAtTourPart(tourPart, stop0.getSortOrder());
            }
        } else {
            this.addSelectedStopsAtTourPart(tourPart, sortOrder - 1);
        }
        this.repaintGui(true);
    }

    private void addSelectedStopsAtTourPart(TourPartModel tourPart, Integer sortOrder) {
        UndoManager undoManager = this.tourManagerCalendarGui.getActions().getUndoManager();
        for (StopModel stop : this.selectedStopsForAdd) {
            undoManager.startTransaction();
            if (sortOrder == null) {
                if (tourPart.isStopsEmpty()) {
                    tourPart.addStop(stop);
                } else {
                    StopModel lastStop = tourPart.getStopAt(tourPart.countStops() - 1);
                    if (lastStop.getPoi() == null) {
                        tourPart.addStop(stop);
                    } else {
                        tourPart.insertStop(stop, tourPart.countStops() - 1);
                    }
                }
            } else {
                tourPart.insertStop(stop, sortOrder);
            }
            stop.setStreetMileageMetersFromTourStart(null);
            stop.setEstimatedTimeOfArrival(null);
            stop.setStopStatus(null);
            undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.addStop", new Serializable[]{FormUtil.getStringDisplay(stop.getName()), tourPart.getTour().getName()}));
        }
        this.reloadUnsortedStopLayerRenderer();
        this.reloadStopFilter(this.selectedStopsForAdd);
    }

    public void updateAddStopsCursor(Point location) {
        TreePath treePath = this.getCurrentTreePath(location);
        if (treePath != null) {
            this.tourLegendTree.setCursor(DragSource.DefaultMoveDrop);
            this.navigatorPanel.setCursor(DragSource.DefaultMoveDrop);
        } else {
            this.tourLegendTree.setCursor(DragSource.DefaultMoveNoDrop);
            this.navigatorPanel.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public void updateMoveModelsInFilterListCursor(Point location) {
        Point point = this.filterLegendList.getLocationOnScreen();
        int width = this.filterLegendList.getWidth();
        int height = this.filterLegendList.getHeight();
        if (point.x < location.x && point.x + width > location.x && point.y < location.y && point.y + height > location.y) {
            this.filterLegendList.setCursor(DragSource.DefaultMoveDrop);
        } else {
            this.filterLegendList.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    public TourMapActions getTourMapActions() {
        return this.tourMapActions;
    }

    public void removeSelectedStopsFromTour() {
        if (this.selectedStopsForRemove == null || this.selectedStopsForRemove.isEmpty()) {
            return;
        }
        UndoManager undoManager = this.tourManagerCalendarGui.getActions().getUndoManager();
        undoManager.startTransaction();
        ArrayList<String> names = new ArrayList<String>(this.selectedStopsForRemove.size());
        for (StopModel selStop : this.selectedStopsForRemove) {
            selStop.setTourPart(null);
            selStop.setEstimatedTimeOfArrival(null);
            selStop.setStreetMileageMetersFromTourStart(null);
            selStop.setStopStatus(null);
            this.unsortedStops.add(selStop);
            names.add(selStop.getName());
        }
        undoManager.finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("gui.route.message.removeStop", new Serializable[]{StringUtil.implode(names, ", ")}));
        this.reloadUnsortedStopLayerRenderer();
        this.repaintGui(true);
        this.clearSelectedStopsForRemove();
    }

    public void updateSelectedStopsForRemove(Set<StopModel> stops) {
        if (this.selectedStopsForRemove == null) {
            this.selectedStopsForRemove = new HashSet<StopModel>();
        }
        if (this.selectedStopsForRemove.containsAll(stops)) {
            this.selectedStopsForRemove.removeAll(stops);
        } else {
            this.selectedStopsForRemove.addAll(stops);
        }
    }

    public void clearSelectedStopsForRemove() {
        if (this.selectedStopsForRemove == null) {
            this.selectedStopsForRemove = new HashSet<StopModel>();
        } else {
            this.selectedStopsForRemove.clear();
        }
    }

    public void updateSelectedStopsForAdd(Set<StopModel> stops) {
        if (this.selectedStopsForAdd == null) {
            this.selectedStopsForAdd = new HashSet<StopModel>();
        }
        if (this.selectedStopsForAdd.containsAll(stops)) {
            this.selectedStopsForAdd.removeAll(stops);
        } else {
            this.selectedStopsForAdd.addAll(stops);
        }
    }

    public void clearSelectedStopsForAdd() {
        if (this.selectedStopsForAdd == null) {
            this.selectedStopsForAdd = new HashSet<StopModel>();
        } else {
            this.selectedStopsForAdd.clear();
        }
    }

    public Set<StopModel> getSelectedStopsForRemove() {
        if (this.selectedStopsForRemove == null) {
            this.selectedStopsForRemove = new HashSet<StopModel>();
        }
        return this.selectedStopsForRemove;
    }

    public Set<StopModel> getSelectedStopsForAdd() {
        if (this.selectedStopsForAdd == null) {
            this.selectedStopsForAdd = new HashSet<StopModel>();
        }
        return this.selectedStopsForAdd;
    }

    public void setGeoTrackingRenderer(boolean active) {
        this.geoTrackingRenderer.setActive(active);
        if (active) {
            this.tourManagerCalendarGui.loadGeoTracks();
            this.getTourManagerCalendarGui().getTabbedPane().setSelectedComponent(this);
            this.legendTabbedPane.setSelectedComponent(this.geoTrackingLegendPane.getParent());
            this.areaRectangles = this.geoTrackingLegendPane.getAreaRectangles();
            this.center();
            String cron = "0 0/%% 7-22 ? * *".replaceAll("%%", String.valueOf(this.getGeoTrackingLegendPane().getUpdateInterval()));
            TourManagerJobManager.modifyJobTime("geo tracking", cron);
            TourManagerJobManager.resumeJob("geo tracking");
        } else {
            Set<TourModel> trackingTours = this.geoTrackingLegendPane.getTrackingMap().keySet();
            for (TourModel tour : trackingTours) {
                if (this.selectedTours.contains(tour)) continue;
                this.toursWithColor.remove(tour);
            }
            TourManagerJobManager.pause("geo tracking");
        }
        this.repaint(10L);
    }

    @Override
    public Component getPane() {
        return this.tourManagerCalendarGui.getTabbedPane();
    }

    public JList getFilterLegendList() {
        return this.filterLegendList;
    }

    @Override
    public FilterEntity getCurrentFilter() {
        return this.filter;
    }

    public TourManagerCalendarGui getTourManagerCalendarGui() {
        return this.tourManagerCalendarGui;
    }

    public GeoTrackingRenderer getGeoTrackingRenderer() {
        return this.geoTrackingRenderer;
    }

    public UnsortedStopLayerRenderer getUnsortedStopLayerRenderer() {
        return this.unsortedStopLayerRenderer;
    }

    public StopFilterLayerRenderer getStopFilterLayerRenderer() {
        return this.stopFilterLayerRenderer;
    }

    public TourLayerRenderer getTourLayerRenderer() {
        return this.tourLayerRenderer;
    }

    public LinkedHashMap<TourModel, Color> getToursWithColor() {
        if (this.toursWithColor == null) {
            this.toursWithColor = new LinkedHashMap();
        }
        return this.toursWithColor;
    }

    private static GeomExtractor<AreaObjectModel, ImmutablePolygonKind> createAreaGeomExtractor() {
        return new GeomExtractor<AreaObjectModel, ImmutablePolygonKind>(){

            @Override
            public ImmutablePolygonKind getGeom(AreaObjectModel areaObject) {
                return areaObject.getGeom();
            }
        };
    }

    public AreaLayerModel getPostcodeAreaLayer() {
        return this.postcodeAreaLayer;
    }

    public void setPostcodeAreaLayer(AreaLayerModel postcodeAreaLayer) {
        this.postcodeAreaLayer = postcodeAreaLayer;
    }

    public AreaLayerRenderer getPostcodeLayerRenderer() {
        return this.postcodeLayerRenderer;
    }

    public AreaObjectModel getFilterAreaObject() {
        AreaObjectModel area = null;
        if (this.filter != null && !this.filter.getSelectedAreaObjects().isEmpty()) {
            area = this.filter.getSelectedAreaObjects().iterator().next();
        }
        return area;
    }

    public JTree getTourLegendTree() {
        return this.tourLegendTree;
    }

    public GeoTrackingLegendPane getGeoTrackingLegendPane() {
        return this.geoTrackingLegendPane;
    }

    public TourTrackingRenderer getTourTrackingRenderer() {
        return this.tourTrackingRenderer;
    }
}

