/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.map;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.mobile.GeoTrackingModel;
import de.datomino.peppergis.client.util.ClientFormUtil;
import de.datomino.peppergis.tourmanager.gui.map.legend.GeoTrackingAttributeNode;
import de.datomino.peppergis.tourmanager.gui.map.legend.GeoTrackingNode;
import de.datomino.peppergis.tourmanager.gui.map.legend.TourNode;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.peppergis.util.GeoUtil;
import de.datomino.util.geo.ImmutablePoint;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import org.ktde.math.projection.Wgs84Factory;

public class GeoTrackingLegendTreeRenderer
implements TreeCellRenderer {
    DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.renderer.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (value != null) {
            if (value instanceof TourNode) {
                TourNode tourNode = (TourNode)value;
                this.renderer.setText(tourNode.getTourModel().getName());
                this.renderer.setForeground(tourNode.getColor());
            } else if (value instanceof GeoTrackingNode) {
                GeoTrackingNode node = (GeoTrackingNode)value;
                GeoTrackingModel tracking = node.getGeoTrackingModel();
                String text = ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.arrivalTime", new Serializable[0]) + ": ";
                text = text + ClientFormUtil.dateToString(tracking.getTime()) + " - (";
                ImmutablePoint geoLocation = tracking.getGeoLocation();
                if (geoLocation == null || GeoUtil.isNullPoint(geoLocation)) {
                    this.renderer.setForeground(Color.RED);
                    text = text + "0, 0";
                } else {
                    this.renderer.setForeground(node.getColor());
                    ImmutablePoint transformed = (ImmutablePoint)geoLocation.getTransformed(Wgs84Factory.INSTANCE);
                    text = text + FormUtil.roundWithDecimal(transformed.getX(), 5) + ", " + FormUtil.roundWithDecimal(transformed.getY(), 5);
                }
                text = text + ") - " + (Object)((Object)tracking.getType());
                this.renderer.setText(text);
            } else if (value instanceof GeoTrackingAttributeNode) {
                GeoTrackingAttributeNode attributeNode = (GeoTrackingAttributeNode)value;
                switch (attributeNode.getAttribute()) {
                    case DURATION: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.duration", new Serializable[]{attributeNode.getAttributeString()}));
                        break;
                    }
                    case DISTANCE: {
                        this.renderer.setText(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.length", new Serializable[]{attributeNode.getAttributeString()}));
                        break;
                    }
                }
                this.renderer.setForeground(attributeNode.getColor());
            } else {
                Object object = ((DefaultMutableTreeNode)value).getUserObject();
                this.renderer.setText(object.toString());
                this.renderer.setForeground(Color.BLACK);
            }
        }
        return this.renderer;
    }
}

