/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.filter;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.manager.legend.LegendType;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.tourmanager.gui.filter.FilterServiceRenderer;
import de.datomino.peppergis.tourmanager.gui.main.TourManagerCalendarGui;
import de.datomino.peppergis.tourmanager.handler.action.filter.UnsortedStopFilterSettingActions;
import de.datomino.peppergis.tourmanager.listener.filter.FilterDateSpinnerListener;
import de.datomino.peppergis.tourmanager.listener.filter.FilterServiceComboBoxListener;
import de.datomino.peppergis.tourmanager.listener.filter.UnsortedStopFilterSettingListener;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.HeightUnifier;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

@Deprecated
public class UnsortedStopFilterSettingDialog
extends JDialog {
    private static final long serialVersionUID = -5406811107875423930L;
    private StopFilterEntity filterEntity;
    private UnsortedStopFilterSettingActions filterSettingActions;
    private JTextField nameField;
    private TourManagerCalendarGui parent;
    private TourCaller tourCaller;

    public UnsortedStopFilterSettingDialog(JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
    }

    public UnsortedStopFilterSettingDialog(TourManagerCalendarGui parent, StopFilterEntity filterEntity) {
        this((JFrame)null, ModelEnviroment.getMessageResolver().resolveMessage("gui.filter.filter", new Serializable[0]) + "-" + ModelEnviroment.getMessageResolver().resolveMessage("gui.common.setting", new Serializable[0]), true);
        this.parent = parent;
        this.tourCaller = parent.getActions().getTourCaller();
        this.filterEntity = filterEntity;
        this.initialize();
    }

    private void initialize() {
        try {
            this.setIconImage(ImageIO.read(UnsortedStopFilterSettingDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.createInputPanel();
        this.createButtonPanel();
        Point locationOfParent = this.parent.getLocationOnScreen();
        this.setLocation(locationOfParent.x + 30, locationOfParent.y + 20);
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setDefaultCloseOperation(0);
        this.setPreferredSize(new Dimension(600, 330));
    }

    private void createInputPanel() {
        JPanel inputPanel = new JPanel(new SpringLayout());
        HeightUnifier heightUnifier = new HeightUnifier();
        JLabel nameLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0]));
        inputPanel.add(nameLabel);
        this.nameField = new JTextField("");
        inputPanel.add(this.nameField);
        heightUnifier.add(this.nameField);
        JLabel timeWindowLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.timewindow", new Serializable[0]));
        inputPanel.add(timeWindowLabel);
        JPanel timePanel = new JPanel(new SpringLayout());
        WidthUnifier widthUnifier = new WidthUnifier();
        JSpinner startTimeSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor startTimeEditor = new JSpinner.DateEditor(startTimeSpinner, FormUtil.DATEFORMAT);
        startTimeSpinner.setFont(UIManager.getDefaults().getFont("TextField.font"));
        startTimeSpinner.setEditor(startTimeEditor);
        timePanel.add(startTimeSpinner);
        widthUnifier.add(startTimeSpinner);
        JLabel timeToLabel = ClientSwingUtil.createLabelWithTextFieldFont(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0]) + " ", 0);
        timePanel.add(timeToLabel);
        JSpinner endTimeSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor endTimeEditor = new JSpinner.DateEditor(endTimeSpinner, FormUtil.DATEFORMAT);
        endTimeSpinner.setFont(UIManager.getDefaults().getFont("TextField.font"));
        endTimeSpinner.setEditor(endTimeEditor);
        timePanel.add(endTimeSpinner);
        widthUnifier.add(endTimeSpinner);
        SpringUtilities.makeCompactGrid(timePanel, 1, 3, 0, 0, 2, 2);
        inputPanel.add(timePanel);
        heightUnifier.add(timePanel);
        JPanel postcodePanel = new JPanel(new SpringLayout());
        JLabel startPostcodeLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessages(CollectionUtil.buildArrayList("address.postcode", "messages.default.from"), new String[0]));
        inputPanel.add(startPostcodeLabel);
        JTextField startPostcode = new JTextField(6);
        postcodePanel.add(startPostcode);
        widthUnifier.add(startPostcode);
        JLabel postcodeToLabel = ClientSwingUtil.createLabelWithTextFieldFont(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0]) + " ", 0);
        postcodePanel.add(postcodeToLabel);
        JTextField endPostcode = new JTextField(6);
        postcodePanel.add(endPostcode);
        widthUnifier.add(endPostcode);
        widthUnifier.unifyWidth();
        SpringUtilities.makeCompactGrid(postcodePanel, 1, 3, 0, 0, 2, 2);
        inputPanel.add(postcodePanel);
        heightUnifier.add(postcodePanel);
        JLabel serviceLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.service", new Serializable[0]) + ":");
        inputPanel.add(serviceLabel);
        DefaultComboBoxModel serviceComboBoxModel = this.createServiceComboBoxModel();
        JComboBox serviceComboBox = new JComboBox(serviceComboBoxModel);
        serviceComboBox.setBounds(105, 95, 480, 25);
        serviceComboBox.setFont(UIManager.getDefaults().getFont("TextField.font"));
        serviceComboBox.setRenderer(new FilterServiceRenderer());
        inputPanel.add(serviceComboBox);
        heightUnifier.add(serviceComboBox);
        heightUnifier.unifyHeight();
        SpringUtilities.makeCompactGrid(inputPanel, 4, 2, 5, 5, 5, 5);
        this.getContentPane().add((Component)inputPanel, "North");
        ((JSpinner.DefaultEditor)startTimeSpinner.getEditor()).getTextField().setText("");
        ((JSpinner.DefaultEditor)endTimeSpinner.getEditor()).getTextField().setText("");
        serviceComboBox.setSelectedIndex(-1);
        if (this.filterEntity != null) {
            if (this.filterEntity.getStartTime() != null) {
                startTimeSpinner.setValue(this.filterEntity.getStartTime());
            }
            if (this.filterEntity.getEndTime() != null) {
                endTimeSpinner.setValue(this.filterEntity.getEndTime());
            }
            if (this.filterEntity.getStartPostcode() != null) {
                startPostcode.setText(this.filterEntity.getStartPostcode());
            }
            if (this.filterEntity.getEndPostcode() != null) {
                endPostcode.setText(this.filterEntity.getEndPostcode());
            }
            if (!this.filterEntity.getServices().isEmpty()) {
                serviceComboBox.setSelectedItem(this.filterEntity.getServices().iterator().next());
            }
        } else {
            String name = ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.unsortedStops.filter", new Serializable[0]) + "-";
            this.filterEntity = new StopFilterEntity(name, LegendType.UNSORTEDSTOP);
            serviceComboBox.setSelectedIndex(-1);
        }
        this.nameField.setText(this.filterEntity.getKey());
        this.filterSettingActions = new UnsortedStopFilterSettingActions(this, this.filterEntity);
        this.addListeners(startTimeSpinner, endTimeSpinner, startPostcode, endPostcode, serviceComboBox);
    }

    private void addListeners(JSpinner startTimeSpinner, JSpinner endTimeSpinner, final JTextField startPostcode, final JTextField endPostcode, JComboBox serviceComboBox) {
        startPostcode.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                UnsortedStopFilterSettingDialog.this.filterEntity.setStartPostcode(startPostcode.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UnsortedStopFilterSettingDialog.this.filterEntity.setStartPostcode(startPostcode.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                UnsortedStopFilterSettingDialog.this.filterEntity.setStartPostcode(startPostcode.getText());
            }
        });
        endPostcode.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                UnsortedStopFilterSettingDialog.this.filterEntity.setEndPostcode(endPostcode.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UnsortedStopFilterSettingDialog.this.filterEntity.setEndPostcode(endPostcode.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                UnsortedStopFilterSettingDialog.this.filterEntity.setEndPostcode(endPostcode.getText());
            }
        });
        FilterServiceComboBoxListener filterServiceComboBoxListener = new FilterServiceComboBoxListener(this.filterEntity, false);
        serviceComboBox.addItemListener(filterServiceComboBoxListener);
        this.addListenersForSpinner(startTimeSpinner, StopFilterEntity.START);
        this.addListenersForSpinner(endTimeSpinner, StopFilterEntity.END);
    }

    private void addListenersForSpinner(JSpinner dateSpinner, Integer type) {
        JFormattedTextField timeField = ((JSpinner.DefaultEditor)dateSpinner.getEditor()).getTextField();
        timeField.setHorizontalAlignment(2);
        timeField.setEditable(false);
        FilterDateSpinnerListener filterDateSpinnerListener = new FilterDateSpinnerListener(timeField, this.filterEntity, type);
        timeField.addFocusListener(filterDateSpinnerListener);
        dateSpinner.setFocusable(false);
        dateSpinner.addChangeListener(filterDateSpinnerListener);
    }

    private void createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JButton applyFilterButton = new JButton(this.filterSettingActions.getApplyFilterActions());
        buttonPanel.add(applyFilterButton);
        JButton storeFilterButton = new JButton(this.filterSettingActions.getStoreFilterAction());
        buttonPanel.add(storeFilterButton);
        JButton deleteFilterButton = new JButton(this.filterSettingActions.getDeleteFilterAction());
        buttonPanel.add(deleteFilterButton);
        this.getContentPane().add((Component)buttonPanel, "South");
    }

    private DefaultComboBoxModel createServiceComboBoxModel() {
        List<ServiceModel> serviceList = this.tourCaller.fetchAllServices();
        serviceList.add(0, null);
        ServiceModel[] allServices = new ServiceModel[serviceList.size()];
        return new DefaultComboBoxModel<ServiceModel>(serviceList.toArray(allServices));
    }

    public static void createAndShowDialog(TourManagerCalendarGui parent, StopFilterEntity filterEntity) {
        UnsortedStopFilterSettingDialog filterSettingDialog = new UnsortedStopFilterSettingDialog(parent, filterEntity);
        UnsortedStopFilterSettingListener filterSettingListener = new UnsortedStopFilterSettingListener(filterSettingDialog);
        filterSettingDialog.addWindowListener(filterSettingListener);
        filterSettingDialog.pack();
        filterSettingDialog.setVisible(true);
    }

    public TourManagerCalendarGui getTourManagerCalendarGui() {
        return this.parent;
    }

    public UnsortedStopFilterSettingActions getFilterSettingActions() {
        return this.filterSettingActions;
    }

    public JTextField getNameField() {
        return this.nameField;
    }
}

