/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.filter;

import de.datomino.peppergis.client.manager.ManagerPointRenderer;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.client.util.StopModelUtil;
import de.datomino.peppergis.tourmanager.gui.map.TourMapGui;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.util.GeoUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.swing.navigator.OnTopRendering;
import org.ktde.swing.navigator.listener.NavigatorRendererActivateEvent;
import org.ktde.swing.navigator.listener.NavigatorRendererActiveListener;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class StopFilterLayerRenderer
implements NavigatorRenderer {
    private NavigatorPanel navigatorPanel;
    private Set<Tripel<String, ImmutablePoint, StopModel>> currentPoints;
    private Map<StopModel, Rectangle2D.Double> drawedStopsOnMap = new HashMap<StopModel, Rectangle2D.Double>();
    private Tupel<StopModel, Point2D.Double> mouseMoved;
    private Set<Coordinate> areaRectangles;
    private boolean isWithStack = true;
    private boolean active;
    private List<NavigatorRendererActiveListener> navigatorPanelActiveListeners = new ArrayList<NavigatorRendererActiveListener>();
    private int sortOrder = Integer.MAX_VALUE;
    private TourMapGui tourMapGui;

    public StopFilterLayerRenderer(boolean active, TourMapGui tourMapGui) {
        this.currentPoints = new HashSet<Tripel<String, ImmutablePoint, StopModel>>();
        this.areaRectangles = new HashSet<Coordinate>();
        this.tourMapGui = tourMapGui;
        this.active = active;
    }

    @Override
    public Collection<OnTopRendering> paintOnto(Graphics2D g2d, Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        double margin = 35.0 * Math.pow(upp, -0.2) * upp;
        ManagerPointRenderer pointRenderer = new ManagerPointRenderer(g2d, upp, this.navigatorPanel.getCoordinateFactory(), null){

            @Override
            protected boolean isSelected(Object o) {
                if (StopFilterLayerRenderer.this.tourMapGui.getSelectedStopsForAdd().contains(o)) {
                    return true;
                }
                return StopFilterLayerRenderer.this.tourMapGui.getSelectedStopsForRemove().contains(o);
            }
        };
        this.drawedStopsOnMap.clear();
        HashSet<Tripel<String, ImmutablePoint, StopModel>> drawedPoints = new HashSet<Tripel<String, ImmutablePoint, StopModel>>();
        for (Tripel<String, ImmutablePoint, StopModel> point : this.currentPoints) {
            if (drawedPoints.contains(point)) continue;
            Set<Tripel<String, ImmutablePoint, StopModel>> overlappedPoints = this.getOverlappedPoint(point, drawedPoints, margin);
            this.drawPoints(margin, pointRenderer, overlappedPoints);
            drawedPoints.addAll(overlappedPoints);
        }
        if (this.mouseMoved != null && this.mouseMoved.getElement1() != null) {
            String text = StopModelUtil.getDisplayString(this.mouseMoved.getElement1());
            Coordinate c = this.navigatorPanel.getCoordinateFactory().createCoordinate(this.mouseMoved.getElement2());
            pointRenderer.drawInfoBox(CollectionUtil.buildArrayList(text), c, Color.BLACK, 11.0 * upp);
        }
        return Collections.emptyList();
    }

    private void drawPoints(double margin, ManagerPointRenderer pointRenderer, Set<Tripel<String, ImmutablePoint, StopModel>> overlappedPoints) {
        HashMap<Tripel<String, Color, StopModel>, ImmutablePoint> pointsForDraw = new HashMap<Tripel<String, Color, StopModel>, ImmutablePoint>();
        for (Tripel<String, ImmutablePoint, StopModel> point : overlappedPoints) {
            pointsForDraw.put(new Tripel<String, Color, StopModel>(point.getElement1(), Color.BLACK, point.getElement3()), point.getElement2());
        }
        Map<StopModel, Rectangle2D.Double> drawStops = this.isWithStack ? pointRenderer.drawStopsWithStack(pointsForDraw, margin, null, false, false) : pointRenderer.drawStopsWithOutStack(pointsForDraw, margin, null, false, false);
        this.drawedStopsOnMap.putAll(drawStops);
    }

    private Set<Tripel<String, ImmutablePoint, StopModel>> getOverlappedPoint(Tripel<String, ImmutablePoint, StopModel> point0, Set<Tripel<String, ImmutablePoint, StopModel>> drawedPoints, double margin) {
        HashSet<Tripel<String, ImmutablePoint, StopModel>> overlappedPoints = new HashSet<Tripel<String, ImmutablePoint, StopModel>>();
        overlappedPoints.add(point0);
        for (Tripel<String, ImmutablePoint, StopModel> point : this.currentPoints) {
            if (drawedPoints.contains(point) || !ManagerPointRenderer.isOverlapped(margin, point.getElement2(), point0.getElement2())) continue;
            overlappedPoints.add(point);
        }
        return overlappedPoints;
    }

    public void setCurrentStops(List<StopModel> stops) {
        HashSet<Tripel<Integer, StopModel, Color>> stopTripels = new HashSet<Tripel<Integer, StopModel, Color>>(stops.size());
        int index = 1;
        for (StopModel stop : stops) {
            stopTripels.add(new Tripel<Integer, StopModel, Color>(index, stop, Color.BLACK));
            ++index;
        }
        this.setCurrentStops(stopTripels);
    }

    public void setCurrentStops(Collection<Tripel<Integer, StopModel, Color>> stopTripels) {
        this.areaRectangles = new HashSet<Coordinate>();
        this.currentPoints.clear();
        HashSet<ImmutablePoint> pointSet = new HashSet<ImmutablePoint>(this.currentPoints.size());
        for (Tripel<Integer, StopModel, Color> stopTripel : stopTripels) {
            ImmutablePoint point;
            if (stopTripel == null || stopTripel.getElement2() == null || (point = LocationModelUtil.getGeom(stopTripel.getElement2().getLocation())) == null) continue;
            ImmutablePoint transformedPoint = (ImmutablePoint)point.getTransformed(this.navigatorPanel.getCoordinateFactory());
            this.currentPoints.add(new Tripel<String, ImmutablePoint, StopModel>(String.valueOf(stopTripel.getElement1()), transformedPoint, stopTripel.getElement2()));
            pointSet.add(transformedPoint);
        }
        this.areaRectangles.addAll(GeoUtils.getAreaRectangle(pointSet));
    }

    public Set<Tripel<String, ImmutablePoint, StopModel>> getCurrentPoints() {
        if (this.currentPoints == null) {
            this.currentPoints = new HashSet<Tripel<String, ImmutablePoint, StopModel>>();
        }
        return this.currentPoints;
    }

    public Set<Coordinate> getAreaRectangles() {
        if (this.areaRectangles == null) {
            this.areaRectangles = new HashSet<Coordinate>();
        }
        return this.areaRectangles;
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setNavigatorPanel(NavigatorPanel navigatorPanel) {
        this.navigatorPanel = navigatorPanel;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setActive(boolean active) {
        if (this.active != active) {
            this.active = active;
            this.navigatorPanel.repaint(10L);
            this.fireActiveChanged();
        }
    }

    public void changeIsWithStock() {
        this.isWithStack = !this.isWithStack;
    }

    @Override
    public String getName() {
        return "StopFilterLayerRenderer";
    }

    @Override
    public void addNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.add(navigatorPanelActiveListener);
    }

    @Override
    public void removeNavigatorPanelActiveListener(NavigatorRendererActiveListener navigatorPanelActiveListener) {
        this.navigatorPanelActiveListeners.remove(navigatorPanelActiveListener);
    }

    protected void fireActiveChanged() {
        NavigatorRendererActivateEvent navigatorPanelActivateEvent = new NavigatorRendererActivateEvent(this, this.isActive());
        for (NavigatorRendererActiveListener navigatorPanelActiveListener : this.navigatorPanelActiveListeners) {
            navigatorPanelActiveListener.valueChanged(navigatorPanelActivateEvent);
        }
    }

    @Override
    public void close() {
    }

    public Map<StopModel, Rectangle2D.Double> getDrawedPointsOnMap() {
        return this.drawedStopsOnMap;
    }

    public void setMouseMoved(Tupel<StopModel, Point2D.Double> mouseMoved) {
        this.mouseMoved = mouseMoved;
    }

    public void doMouseMoved(Point2D.Double real) {
        if (this.isActive()) {
            this.setMouseMoved(null);
            Set<StopModel> stops = this.getDrawedPointsOnMap().keySet();
            for (StopModel stop : stops) {
                Rectangle2D.Double rectangle = this.getDrawedPointsOnMap().get(stop);
                if (!rectangle.contains(real)) continue;
                this.setMouseMoved(new Tupel<StopModel, Point2D.Double>(stop, new Point2D.Double(rectangle.getCenterX(), rectangle.getCenterY())));
                break;
            }
        }
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(int sortOrder) {
        this.sortOrder = sortOrder;
    }
}

