/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui.filter;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.communication.tour.StopFilterEntity;
import de.datomino.peppergis.client.gui.AbstractAutoCompleteComboBox;
import de.datomino.peppergis.client.gui.common.AbstractModelComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.service.ServiceValueDescriptorComboxBox;
import de.datomino.peppergis.client.manager.legend.LegendType;
import de.datomino.peppergis.client.model.base.ServiceModel;
import de.datomino.peppergis.client.model.base.ServiceValueDescriptorModel;
import de.datomino.peppergis.client.model.base.StaticChoiceValueModel;
import de.datomino.peppergis.client.model.tour.DelivererModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.DelivererModelUtil;
import de.datomino.peppergis.tourmanager.listener.filter.FilterDelivererComboBoxListener;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SpinnerDateModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.swing.PanelGroupPlacer;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class SearchFilterSettingPane
extends JPanel {
    private static final long serialVersionUID = 3908926841251042738L;
    private TourCaller tourCaller;
    private StopFilterEntity filterEntity;
    private JTextField nameField;
    private JTextField tourField;
    private JCheckBox enableTime;
    private JCheckBox enableTimeWindow;
    private JSpinner startDateSpinner;
    private JSpinner endDateSpinner;
    private JSpinner startTimeWindowSpinner;
    private JSpinner endTimeWindowSpinner;
    private JList<ServiceModel> serviceList;
    private ServiceValueDescriptorComboxBox serviceDescriptorComboBox;
    private JList<StaticChoiceValueModel> serviceStatusList;
    private JList<StaticChoiceValueModel> serviceSubStatusList;
    private AbstractAutoCompleteComboBox<DelivererModel> delivererComboBox;
    private AbstractAutoCompleteComboBox<DelivererModel> delivererNameComboBox;
    private JPanel attributeValuePane;
    private CardLayout cardLayout;
    private JTextField stringField;
    private JFormattedTextField integerField;
    private JCheckBox booleanBox;
    private AbstractModelComboBox<StaticChoiceValueModel> staticChoiceComboBox;
    private final String DATEFORMAT = FormUtil.DATEFORMAT;
    private final String TIMEWINDOWFORMAT = FormUtil.TIMEFORMAT;

    public SearchFilterSettingPane(TourCaller tourCaller) {
        this.tourCaller = tourCaller;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.filterEntity = new StopFilterEntity("search stop", LegendType.STOP);
        this.initialize();
    }

    private void initialize() {
        this.filterEntity.setUnsorted(false);
        this.nameField = new JTextField();
        this.tourField = new JTextField();
        JPanel dateBorderPanel = new JPanel(new BorderLayout());
        JPanel datePanel = new JPanel(new FlowLayout());
        JPanel timeWindowBorderPanel = new JPanel(new BorderLayout());
        JPanel timeWindowPanel = new JPanel(new FlowLayout());
        JPanel descriptorPanel = new JPanel(null);
        GroupLayout descriptorLayout = new GroupLayout(descriptorPanel);
        descriptorPanel.setLayout(descriptorLayout);
        this.enableTime = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.specifyDate", new Serializable[0]));
        this.enableTimeWindow = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.specifyTimeWindow", new Serializable[0]));
        this.startDateSpinner = this.createDateField(this.DATEFORMAT);
        this.startTimeWindowSpinner = this.createDateField(this.TIMEWINDOWFORMAT);
        JLabel timeToLabel = ClientSwingUtil.createLabelWithTextFieldFont(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0]) + " ", 0);
        JLabel dateToLabel = ClientSwingUtil.createLabelWithTextFieldFont(" " + ModelEnviroment.getMessageResolver().resolveMessage("messages.default.to", new Serializable[0]) + " ", 0);
        this.endDateSpinner = this.createDateField(this.DATEFORMAT);
        this.endTimeWindowSpinner = this.createDateField(this.TIMEWINDOWFORMAT);
        datePanel.add(this.startDateSpinner);
        datePanel.add(dateToLabel);
        datePanel.add(this.endDateSpinner);
        dateBorderPanel.add((Component)this.enableTime, "West");
        dateBorderPanel.add((Component)datePanel, "East");
        timeWindowPanel.add(this.startTimeWindowSpinner);
        timeWindowPanel.add(timeToLabel);
        timeWindowPanel.add(this.endTimeWindowSpinner);
        timeWindowBorderPanel.add((Component)this.enableTimeWindow, "West");
        timeWindowBorderPanel.add((Component)timeWindowPanel, "East");
        this.startDateSpinner.setEnabled(false);
        this.startTimeWindowSpinner.setEnabled(false);
        this.endDateSpinner.setEnabled(false);
        this.endTimeWindowSpinner.setEnabled(false);
        this.serviceList = new JList(this.createServiceListModel());
        final ListCellRenderer<ServiceModel> cellRenderer = this.serviceList.getCellRenderer();
        this.serviceList.setCellRenderer(new ListCellRenderer<ServiceModel>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends ServiceModel> list, ServiceModel value, int index, boolean isSelected, boolean cellHasFocus) {
                return cellRenderer.getListCellRendererComponent(list, value.getName(), index, isSelected, cellHasFocus);
            }
        });
        this.serviceList.setVisibleRowCount(5);
        JScrollPane serviceListScrollPane = new JScrollPane(this.serviceList);
        this.cardLayout = new CardLayout();
        this.attributeValuePane = new JPanel(this.cardLayout);
        JPanel emptyPane = new JPanel();
        JPanel stringPane = new JPanel(new BorderLayout());
        JPanel integerPane = new JPanel(new BorderLayout());
        JPanel booleanPane = new JPanel(new BorderLayout());
        JPanel staticChoicePane = new JPanel(new BorderLayout());
        this.stringField = new JTextField();
        this.stringField.setColumns(9);
        this.integerField = new JFormattedTextField(new DecimalFormat("#"));
        this.integerField.setColumns(9);
        this.booleanBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.yes", new Serializable[0]));
        this.staticChoiceComboBox = new AbstractModelComboBox<StaticChoiceValueModel>(false){
            private static final long serialVersionUID = 6695047893329882540L;

            @Override
            protected String getStringRepresentation(StaticChoiceValueModel t) {
                return t.getName();
            }
        };
        stringPane.add((Component)this.stringField, "Center");
        integerPane.add((Component)this.integerField, "Center");
        booleanPane.add((Component)this.booleanBox, "Center");
        staticChoicePane.add(this.staticChoiceComboBox, "Center");
        this.attributeValuePane.add((Component)emptyPane, "");
        this.attributeValuePane.add((Component)stringPane, AttributeValueType.STRING.name());
        this.attributeValuePane.add((Component)integerPane, AttributeValueType.INTEGER.name());
        this.attributeValuePane.add((Component)booleanPane, AttributeValueType.BOOLEAN.name());
        this.attributeValuePane.add((Component)staticChoicePane, AttributeValueType.STATIC_CHOICE.name());
        this.serviceDescriptorComboBox = new ServiceValueDescriptorComboxBox((Collection<ServiceValueDescriptorModel>)Collections.emptyList(), true);
        this.serviceDescriptorComboBox.setEnabled(false);
        int prefSiz = -2;
        int defSiz = -1;
        descriptorLayout.setHorizontalGroup(descriptorLayout.createSequentialGroup().addComponent(this.serviceDescriptorComboBox, 0, 0, Integer.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.attributeValuePane, 0, -2, -2));
        descriptorLayout.setVerticalGroup(descriptorLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.serviceDescriptorComboBox, -2, -2, -2).addComponent(this.attributeValuePane, -2, -2, -2));
        this.serviceStatusList = new JList(new DefaultListModel());
        final ListCellRenderer<StaticChoiceValueModel> serviceStatusCellRenderer = this.serviceStatusList.getCellRenderer();
        this.serviceStatusList.setCellRenderer(new ListCellRenderer<StaticChoiceValueModel>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends StaticChoiceValueModel> list, StaticChoiceValueModel value, int index, boolean isSelected, boolean cellHasFocus) {
                return serviceStatusCellRenderer.getListCellRendererComponent(list, value.getValue() + " - " + value.getName(), index, isSelected, cellHasFocus);
            }
        });
        this.serviceStatusList.setEnabled(false);
        JScrollPane serviceStatusListScrollPane = new JScrollPane(this.serviceStatusList);
        serviceStatusListScrollPane.setPreferredSize(this.extendDimensionHeight(this.getPreferredSize(), 5.5));
        this.serviceSubStatusList = new JList(new DefaultListModel());
        final ListCellRenderer<StaticChoiceValueModel> serviceSubStatusCellRenderer = this.serviceSubStatusList.getCellRenderer();
        this.serviceSubStatusList.setCellRenderer(new ListCellRenderer<StaticChoiceValueModel>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends StaticChoiceValueModel> list, StaticChoiceValueModel value, int index, boolean isSelected, boolean cellHasFocus) {
                return serviceSubStatusCellRenderer.getListCellRendererComponent(list, value.getValue() + " - " + value.getName(), index, isSelected, cellHasFocus);
            }
        });
        this.serviceSubStatusList.setEnabled(false);
        JScrollPane serviceSubStatusListScrollPane = new JScrollPane(this.serviceSubStatusList);
        serviceSubStatusListScrollPane.setPreferredSize(this.extendDimensionHeight(this.getPreferredSize(), 5.5));
        this.delivererComboBox = this.createDelivererComboBox(false);
        this.delivererNameComboBox = this.createDelivererComboBox(true);
        JComponent[] components = new JComponent[]{this.nameField, this.tourField, dateBorderPanel, timeWindowBorderPanel, serviceListScrollPane, descriptorPanel, serviceStatusListScrollPane, serviceSubStatusListScrollPane, this.delivererComboBox, this.delivererNameComboBox};
        String stopName = ModelEnviroment.getMessageResolver().resolveMessage("gui.stop.stop", new Serializable[0]);
        String tour = ModelEnviroment.getMessageResolver().resolveMessage("de.datomino.peppergis.dto.importer.GeoTrackCsvImportDto.GeoTrackColumns.TOUR_NAME", new Serializable[0]);
        String date = ModelEnviroment.getMessageResolver().resolveMessage("de.datomino.peppergis.type.AttributeValueType.DATEDAY", new Serializable[0]);
        String timeWindow = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.timewindow", new Serializable[0]);
        String service = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.service", new Serializable[0]);
        String serviceDescriptor = ModelEnviroment.getMessageResolver().resolveMessage("gui.service.descriptor", new Serializable[0]);
        String serviceStatus = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.statusMain", new Serializable[0]);
        String serviceSubStatus = ModelEnviroment.getMessageResolver().resolveMessage("messages.default.statusSub", new Serializable[0]);
        String delivererNumber = ModelEnviroment.getMessageResolver().resolveMessage("messages.delivererNumber", new Serializable[0]);
        String delivererName = ModelEnviroment.getMessageResolver().resolveMessage("messages.importer.delivererName", new Serializable[0]);
        String[] labels = new String[]{stopName, tour, date, timeWindow, service, serviceDescriptor, serviceStatus, serviceSubStatus, delivererNumber, delivererName};
        PanelGroupPlacer.createGroup((Container)this, components, labels);
        this.addListeners();
    }

    private Dimension extendDimensionWidth(Dimension dim, double factor) {
        double width = dim.getWidth();
        double height = dim.getHeight();
        return new Dimension((int)(width * factor), (int)height);
    }

    private Dimension extendDimensionHeight(Dimension dim, double factor) {
        double width = dim.getWidth();
        double height = dim.getHeight();
        return new Dimension((int)width, (int)(height * factor));
    }

    private JSpinner createDateField(String format) {
        JSpinner dateTimeSpinner = new JSpinner(new SpinnerDateModel());
        JSpinner.DateEditor editor = new JSpinner.DateEditor(dateTimeSpinner, format);
        dateTimeSpinner.setFont(UIManager.getDefaults().getFont("TextField.font"));
        dateTimeSpinner.setEditor(editor);
        return dateTimeSpinner;
    }

    private DefaultComboBoxModel createServiceComboBoxModel() {
        List<ServiceModel> serviceList = this.tourCaller.fetchAllServices();
        serviceList.add(0, null);
        ServiceModel[] allServices = new ServiceModel[serviceList.size()];
        return new DefaultComboBoxModel<ServiceModel>(serviceList.toArray(allServices));
    }

    private ListModel createServiceListModel() {
        List<ServiceModel> serviceList = this.tourCaller.fetchAllServices();
        DefaultListModel<ServiceModel> listModel = new DefaultListModel<ServiceModel>();
        for (ServiceModel service : serviceList) {
            listModel.addElement(service);
        }
        return listModel;
    }

    private AbstractAutoCompleteComboBox<TourModel> createTourComboBox() {
        List<TourModel> tourNames = this.tourCaller.fetchAllTours();
        tourNames.add(0, null);
        return new AbstractAutoCompleteComboBox<TourModel>(tourNames){
            private static final long serialVersionUID = 1214841497872746080L;

            @Override
            public String toDisplayString(Object data) {
                if (data == null) {
                    return "";
                }
                if (data instanceof TourModel) {
                    return ((TourModel)data).getName();
                }
                return data.toString();
            }
        };
    }

    private AbstractAutoCompleteComboBox<DelivererModel> createDelivererComboBox(boolean name) {
        List<DelivererModel> deliverers = this.tourCaller.fetchAllDeliverers();
        deliverers.add(0, null);
        if (name) {
            return new AbstractAutoCompleteComboBox<DelivererModel>(deliverers){
                private static final long serialVersionUID = 1214841497872746080L;

                @Override
                public String toDisplayString(Object data) {
                    String output;
                    if (data == null) {
                        return "";
                    }
                    if (data instanceof DelivererModel) {
                        String name = ((DelivererModel)data).getName();
                        output = StringUtil.nullToEmpty(name);
                    } else {
                        output = data.toString();
                    }
                    return output.length() < 51 ? output : output.substring(0, 50) + "...";
                }
            };
        }
        return new AbstractAutoCompleteComboBox<DelivererModel>(deliverers){
            private static final long serialVersionUID = -6163012837451696618L;

            @Override
            public String toDisplayString(Object data) {
                if (data == null) {
                    return "";
                }
                String output = data instanceof DelivererModel ? DelivererModelUtil.getDisplayString((DelivererModel)data) : data.toString();
                return output.length() < 51 ? output : output.substring(0, 50) + "...";
            }
        };
    }

    private void addListeners() {
        this.nameField.getDocument().addDocumentListener(new textFieldDocumentListener(this.nameField, TextFieldEnumeration.STOP));
        this.tourField.getDocument().addDocumentListener(new textFieldDocumentListener(this.tourField, TextFieldEnumeration.TOUR));
        this.serviceList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList list = SearchFilterSettingPane.this.serviceList;
                if (SearchFilterSettingPane.this.filterEntity.setServices(list.isSelectionEmpty() ? null : list.getSelectedValuesList())) {
                    SearchFilterSettingPane.this.updateServiceUnderList();
                }
            }
        });
        this.serviceDescriptorComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item = e.getItem();
                if (e.getStateChange() == 1 && item != null && item instanceof ServiceValueDescriptorModel) {
                    AttributeValueType serviceValueType = ((ServiceValueDescriptorModel)item).getServiceValueType();
                    SearchFilterSettingPane.this.cardLayout.show(SearchFilterSettingPane.this.attributeValuePane, serviceValueType.name());
                    switch (serviceValueType) {
                        case STRING: {
                            SearchFilterSettingPane.this.filterEntity.setServiceValues(CollectionUtil.buildHashSet(new Tupel<ServiceValueDescriptorModel, String>((ServiceValueDescriptorModel)item, SearchFilterSettingPane.this.stringField.getText())));
                            break;
                        }
                        case INTEGER: {
                            Integer bIntValue = null;
                            try {
                                bIntValue = Integer.parseInt(SearchFilterSettingPane.this.integerField.getText());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            SearchFilterSettingPane.this.filterEntity.setServiceValues(CollectionUtil.buildHashSet(new Tupel<ServiceValueDescriptorModel, Integer>((ServiceValueDescriptorModel)item, bIntValue)));
                            break;
                        }
                        case BOOLEAN: {
                            SearchFilterSettingPane.this.filterEntity.setServiceValues(CollectionUtil.buildHashSet(new Tupel<ServiceValueDescriptorModel, Boolean>((ServiceValueDescriptorModel)item, SearchFilterSettingPane.this.booleanBox.isSelected())));
                            break;
                        }
                        case STATIC_CHOICE: {
                            SearchFilterSettingPane.this.filterEntity.setServiceValues(CollectionUtil.buildHashSet(new Tupel<ServiceValueDescriptorModel, Long>((ServiceValueDescriptorModel)item, ((StaticChoiceValueModel)SearchFilterSettingPane.this.staticChoiceComboBox.getSelectedItem()).getId())));
                            break;
                        }
                    }
                } else {
                    SearchFilterSettingPane.this.cardLayout.show(SearchFilterSettingPane.this.attributeValuePane, "");
                    SearchFilterSettingPane.this.filterEntity.setServiceValues(null);
                }
            }
        });
        this.stringField.getDocument().addDocumentListener(new textFieldDocumentListener(this.stringField, TextFieldEnumeration.STRING));
        this.integerField.getDocument().addDocumentListener(new textFieldDocumentListener(this.integerField, TextFieldEnumeration.INTEGER));
        this.booleanBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ServiceValueDescriptorModel serviceDescriptor = (ServiceValueDescriptorModel)SearchFilterSettingPane.this.serviceDescriptorComboBox.getSelectedItem();
                SearchFilterSettingPane.this.filterEntity.setServiceValues(CollectionUtil.buildHashSet(new Tupel<ServiceValueDescriptorModel, Boolean>(serviceDescriptor, SearchFilterSettingPane.this.booleanBox.isSelected())));
            }
        });
        this.staticChoiceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceValueDescriptorModel serviceDescriptor = (ServiceValueDescriptorModel)SearchFilterSettingPane.this.serviceDescriptorComboBox.getSelectedItem();
                if (SearchFilterSettingPane.this.staticChoiceComboBox.getSelectedItem() != null) {
                    SearchFilterSettingPane.this.filterEntity.setServiceValues(CollectionUtil.buildHashSet(new Tupel<ServiceValueDescriptorModel, Long>(serviceDescriptor, ((StaticChoiceValueModel)SearchFilterSettingPane.this.staticChoiceComboBox.getSelectedItem()).getId())));
                }
            }
        });
        this.serviceStatusList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList list = SearchFilterSettingPane.this.serviceStatusList;
                DefaultListModel model = (DefaultListModel)SearchFilterSettingPane.this.serviceStatusList.getModel();
                SearchFilterSettingPane.this.filterEntity.setServiceStatus(model.isEmpty() ? null : list.getSelectedValuesList());
            }
        });
        this.serviceSubStatusList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList list = SearchFilterSettingPane.this.serviceSubStatusList;
                DefaultListModel model = (DefaultListModel)SearchFilterSettingPane.this.serviceSubStatusList.getModel();
                SearchFilterSettingPane.this.filterEntity.setServiceSubStatus(model.isEmpty() ? null : list.getSelectedValuesList());
            }
        });
        this.delivererComboBox.addItemListener(new FilterDelivererComboBoxListener(this.filterEntity, false, this.delivererNameComboBox));
        this.delivererNameComboBox.addItemListener(new FilterDelivererComboBoxListener(this.filterEntity, false, this.delivererComboBox));
        this.addListenersForSpinner(this.startDateSpinner, this.endDateSpinner, TemporalFilterType.ETADATE);
        this.addListenersForSpinner(this.startTimeWindowSpinner, this.endTimeWindowSpinner, TemporalFilterType.TIMEWINDOW);
        this.enableTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isChecked = SearchFilterSettingPane.this.enableTime.isSelected();
                SearchFilterSettingPane.this.startDateSpinner.setEnabled(isChecked);
                SearchFilterSettingPane.this.endDateSpinner.setEnabled(isChecked);
                SearchFilterSettingPane.this.filterEntity.setEstimatedTimesOfArrival(isChecked ? CollectionUtil.buildHashSet(new Tupel<Date, Date>((Date)SearchFilterSettingPane.this.startDateSpinner.getValue(), (Date)SearchFilterSettingPane.this.endDateSpinner.getValue())) : null);
            }
        });
        this.enableTimeWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isChecked = SearchFilterSettingPane.this.enableTimeWindow.isSelected();
                SearchFilterSettingPane.this.startTimeWindowSpinner.setEnabled(isChecked);
                SearchFilterSettingPane.this.endTimeWindowSpinner.setEnabled(isChecked);
                SearchFilterSettingPane.this.filterEntity.setTimeWindows(isChecked ? CollectionUtil.buildHashSet(new Tupel<Date, Date>((Date)SearchFilterSettingPane.this.startTimeWindowSpinner.getValue(), (Date)SearchFilterSettingPane.this.endTimeWindowSpinner.getValue())) : null);
            }
        });
    }

    private void updateServiceUnderList() {
        Collection<ServiceModel> selectedServices = this.filterEntity.getServices();
        DefaultListModel statusListModel = (DefaultListModel)this.serviceStatusList.getModel();
        DefaultListModel subStatusListModel = (DefaultListModel)this.serviceSubStatusList.getModel();
        LinkedList<ServiceValueDescriptorModel> status = new LinkedList<ServiceValueDescriptorModel>();
        LinkedList<ServiceValueDescriptorModel> subStatus = new LinkedList<ServiceValueDescriptorModel>();
        statusListModel.clear();
        subStatusListModel.clear();
        if (selectedServices != null && !selectedServices.isEmpty()) {
            this.serviceDescriptorComboBox.removeAllItems();
            this.serviceDescriptorComboBox.addNullItem();
            for (ServiceModel selectedService : selectedServices) {
                for (ServiceValueDescriptorModel descriptor : selectedService.iterableServiceValueDescriptors()) {
                    if (descriptor.getKey().equals("STATUS")) {
                        status.add(descriptor);
                        continue;
                    }
                    if (descriptor.getKey().equals("SUB_STATUS")) {
                        subStatus.add(descriptor);
                        continue;
                    }
                    AttributeValueType dt = descriptor.getServiceValueType();
                    if (!dt.equals((Object)AttributeValueType.INTEGER) && !dt.equals((Object)AttributeValueType.BOOLEAN) && !dt.equals((Object)AttributeValueType.STRING) && !dt.equals((Object)AttributeValueType.STATIC_CHOICE)) continue;
                    this.serviceDescriptorComboBox.addItem(descriptor);
                    if (!dt.equals((Object)AttributeValueType.STATIC_CHOICE)) continue;
                    this.staticChoiceComboBox.setModels(descriptor.iterableStaticChoiceValues());
                }
            }
            for (ServiceValueDescriptorModel statusExemplar : status) {
                for (StaticChoiceValueModel element : statusExemplar.iterableStaticChoiceValues()) {
                    statusListModel.addElement(element);
                }
            }
            for (ServiceValueDescriptorModel subStatusExemplar : subStatus) {
                for (StaticChoiceValueModel element : subStatusExemplar.iterableStaticChoiceValues()) {
                    subStatusListModel.addElement(element);
                }
            }
            this.serviceDescriptorComboBox.setEnabled(true);
        } else {
            this.serviceDescriptorComboBox.setEnabled(false);
            this.cardLayout.show(this.attributeValuePane, "");
        }
        this.serviceStatusList.setEnabled(!statusListModel.isEmpty());
        this.serviceSubStatusList.setEnabled(!subStatusListModel.isEmpty());
    }

    private void addListenersForSpinner(JSpinner startSpinner, JSpinner endSpinner, TemporalFilterType type) {
        FilterTimeWindowSpinnerListener filterDateTimeSpinnerListener = new FilterTimeWindowSpinnerListener(startSpinner, endSpinner, this.filterEntity, type);
        ((JSpinner.DefaultEditor)startSpinner.getEditor()).getTextField().addFocusListener(filterDateTimeSpinnerListener);
        ((JSpinner.DefaultEditor)endSpinner.getEditor()).getTextField().addFocusListener(filterDateTimeSpinnerListener);
        startSpinner.addChangeListener(filterDateTimeSpinnerListener);
        endSpinner.addChangeListener(filterDateTimeSpinnerListener);
    }

    public StopFilterEntity getFilterEntity() {
        return this.filterEntity;
    }

    public void clear() {
        this.nameField.setText("");
        this.tourField.setText("");
        this.enableTime.setSelected(false);
        this.startDateSpinner.setEnabled(false);
        this.endDateSpinner.setEnabled(false);
        this.enableTimeWindow.setSelected(false);
        this.startTimeWindowSpinner.setEnabled(false);
        this.endTimeWindowSpinner.setEnabled(false);
        this.serviceList.clearSelection();
        this.serviceDescriptorComboBox.setSelectedItem(null);
        this.serviceDescriptorComboBox.setEnabled(false);
        this.stringField.setText("");
        this.integerField.setText("");
        this.booleanBox.setSelected(false);
        this.serviceStatusList.clearSelection();
        this.serviceStatusList.setEnabled(false);
        this.serviceSubStatusList.clearSelection();
        this.serviceSubStatusList.setEnabled(false);
        this.delivererComboBox.clear();
        this.delivererNameComboBox.clear();
        this.filterEntity.clear();
    }

    private class FilterTimeWindowSpinnerListener
    implements FocusListener,
    ChangeListener {
        private JSpinner startTimeSpinner;
        private JSpinner endTimeSpinner;
        private JFormattedTextField startTimeTextField;
        private JFormattedTextField endTimeTextField;
        private StopFilterEntity filterEntity;
        private TemporalFilterType type;

        public FilterTimeWindowSpinnerListener(JSpinner startTimeSpinner, JSpinner endTimeSpinner, StopFilterEntity filterEntity, TemporalFilterType type) {
            this.startTimeSpinner = startTimeSpinner;
            this.endTimeSpinner = endTimeSpinner;
            this.startTimeTextField = ((JSpinner.DefaultEditor)startTimeSpinner.getEditor()).getTextField();
            this.endTimeTextField = ((JSpinner.DefaultEditor)endTimeSpinner.getEditor()).getTextField();
            this.startTimeTextField.setHorizontalAlignment(2);
            this.endTimeTextField.setHorizontalAlignment(2);
            this.filterEntity = filterEntity;
            this.type = type;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSpinner spinner = (JSpinner)e.getSource();
            ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setValue(spinner.getValue());
            this.fireChangedDate();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.fireChangedDate();
        }

        private void fireChangedDate() {
            this.syncTextfieldWithSpinner(this.startTimeSpinner, this.startTimeTextField);
            this.syncTextfieldWithSpinner(this.endTimeSpinner, this.endTimeTextField);
            Date start = this.stringToDate(this.startTimeTextField.getText(), this.type == TemporalFilterType.TIMEWINDOW ? SearchFilterSettingPane.this.TIMEWINDOWFORMAT : SearchFilterSettingPane.this.DATEFORMAT);
            Date end = this.stringToDate(this.endTimeTextField.getText(), this.type == TemporalFilterType.TIMEWINDOW ? SearchFilterSettingPane.this.TIMEWINDOWFORMAT : SearchFilterSettingPane.this.DATEFORMAT);
            if (start != null && end != null && end.before(start)) {
                end = start;
                this.endTimeSpinner.setValue(start);
                this.endTimeTextField.setValue(this.endTimeSpinner.getValue());
            }
            if (this.type == TemporalFilterType.TIMEWINDOW) {
                this.filterEntity.setTimeWindow(new Tupel<Date, Date>(start, end));
            } else if (this.type == TemporalFilterType.ETADATE) {
                this.filterEntity.setETAStartEnd(new Tupel<Date, Date>(start, end));
            }
        }

        private void syncTextfieldWithSpinner(JSpinner spinner, JFormattedTextField textfield) {
            block2: {
                try {
                    spinner.commitEdit();
                }
                catch (ParseException e) {
                    if (textfield.getText().equals("")) break block2;
                    textfield.setValue(spinner.getValue());
                }
            }
        }

        private Date stringToDate(String string, String format) {
            try {
                return new SimpleDateFormat(format).parse(string);
            }
            catch (ParseException e) {
                return null;
            }
        }
    }

    static enum TemporalFilterType {
        ETADATE,
        TIMEWINDOW;

    }

    private class textFieldDocumentListener
    implements DocumentListener {
        final JTextField field;
        final TextFieldEnumeration type;

        public textFieldDocumentListener(JTextField field, TextFieldEnumeration type) {
            this.field = field;
            this.type = type;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.setValue();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.setValue();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.setValue();
        }

        private void setValue() {
            String text = this.field.getText();
            ServiceValueDescriptorModel serviceDescriptor = (ServiceValueDescriptorModel)SearchFilterSettingPane.this.serviceDescriptorComboBox.getSelectedItem();
            switch (this.type) {
                case INTEGER: {
                    Integer bIntValue = null;
                    try {
                        bIntValue = Integer.parseInt(text);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SearchFilterSettingPane.this.filterEntity.setServiceValues(CollectionUtil.buildHashSet(new Tupel<ServiceValueDescriptorModel, Integer>(serviceDescriptor, bIntValue)));
                    break;
                }
                case STOP: {
                    SearchFilterSettingPane.this.filterEntity.setNames(text.isEmpty() ? null : CollectionUtil.buildHashSet(text));
                    break;
                }
                case STRING: {
                    SearchFilterSettingPane.this.filterEntity.setServiceValues(CollectionUtil.buildHashSet(new Tupel<ServiceValueDescriptorModel, String>(serviceDescriptor, text)));
                    break;
                }
                case TOUR: {
                    SearchFilterSettingPane.this.filterEntity.setTourNames(text.isEmpty() ? null : CollectionUtil.buildHashSet(text));
                    break;
                }
            }
        }
    }

    private static enum TextFieldEnumeration {
        STOP,
        TOUR,
        STRING,
        INTEGER;

    }
}

