/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.tourmanager.gui;

import de.datomino.logistic.type.CalculateType;
import de.datomino.logistic.type.OptimizationType;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.tour.StopModel;
import de.datomino.peppergis.client.model.tour.TourModel;
import de.datomino.peppergis.client.util.ClientSwingUtil;
import de.datomino.peppergis.client.util.PoiModelUtil;
import de.datomino.peppergis.client.util.TourModelUtil;
import de.datomino.peppergis.tourmanager.gui.base.PoiModelListCellRenderer;
import de.datomino.peppergis.type.PoiType;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.collection.CollectionUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Holder;
import org.ktde.util.datatypes.Tripel;

public abstract class AbstractRoutingWithComboBoxDialog
extends JDialog {
    private static final long serialVersionUID = 8972719865399493546L;
    private static final String DIFFICULTY_LEVEL_ACTIVE_PROPERTY_KEY = "tour.optimize.difficultyLevelActive";
    private static final String SAVE_PROPERTY_KEY = "tour.optimize.save";
    private static final String START_TIME_PROPERTY_KEY = "tour.optimize.startTime";
    protected Collection<TourModel> tours;
    protected JComboBox startPointComboBox;
    protected JComboBox endPointComboBox;
    protected JComboBox poiComboBox;
    protected boolean poiSelectionActive;
    protected JSpinner sizeOfStartBlockSpinner;
    protected JSpinner sizeOfEndBlockSpinner;
    protected TourCaller tourCaller;
    protected boolean importOrder;
    protected RouteVehicleType routeVehicleType;
    protected RouteType routeType;
    protected boolean saveSelectionActive;
    protected JCheckBox saveSelectionCheckBox;
    protected JCheckBox difficultyLevelCheckBox;
    private Holder<Date> startTime;
    private ModelEnviroment modelEnviroment;
    protected Component parent;

    public AbstractRoutingWithComboBoxDialog(Collection<TourModel> tours, TourCaller tourCaller, RouteVehicleType routeVehicleType, RouteType routeType, boolean importOrder, boolean poiSelectionActive, Component parent, ModelEnviroment modelEnviroment) {
        this.tours = tours;
        this.tourCaller = tourCaller;
        this.routeVehicleType = routeVehicleType;
        this.routeType = routeType;
        this.importOrder = importOrder;
        this.poiSelectionActive = poiSelectionActive;
        this.parent = parent;
        this.modelEnviroment = modelEnviroment;
        this.initialise();
    }

    private void initialise() {
        try {
            this.setIconImage(ImageIO.read(AbstractRoutingWithComboBoxDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        String active = ModelEnviroment.getProperties().getProperty("tour.routing.saveSelection.acitve");
        if (active != null && active.equals("true")) {
            this.saveSelectionActive = true;
        }
        this.setTitle(ModelEnviroment.getMessageResolver().resolveMessage("gui.common.setting", new Serializable[0]));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createSettingPanel(), "Center");
        panel.add((Component)this.createButtonPanel(), "South");
        this.add(panel);
    }

    protected abstract JPanel createSettingPanel();

    protected abstract JPanel createButtonPanel();

    protected abstract void updateDialog();

    protected void addSaveSelection(JPanel panel) {
        String prop = ModelEnviroment.getProperties().getProperty(DIFFICULTY_LEVEL_ACTIVE_PROPERTY_KEY);
        boolean difficultyLevel = StringUtil.isTrue(prop);
        prop = ModelEnviroment.getProperties().getProperty(SAVE_PROPERTY_KEY);
        boolean saveSelection = StringUtil.isBlank(prop) || StringUtil.isTrue(prop);
        this.difficultyLevelCheckBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("area.attribute.descriptor.difficultyLevel", new Serializable[0]));
        this.difficultyLevelCheckBox.setSelected(difficultyLevel);
        panel.add(this.difficultyLevelCheckBox);
        if (this.saveSelectionActive) {
            this.saveSelectionCheckBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.save", new Serializable[0]));
            this.saveSelectionCheckBox.setSelected(saveSelection);
            panel.add(this.saveSelectionCheckBox);
        }
    }

    protected void addPoiComboBox(JPanel panel) {
        if (this.poiSelectionActive) {
            List<PoiModel> pickPoints = this.tourCaller.fetchPoisWithTypes(CollectionUtil.buildHashSet(PoiType.PICK_POINT));
            if (this.tours != null && this.tours.size() == 1) {
                List<StopModel> allStops = TourModelUtil.getAllStops(this.tours.iterator().next(), true);
                for (StopModel stop : allStops) {
                    if (stop == null || stop.getPoi() == null || stop.getPoi().getPoiType() != PoiType.PICK_POINT) continue;
                    pickPoints.remove(stop.getPoi());
                }
            }
            pickPoints.add(0, null);
            this.poiComboBox = new JComboBox<Object>(pickPoints.toArray());
            JLabel poiLabel = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.depot", new Serializable[0]) + ": ");
            panel.add(poiLabel);
            this.poiComboBox.setRenderer(new PoiModelListCellRenderer(false));
            panel.add(this.poiComboBox);
            this.startPointComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AbstractRoutingWithComboBoxDialog.this.updateDialog();
                }
            });
            this.endPointComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    AbstractRoutingWithComboBoxDialog.this.updateDialog();
                }
            });
        }
    }

    protected void addStartTimeSelection(JPanel panel) {
        String prop = ModelEnviroment.getProperties().getProperty(START_TIME_PROPERTY_KEY);
        Date time = null;
        String text = null;
        if (prop != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(FormUtil.CLOCKFORMAT);
            try {
                time = sdf.parse(prop);
                text = prop;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        this.startTime = new Holder<Object>(time);
        panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("gui.tour.plannedStartTime", new Serializable[0])));
        panel.add(ClientSwingUtil.createParameterTextField(10, text, true, "Element", new Holder<Holder<Date>>(this.startTime), panel, FormUtil.CLOCKFORMAT, Date.class));
    }

    public PoiModel getSelectedPoi() {
        if (this.poiComboBox != null && this.poiComboBox.isEnabled() && this.poiComboBox.getSelectedItem() instanceof PoiModel) {
            return (PoiModel)this.poiComboBox.getSelectedItem();
        }
        return null;
    }

    public CalculateType getCalculateType() {
        CalculateType type = null;
        type = this.isStartPointSelected(TourModelUtil.CALCULATESTARTITEMS[0]) && this.isEndPointSelected(TourModelUtil.CALCULATEENDITEMS[0]) ? CalculateType.NONFIX : (this.isStartPointSelected(TourModelUtil.CALCULATESTARTITEMS[1]) && this.isEndPointSelected(TourModelUtil.CALCULATEENDITEMS[0]) ? CalculateType.STARTWITHPOI : (this.isStartPointSelected(TourModelUtil.CALCULATESTARTITEMS[0]) && this.isEndPointSelected(TourModelUtil.CALCULATEENDITEMS[1]) ? CalculateType.ENDWITHPOI : CalculateType.BOTHWITHPOI));
        return type;
    }

    public OptimizationType getCurrentOptimizationType(TourModel tour) {
        StopModel firtstStop;
        String startPoint = String.valueOf(this.startPointComboBox.getSelectedItem());
        String endPoint = String.valueOf(this.endPointComboBox.getSelectedItem());
        if (startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[0]) && this.toursStartWithPickPoint()) {
            startPoint = TourModelUtil.OPTIMISESTARTITEMS[1];
        }
        if (endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[0]) && this.toursEndWithPickPoint()) {
            endPoint = TourModelUtil.OPTIMISEENDITEMS[1];
        }
        if ((firtstStop = TourModelUtil.getFirstStop(tour, CollectionUtil.buildHashSet(PoiType.DELIVERER_LOCATION, PoiType.PICK_POINT), true)) != null && firtstStop.getPoi() != null && firtstStop.getPoi().getPoiType() == PoiType.PICK_POINT && startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[0])) {
            startPoint = TourModelUtil.OPTIMISESTARTITEMS[1];
        }
        OptimizationType type = null;
        type = startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[0]) && endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[0]) ? OptimizationType.NONFIX : (startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[1]) && endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[0]) ? OptimizationType.STARTPOINTFIX : (startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[0]) && endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[1]) ? OptimizationType.ENDPOINTFIX : (startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[1]) && endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[1]) ? OptimizationType.BOTHPOINTFIX : (startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[2]) && endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[0]) ? OptimizationType.STARTWITHPOI : (startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[2]) && endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[1]) ? OptimizationType.STARTWITHPOIENDFIX : (startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[0]) && endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[2]) ? OptimizationType.ENDWITHPOI : (startPoint.equals(TourModelUtil.OPTIMISESTARTITEMS[1]) && endPoint.equals(TourModelUtil.OPTIMISEENDITEMS[2]) ? OptimizationType.STARTFIXENDWITHPOI : OptimizationType.BOTHWITHPOI)))))));
        return type;
    }

    private boolean toursStartWithPickPoint() {
        for (TourModel tour : this.tours) {
            StopModel stop;
            List<StopModel> allStops = TourModelUtil.getAllStops(tour, true);
            Iterator<StopModel> iterator = allStops.iterator();
            if (!iterator.hasNext() || (stop = iterator.next()).getPoi() == null) continue;
            return true;
        }
        return false;
    }

    private boolean toursEndWithPickPoint() {
        for (TourModel tour : this.tours) {
            List<StopModel> allStops = TourModelUtil.getAllStops(tour, true);
            int i = allStops.size() - 1;
            if (i <= 0 || allStops.get(i).getPoi() == null) continue;
            return true;
        }
        return false;
    }

    public Tripel<OptimizationType, Integer, Integer> adaptTourForOptimization(TourModel tour) {
        Integer sizeOfStart = (Integer)this.sizeOfStartBlockSpinner.getValue();
        Integer sizeOfEnd = (Integer)this.sizeOfEndBlockSpinner.getValue();
        PoiModel unloadingPoi = null;
        if (this.getSelectedPoi() != null) {
            unloadingPoi = PoiModelUtil.createUnloadingPoi(this.getSelectedPoi());
            Integer n = sizeOfStart;
            Integer n2 = sizeOfStart = Integer.valueOf(sizeOfStart + 1);
        }
        PoiModel delivererPoi = TourModelUtil.getDelivererPoi(tour, this.tourCaller);
        OptimizationType type = this.getCurrentOptimizationType(tour);
        OptimizationType optimizationType = TourModelUtil.adaptTourForOptimization(tour, delivererPoi, unloadingPoi, type);
        return new Tripel<OptimizationType, Integer, Integer>(optimizationType, sizeOfStart, sizeOfEnd);
    }

    private boolean isEndPointSelected(String string) {
        return String.valueOf(this.endPointComboBox.getSelectedItem()).equals(string);
    }

    private boolean isStartPointSelected(String string) {
        return String.valueOf(this.startPointComboBox.getSelectedItem()).equals(string);
    }

    public RouteVehicleType getRouteVehicleType() {
        return this.routeVehicleType;
    }

    public RouteType getRouteType() {
        return this.routeType;
    }

    public boolean isSaved() {
        return this.saveSelectionCheckBox == null ? true : this.saveSelectionCheckBox.isSelected();
    }

    public Collection<TourModel> getTours() {
        return this.tours;
    }

    public TourCaller getTourCaller() {
        return this.tourCaller;
    }

    public boolean isImportOrder() {
        return this.importOrder;
    }

    public boolean withDifficultyLevel() {
        return this.difficultyLevelCheckBox == null ? false : this.difficultyLevelCheckBox.isSelected();
    }

    public Date getStartTime() {
        return this.startTime.getElement();
    }

    public ModelEnviroment getModelEnviroment() {
        return this.modelEnviroment;
    }
}

