/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.print.legend;

import de.datomino.pdf.engine.PdfCreatorImpl;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.util.geo.ImmutableGeoObjectFactory;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.swing.renderer.AreaRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.ktde.math.projection.MercatorFactory;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;

public final class AreaPrinterImplLegendUtil {
    private AreaPrinterImplLegendUtil() {
    }

    public static void setLegend(Map<String, Object> dataMap, Collection<AreaObjectModel> areaObjectModels, AreaLayerRenderer mainAreaLayerRenderer) throws IOException {
        ArrayList<AreaObjectModel> areaObjectModelList = new ArrayList<AreaObjectModel>(areaObjectModels);
        Collections.sort(areaObjectModelList, new Comparator<AreaObjectModel>(){

            @Override
            public int compare(AreaObjectModel o1, AreaObjectModel o2) {
                String s1 = StringUtil.nullToEmpty(o1.getShortcut());
                String s2 = StringUtil.nullToEmpty(o2.getShortcut());
                return s1.compareTo(s2);
            }
        });
        ArrayList<Tripel<String, String, String>> legendImageList = new ArrayList<Tripel<String, String, String>>(areaObjectModels.size());
        int height = 40;
        int width = 200;
        for (AreaObjectModel areaObjectModel : areaObjectModelList) {
            Collection renderersForModel = mainAreaLayerRenderer.getRenderersForModel(areaObjectModel, 0, false, true);
            BufferedImage bi = new BufferedImage(width, height, 2);
            Graphics2D graphics2d = (Graphics2D)bi.getGraphics();
            graphics2d.setClip(0, 0, width, height);
            AffineTransform affineTransform = graphics2d.getTransform();
            affineTransform.scale(-1.0, 1.0);
            graphics2d.setTransform(affineTransform);
            Color bg = new Color(0, 0, 0, 0);
            graphics2d.setBackground(bg);
            Rectangle rect = graphics2d.getClipBounds();
            for (Tripel rendererTripel : renderersForModel) {
                AreaRenderer<AreaObjectModel, AreaObjectModel> areaRenderer = rendererTripel.getElement1();
                if (areaRenderer == null) continue;
                Object rendererProperties = areaRenderer.createRendererProperties(null);
                if (rendererProperties != null) {
                    rendererProperties.setUpp(1.0);
                }
                ImmutablePolygon geom = AreaPrinterImplLegendUtil.createGeom(graphics2d.getClipBounds());
                areaRenderer.renderForPreview(graphics2d, areaObjectModel, geom, (AreaObjectModel)rendererProperties);
                rect.setSize(rect.width - 1, rect.height - 1);
                rect.setLocation(rect.x + 1, rect.y);
                graphics2d.setColor(Color.BLACK);
                graphics2d.draw(rect);
            }
            String imageFile = PdfCreatorImpl.saveImageToTempFile(bi);
            legendImageList.add(new Tripel<String, String, String>(areaObjectModel.getShortcut(), areaObjectModel.getDisplayname(), imageFile));
        }
        dataMap.put("legendImageList", legendImageList);
        dataMap.put("legendImageListImageHeight", height);
        dataMap.put("legendImageListImageWidth", width);
    }

    private static ImmutablePolygon createGeom(Rectangle rect) {
        ImmutablePolygon immutablePolygon;
        try {
            immutablePolygon = ImmutableGeoObjectFactory.createImmutablePolygon(Arrays.asList(ImmutableGeoObjectFactory.createImmutablePoint(MercatorFactory.INSTANCE.createCoordinate(rect.getX(), rect.getY())), ImmutableGeoObjectFactory.createImmutablePoint(MercatorFactory.INSTANCE.createCoordinate(rect.getX() + rect.getWidth(), rect.getY())), ImmutableGeoObjectFactory.createImmutablePoint(MercatorFactory.INSTANCE.createCoordinate(rect.getX() + rect.getWidth(), rect.getY() + rect.getHeight())), ImmutableGeoObjectFactory.createImmutablePoint(MercatorFactory.INSTANCE.createCoordinate(rect.getX(), rect.getY() + rect.getHeight()))));
        }
        catch (IllegalPointCountException e) {
            throw new RuntimeException(e);
        }
        return immutablePolygon;
    }
}

