/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.microcell;

import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.communication.AllCaller;
import de.datomino.peppergis.client.communication.AreaCaller;
import de.datomino.peppergis.client.gui.asynchronous.AbstractAsynchronousDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.ModelCache;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.map.ParcelAttributeValueDescriptorModelImpl;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.dto.asynchronous.AsynchronousDto;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.microcell.MicrocellHandler;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.MicrocellDescriptorType;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.ErrorMessageDialog;
import de.datomino.util.swing.SwingUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.ktde.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrocellHandlerImpl
implements MicrocellHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicrocellHandler.class);
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private RouteVehicleType vehicleType = RouteVehicleType.FOOT;

    public MicrocellHandlerImpl(BaseLayerEditorPanel baseLayerEditorPanel) {
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        String type = ModelEnviroment.getProperties().getProperty("microcell.handler.vehicleType");
        if (!StringUtil.isBlank(type)) {
            this.vehicleType = RouteVehicleType.valueOf(type);
        }
    }

    @Override
    public void createMicrocellByLayer(final Collection<ParcelModel> parcels, final boolean clear) {
        final AreaLayerModel currentAreaLayer = this.baseLayerEditorPanel.getCurrentAreaLayer();
        if (currentAreaLayer.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_MICRO_CELL) {
            ModelEnviroment modelEnviroment = this.baseLayerEditorPanel.getModelEnviroment();
            UndoManager undoManager = modelEnviroment.getUndoManager();
            undoManager.startTransaction();
            AllCaller allCaller = modelEnviroment.getAllCaller();
            AreaCaller areaCaller = allCaller.getAreaCaller();
            Collection<AreaAttributeValueDescriptorModel> areaDescriptors = areaCaller.fetchAllAreaAttributeValueDescriptors();
            final HashMap<MicrocellDescriptorType, Model> descriptorMap = new HashMap<MicrocellDescriptorType, Model>();
            descriptorMap.put(MicrocellDescriptorType.DISTANCE, this.getMicrocellDescriptor("microcell.attribute.descriptor.distance", areaDescriptors));
            descriptorMap.put(MicrocellDescriptorType.DURATION, this.getMicrocellDescriptor("microcell.attribute.descriptor.duration", areaDescriptors));
            descriptorMap.put(MicrocellDescriptorType.PARCELS, this.getMicrocellDescriptor("microcell.attribute.descriptor.parcels", areaDescriptors));
            descriptorMap.put(MicrocellDescriptorType.WEIGHT, this.getMicrocellDescriptor("microcell.attribute.descriptor.weight", areaDescriptors));
            Collection<ParcelAttributeValueDescriptorModel> parcelDescriptors = allCaller.getStreetNetCaller().fetchAllParcelAttributeValueDescriptors();
            descriptorMap.put(MicrocellDescriptorType.PARCELWEIGHT, this.getParcelDescriptor("parcel.attribute.descriptor.weight", parcelDescriptors));
            undoManager.finishTransaction("");
            try {
                undoManager.storeTransactions();
            }
            catch (ValidateException e) {
                LOGGER.error("failed store", e);
                undoManager.rollbackTransaction();
            }
            LOGGER.info("clear cache");
            this.clear(currentAreaLayer, modelEnviroment.getModelCache());
            LOGGER.info("create micro-cell in area layer - " + currentAreaLayer.getDisplayname());
            final ErrorMessages errorMessages = new ErrorMessages();
            AbstractAsynchronousDialog<Boolean> asynchronousDialog = new AbstractAsynchronousDialog<Boolean>(this.baseLayerEditorPanel.getParentWindow(), ModelEnviroment.getMessageResolver().resolveMessage("messages.microcell.create", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.pleaseWait", new Serializable[0]), 1, modelEnviroment){
                private static final long serialVersionUID = 9009017884430663510L;

                @Override
                protected String startAsynchronous() {
                    return this.modelEnviroment.getAllCaller().getAsynchronousCaller().cutAreaLayerIntoMicrocells(currentAreaLayer, MicrocellHandlerImpl.this.vehicleType, parcels, descriptorMap, clear, errorMessages);
                }

                @Override
                protected AsynchronousDto<Boolean> getAsynchronousDto(String token) {
                    return this.modelEnviroment.getAllCaller().getAsynchronousCaller().getCutAreaLayerIntoMicrocellsesult(token);
                }
            };
            try {
                asynchronousDialog.run();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (errorMessages.hasErrors()) {
                BufferedImage image;
                try {
                    image = ImageIO.read(MicrocellHandlerImpl.class.getResourceAsStream("/images/pepper.png"));
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                ErrorMessageDialog errorMessageDialog = new ErrorMessageDialog(SwingUtils.findWindowParent(this.baseLayerEditorPanel), ModelEnviroment.getMessageResolver(), errorMessages, image);
                errorMessageDialog.setVisible(true);
            } else {
                List<AreaObjectModel> areaObjects = areaCaller.fetchAreaObjectsByAreaLayer(currentAreaLayer, false);
                JOptionPane.showMessageDialog(this.baseLayerEditorPanel, areaObjects.size() + " Mikrozelle wurden erstellt");
            }
        }
    }

    private Model getParcelDescriptor(String property, Collection<ParcelAttributeValueDescriptorModel> parcelDescriptors) {
        String key = ModelEnviroment.getProperties().getProperty(property);
        ParcelAttributeValueDescriptorModel descriptor = null;
        for (ParcelAttributeValueDescriptorModel d : parcelDescriptors) {
            if (!d.getKey().equals(key)) continue;
            descriptor = d;
            break;
        }
        if (descriptor == null) {
            descriptor = new ParcelAttributeValueDescriptorModelImpl();
            descriptor.setKey(key);
            descriptor.setName(ModelEnviroment.getMessageResolver().resolveMessage(property, new Serializable[0]));
            descriptor.setEditable(true);
            descriptor.setModifiable(true);
            descriptor.setAttributeValueType(AttributeValueType.INTEGER);
        }
        return descriptor;
    }

    private AreaAttributeValueDescriptorModel getMicrocellDescriptor(String property, Collection<AreaAttributeValueDescriptorModel> areaDescriptors) {
        String key = ModelEnviroment.getProperties().getProperty(property);
        AreaAttributeValueDescriptorModel descriptor = null;
        for (AreaAttributeValueDescriptorModel d : areaDescriptors) {
            if (!d.getKey().equals(key)) continue;
            descriptor = d;
            break;
        }
        if (descriptor == null) {
            String errorMsg = "no area attribute value descriptor - " + key;
            LOGGER.error(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        return descriptor;
    }

    private void clear(AreaLayerModel areaLayer, ModelCache modelCache) {
        Set<Object> microcellSet = new HashSet<AreaObjectModel>();
        Set<AreaObjectModel> selectedObjects = this.baseLayerEditorPanel.getSelectedObjects();
        for (AreaObjectModel areaObject : selectedObjects) {
            if (!areaObject.getAreaLayer().equals(areaLayer)) continue;
            modelCache.evictModel(areaObject);
            microcellSet.add(areaObject);
        }
        selectedObjects.removeAll(microcellSet);
        Map<AreaLayerModel, Set<AreaObjectModel>> objectMarkSetsHash = this.baseLayerEditorPanel.getObjectMarkSetsHash();
        if (objectMarkSetsHash.containsKey(areaLayer)) {
            microcellSet = objectMarkSetsHash.get(areaLayer);
            for (AreaObjectModel areaObjectModel : microcellSet) {
                if (!areaObjectModel.getAreaLayer().equals(areaLayer)) continue;
                modelCache.evictModel(areaObjectModel);
                microcellSet.add(areaObjectModel);
            }
        }
        microcellSet.clear();
        this.baseLayerEditorPanel.getCurrentAreaRenderer().getBucketsModel().clear();
    }

    @Override
    public void addParcels(AreaObjectModel microcell, Collection<ParcelModel> parcels) {
    }

    @Override
    public void reomveParcels(AreaObjectModel microcell, Collection<ParcelModel> parcels) {
    }
}

