/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.messaging;

import de.datomino.client.local.message.ClientMessage;
import de.datomino.client.local.message.MarkArea;
import de.datomino.client.local.message.ObjectFactory;
import de.datomino.client.local.message.Pdf;
import de.datomino.pdf.engine.PdfCreator;
import de.datomino.pdf.engine.PdfCreatorImpl;
import de.datomino.peppergis.client.communication.AllCaller;
import de.datomino.peppergis.client.external.communication.ClientMessageHandler;
import de.datomino.peppergis.client.external.communication.UnknownMessageException;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.messaging.DoneDialog;
import de.datomino.util.geo.GeomModel;
import de.datomino.util.geo.GeomModelImpl;
import de.datomino.util.geo.ImmutableGeoObject;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.ktde.math.projection.CoordinateFactory;
import org.ktde.swing.navigator.NavigatorRenderer;
import org.ktde.util.datatypes.Tupel;

public class BaseLayerClientMessageHandler
implements ClientMessageHandler {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private static final JAXBContext JAXB_CONTEXT;
    private PdfCreator pdfCreator = new PdfCreatorImpl();
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private AllCaller allCaller;

    public BaseLayerClientMessageHandler(AllCaller allCaller, BaseLayerEditorPanel baseLayerEditorPanel) {
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.allCaller = allCaller;
    }

    @Override
    public void handleClientMessage(InputStream in, OutputStream out) throws UnknownMessageException {
        try {
            String inString = this.getInString(in);
            ClientMessage clientMessage = (ClientMessage)JAXB_CONTEXT.createUnmarshaller().unmarshal(new StringReader(inString));
            String operation = clientMessage.getOperation();
            ClientMessage response = null;
            if ("markArea".equals(operation)) {
                response = this.getAreas(clientMessage);
            } else if ("getPdf".equals(operation)) {
                response = this.createPdf(clientMessage);
            } else {
                throw new UnknownMessageException();
            }
            if (response != null) {
                JAXB_CONTEXT.createMarshaller().marshal((Object)response, out);
            }
        }
        catch (JAXBException e) {
            throw new UnknownMessageException(e);
        }
        catch (IOException e) {
            throw new UnknownMessageException(e);
        }
        catch (Exception e) {
            throw new UnknownMessageException(e);
        }
    }

    private ClientMessage createPdf(ClientMessage clientMessage) throws Exception {
        ClientMessage response = null;
        List<String> areaKeys = clientMessage.getAreaKey().getAreaId();
        Collection<AreaObjectModel> areaObjectModels = this.allCaller.getAreaCaller().getAreaObjectByKey(areaKeys);
        List<Tupel<GeomModel<? extends ImmutableGeoObject>, NavigatorRenderer>> models = this.createList(areaObjectModels);
        Object image = null;
        Map<String, Object> emptyMap = Collections.emptyMap();
        InputStream realPdf = this.pdfCreator.createPdf("/fo/area.vm", emptyMap, Collections.singletonMap("imagePath", image), ModelEnviroment.getMessageResolver());
        response = OBJECT_FACTORY.createClientMessage();
        response.setOperation("getPdf");
        Pdf pdf = OBJECT_FACTORY.createPdf();
        pdf.setPdf(IOUtils.toByteArray(realPdf));
        response.setPdf(pdf);
        return response;
    }

    private List<Tupel<GeomModel<? extends ImmutableGeoObject>, NavigatorRenderer>> createList(Collection<AreaObjectModel> areaObjectModels) {
        ArrayList<Tupel<GeomModel<? extends ImmutableGeoObject>, NavigatorRenderer>> models = new ArrayList<Tupel<GeomModel<? extends ImmutableGeoObject>, NavigatorRenderer>>(areaObjectModels.size());
        HashMap<AreaLayerModel, AreaLayerRenderer> rendererMap = new HashMap<AreaLayerModel, AreaLayerRenderer>();
        for (AreaObjectModel areaObjectModel : areaObjectModels) {
            if (areaObjectModel.getGeom() == null) continue;
            AreaLayerRenderer areaLayerRenderer = (AreaLayerRenderer)rendererMap.get(areaObjectModel.getAreaLayer());
            if (areaLayerRenderer == null) {
                areaLayerRenderer = this.createAreaLayererRenderer(areaObjectModel.getAreaLayer(), areaObjectModel.getGeom().getCoordinateFactory());
                rendererMap.put(areaObjectModel.getAreaLayer(), areaLayerRenderer);
            }
            DefaultGeoObjectBucketsModel bucketsModel = (DefaultGeoObjectBucketsModel)areaLayerRenderer.getBucketsModel();
            bucketsModel.addGeom(areaObjectModel);
            models.add(new Tupel<GeomModelImpl<ImmutablePolygonKind>, AreaLayerRenderer>(new GeomModelImpl<ImmutablePolygonKind>(areaObjectModel.getGeom()), areaLayerRenderer));
        }
        return models;
    }

    private AreaLayerRenderer createAreaLayererRenderer(AreaLayerModel areaLayer, CoordinateFactory coordinateFactory) {
        Long id = areaLayer.getId();
        String prefix = id == null ? "default" : id.toString();
        return AreaLayerRenderer.createDefaultAreaLayerRenderer("ClientMessageHandler area renderer", new DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(AreaLayerRenderer.getAreaLayerBucketSize(), coordinateFactory, BaseLayerEditorPanel.createAreaGeomExtractor()), BaseLayerEditorPanel.createAreaGeomExtractor(), prefix, this.baseLayerEditorPanel.getModelEnviroment(), true, this.baseLayerEditorPanel.getNavigatorPanel());
    }

    private String getInString(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = in.read();
        int mLength = "<!-- END -->".length();
        while (c != -1) {
            sb.append((char)c);
            if (sb.length() >= mLength && sb.substring(sb.length() - mLength, sb.length()).equals("<!-- END -->")) break;
            c = in.read();
        }
        return sb.toString();
    }

    private ClientMessage getAreas(ClientMessage clientMessage) {
        ClientMessage response = null;
        List<String> areaKeys = clientMessage.getMarkArea().getAreaId();
        Collection<AreaObjectModel> areaObjectModels = this.allCaller.getAreaCaller().getAreaObjectByKey(areaKeys);
        this.baseLayerEditorPanel.select(areaObjectModels);
        DoneDialog doneDialog = new DoneDialog(this.baseLayerEditorPanel.getParentWindow(), this.baseLayerEditorPanel, areaKeys);
        while (!doneDialog.isDone()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        response = OBJECT_FACTORY.createClientMessage();
        response.setOperation("markArea");
        MarkArea markArea = OBJECT_FACTORY.createMarkArea();
        List<String> keys = markArea.getAreaId();
        keys.addAll(doneDialog.getAreaKeys());
        response.setMarkArea(markArea);
        return response;
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance(ClientMessage.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

