/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.search;

import de.datomino.peppergis.client.gui.common.CountryComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.subscription.SubscriptionDialog;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.base.LocationModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.util.model.location.LocationWrapper;
import de.datomino.peppergis.client.util.model.location.LocationWrapperFactory;
import de.datomino.peppergis.dto.area.AreaLayerDto;
import de.datomino.peppergis.dto.lucene.LocationSearchDto;
import de.datomino.peppergis.dto.lucene.SubscriptionSearchDtoImpl;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.gui.search.SubscriptionSearchTableModel;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.ktde.math.projection.Coordinate;

public class SubscriptionSearchPane
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -946312162902518103L;
    private AreaLayerModel currentLayer;
    private ModelEnviroment modelEnviroment;
    private JPanel mainPanel;
    private JPanel tPanel;
    private JTextField subscriptionNumber;
    private JTextField customerNumber;
    private JTextField firstName;
    private JTextField lastName;
    private CountryComboBox country;
    private JTextField postcode;
    private JTextField city;
    private JTextField district;
    private JTextField street;
    private JTextField houseNumber;
    private JTextField houseNumberExt;
    private JButton search;
    private JTable resultTable;
    private JScrollPane tableContainer;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public SubscriptionSearchPane(ModelEnviroment modelEnviroment, BaseLayerEditorPanel baseLayerEditorPanel) {
        super(new BorderLayout());
        this.modelEnviroment = modelEnviroment;
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.currentLayer = baseLayerEditorPanel.getCurrentAreaLayer();
        this.mainPanel = new JPanel(new SpringLayout());
        JPanel fPanel = new JPanel(new SpringLayout());
        JPanel fPanelPart1 = new JPanel(new SpringLayout());
        fPanelPart1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptionNumber", new Serializable[0])));
        this.subscriptionNumber = new JTextField();
        this.subscriptionNumber.setPreferredSize(new Dimension(200, this.subscriptionNumber.getPreferredSize().height));
        this.subscriptionNumber.addActionListener(this);
        fPanelPart1.add(this.subscriptionNumber);
        fPanelPart1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.customerNumber", new Serializable[0])));
        this.customerNumber = new JTextField();
        this.customerNumber.setPreferredSize(new Dimension(200, this.customerNumber.getPreferredSize().height));
        this.customerNumber.addActionListener(this);
        fPanelPart1.add(this.customerNumber);
        fPanelPart1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.firstName", new Serializable[0])));
        this.firstName = new JTextField();
        this.firstName.setPreferredSize(new Dimension(200, this.firstName.getPreferredSize().height));
        this.firstName.addActionListener(this);
        fPanelPart1.add(this.firstName);
        fPanelPart1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.customer.lastName", new Serializable[0])));
        this.lastName = new JTextField();
        this.lastName.setPreferredSize(new Dimension(200, this.lastName.getPreferredSize().height));
        this.lastName.addActionListener(this);
        fPanelPart1.add(this.lastName);
        fPanelPart1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.postcode", new Serializable[0])));
        this.postcode = new JTextField();
        this.postcode.setPreferredSize(new Dimension(200, this.postcode.getPreferredSize().height));
        this.postcode.addActionListener(this);
        fPanelPart1.add(this.postcode);
        fPanelPart1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.country", new Serializable[0])));
        this.country = new CountryComboBox(true, this.modelEnviroment.getAllCaller().getBaseCaller().getDefaultCountry());
        fPanelPart1.add(this.country);
        SpringUtilities.makeCompactGrid(fPanelPart1, 6, 2, 2, 5, 2, 6);
        fPanel.add(fPanelPart1);
        JPanel fPanelPart2 = new JPanel(new SpringLayout());
        fPanelPart2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.city", new Serializable[0])));
        this.city = new JTextField();
        this.city.setPreferredSize(new Dimension(200, this.city.getPreferredSize().height));
        this.city.addActionListener(this);
        fPanelPart2.add(this.city);
        fPanelPart2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.district", new Serializable[0])));
        this.district = new JTextField();
        this.district.setPreferredSize(new Dimension(200, this.district.getPreferredSize().height));
        this.district.addActionListener(this);
        fPanelPart2.add(this.district);
        fPanelPart2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.street", new Serializable[0])));
        this.street = new JTextField();
        this.street.setPreferredSize(new Dimension(200, this.street.getPreferredSize().height));
        this.street.addActionListener(this);
        fPanelPart2.add(this.street);
        fPanelPart2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumber", new Serializable[0])));
        this.houseNumber = new JTextField();
        this.houseNumber.setPreferredSize(new Dimension(200, this.houseNumber.getPreferredSize().height));
        this.houseNumber.addActionListener(this);
        fPanelPart2.add(this.houseNumber);
        fPanelPart2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("address.housenumberExt", new Serializable[0])));
        this.houseNumberExt = new JTextField();
        this.houseNumberExt.setPreferredSize(new Dimension(200, this.houseNumber.getPreferredSize().height));
        this.houseNumberExt.addActionListener(this);
        fPanelPart2.add(this.houseNumberExt);
        fPanelPart2.add(new JLabel(" "));
        fPanelPart2.add(new JLabel(" "));
        SpringUtilities.makeCompactGrid(fPanelPart2, 6, 2, 2, 5, 2, 6);
        fPanel.add(fPanelPart2);
        SpringUtilities.makeCompactGrid(fPanel, 1, 2, 2, 5, 3, 7);
        this.mainPanel.add(fPanel);
        JPanel bPanel = new JPanel(new FlowLayout());
        this.search = new JButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.search", new Serializable[0]));
        this.search.addActionListener(this);
        bPanel.add(this.search);
        this.mainPanel.add(bPanel);
        this.tPanel = new JPanel(new BorderLayout());
        this.resultTable = new JTable();
        this.resultTable.setModel(new SubscriptionSearchTableModel());
        this.setResultTableStyle();
        this.resultTable.setSelectionMode(0);
        ListSelectionModel rowSM = this.resultTable.getSelectionModel();
        rowSM.setSelectionMode(0);
        this.resultTable.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.resultTable.addMouseListener(new SubscriptionMouseListener());
        this.tableContainer = new JScrollPane(this.resultTable);
        this.tPanel.add((Component)this.tableContainer, "Center");
        this.mainPanel.add(this.tPanel);
        SpringUtilities.makeCompactGrid(this.mainPanel, 3, 1, 2, 5, 6, 6);
        this.add((Component)this.mainPanel, "North");
    }

    private void setResultTableStyle() {
        int width = 200;
        this.resultTable.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.resultTable.getColumnModel().getColumn(0).setPreferredWidth(width);
        this.resultTable.getColumnModel().getColumn(1).setPreferredWidth(width);
        this.resultTable.getColumnModel().getColumn(2).setPreferredWidth(width);
        this.resultTable.getColumnModel().getColumn(3).setPreferredWidth(width);
        this.resultTable.getColumnModel().getColumn(4).setPreferredWidth(width / 2);
        this.resultTable.getColumnModel().getColumn(5).setPreferredWidth(width);
        this.resultTable.getColumnModel().getColumn(6).setPreferredWidth(width);
        this.resultTable.getColumnModel().getColumn(7).setPreferredWidth(width);
        this.resultTable.getColumnModel().getColumn(8).setPreferredWidth(width);
        this.resultTable.getColumnModel().getColumn(9).setPreferredWidth(width / 2);
        this.resultTable.getColumnModel().getColumn(10).setPreferredWidth(width / 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SubscriptionSearchTableModel resultTableModel = (SubscriptionSearchTableModel)this.resultTable.getModel();
        this.resultTable.getSelectionModel().clearSelection();
        List<SubscriptionModel> emptyList = Collections.emptyList();
        resultTableModel.setSubscriptions(emptyList);
        SubscriptionSearchDtoImpl subscriptionSearchDto = new SubscriptionSearchDtoImpl();
        subscriptionSearchDto.setSubscriptionNumber(this.subscriptionNumber.getText());
        subscriptionSearchDto.setCustomerNumber(this.customerNumber.getText());
        subscriptionSearchDto.setFirstName(this.firstName.getText());
        subscriptionSearchDto.setLastName(this.lastName.getText());
        subscriptionSearchDto.setAreaLayerDto(this.currentLayer == null ? null : (AreaLayerDto)((Object)this.currentLayer.createDto()));
        LocationSearchDto locationSearchDto = new LocationSearchDto();
        locationSearchDto.setCountry(this.country.getSelectedItem());
        locationSearchDto.setPostcode(this.postcode.getText());
        locationSearchDto.setCity(this.city.getText());
        locationSearchDto.setDistrict(this.district.getText());
        locationSearchDto.setStreet(this.street.getText());
        if (!this.houseNumber.getText().isEmpty() && this.houseNumber.getText() != null) {
            try {
                locationSearchDto.setHousenumber(Integer.parseInt(this.houseNumber.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        locationSearchDto.setHousenumberExtension(this.houseNumberExt.getText());
        subscriptionSearchDto.setLocationSearchDto(locationSearchDto);
        List<SubscriptionModel> searchSubscriptions = this.modelEnviroment.getAllCaller().getSubscriptionSearchCaller().searchSubscriptions(subscriptionSearchDto, true, true);
        ((SubscriptionSearchTableModel)this.resultTable.getModel()).setSubscriptions(searchSubscriptions);
    }

    public SubscriptionModel getSelectedSubscription() {
        int s = this.resultTable.getSelectedRow();
        if (s >= 0) {
            return ((SubscriptionSearchTableModel)this.resultTable.getModel()).getSubscriptionAt(s);
        }
        return null;
    }

    private class SubscriptionMouseListener
    extends MouseAdapter {
        private SubscriptionMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int rowAtPoint;
            super.mouseClicked(e);
            if (e.getClickCount() > 1 && (rowAtPoint = SubscriptionSearchPane.this.resultTable.rowAtPoint(e.getPoint())) >= 0) {
                SubscriptionSearchTableModel resultTableModel = (SubscriptionSearchTableModel)SubscriptionSearchPane.this.resultTable.getModel();
                SubscriptionModel subscription = resultTableModel.getSubscriptionAt(rowAtPoint);
                SubscriptionDialog subscriptionDialog = new SubscriptionDialog(SwingUtils.findWindowParent(SubscriptionSearchPane.this), Collections.singletonList(subscription), SubscriptionSearchPane.this.modelEnviroment);
                subscriptionDialog.setVisible(true);
            }
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            LocationWrapper locationWrapper;
            ImmutablePoint geoLocation;
            SubscriptionSearchTableModel resultTableModel;
            SubscriptionModel subscription;
            LocationModel location;
            int i = SubscriptionSearchPane.this.resultTable.getSelectedRow();
            if (i >= 0 && (location = (subscription = (resultTableModel = (SubscriptionSearchTableModel)SubscriptionSearchPane.this.resultTable.getModel()).getSubscriptionAt(i)).getLocation()) != null && (geoLocation = (locationWrapper = LocationWrapperFactory.INSTANCE.createLocationWrapper(location)).getGeoLocation()) != null) {
                Coordinate coordinate = geoLocation.getCoordinate();
                SubscriptionSearchPane.this.baseLayerEditorPanel.getNavigatorPanel().center(coordinate);
                SubscriptionSearchPane.this.baseLayerEditorPanel.getSearchActionButton().setCoordinate(coordinate);
            }
        }
    }
}

