/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.pmd;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.exception.ClientImportException;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.gui.pmd.PmdDownloadAreaChooserPane;
import de.datomino.util.message.error.ErrorMessages;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.ktde.util.datatypes.Tupel;

public class PmdDownloadAreaDialog
extends CommonDialog {
    private static final long serialVersionUID = -1888303406439359242L;
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private PmdDownloadAreaChooserPane pmdDownloadAreaChooserPane;

    public PmdDownloadAreaDialog(BaseLayerEditorPanel baseLayerEditorPanel) throws ClientImportException {
        super((Component)SwingUtils.findWindowParent(baseLayerEditorPanel), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.pmd.avaiableAreas", new Serializable[0]), Dialog.ModalityType.APPLICATION_MODAL);
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.pmdDownloadAreaChooserPane = new PmdDownloadAreaChooserPane(this.baseLayerEditorPanel.getModelEnviroment());
        this.buildLayout();
    }

    @Override
    protected Action getOkAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
            private static final long serialVersionUID = 3462937149481253809L;

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Collection<Tupel<String, String>> selected = PmdDownloadAreaDialog.this.pmdDownloadAreaChooserPane.getSelected();
                    LinkedList<AreaObjectModel> areas = new LinkedList<AreaObjectModel>();
                    for (Tupel<String, String> tupel : selected) {
                        Collection<AreaObjectModel> areaObjects = PmdDownloadAreaDialog.this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getImportCaller().downloadPmdAreas(PmdDownloadAreaDialog.this.baseLayerEditorPanel.getEditBaseLayer(), tupel.getElement1(), tupel.getElement2());
                        areas.addAll(areaObjects);
                    }
                    PmdDownloadAreaDialog.this.baseLayerEditorPanel.getEditBaseLayerRenderer().getBucketsModel().clear();
                    JOptionPane.showMessageDialog(SwingUtils.findWindowParent(PmdDownloadAreaDialog.this.baseLayerEditorPanel), PmdDownloadAreaDialog.this.createSuccessfulDownloadMessagePane(areas), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.message", new Serializable[0]), 1);
                    PmdDownloadAreaDialog.this.baseLayerEditorPanel.select((Collection<AreaObjectModel>)areas);
                    PmdDownloadAreaDialog.this.baseLayerEditorPanel.getCenterSelectedAreaObjectsAction().actionPerformed(e);
                }
                catch (ClientImportException ex) {
                    ErrorMessages errorMessages = ex.getErrorMessages();
                    JOptionPane.showMessageDialog(SwingUtils.findWindowParent(PmdDownloadAreaDialog.this), errorMessages == null || !errorMessages.hasErrors() ? ex.getMessage() : ModelEnviroment.getMessageResolver().resolveMessages(errorMessages, "\n"), ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                }
                PmdDownloadAreaDialog.this.dispose();
            }
        };
    }

    @Override
    protected Component getMainComponent() {
        return this.pmdDownloadAreaChooserPane;
    }

    @Override
    protected Action getCancelAction() {
        return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
            private static final long serialVersionUID = 929643342653872445L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PmdDownloadAreaDialog.this.dispose();
            }
        };
    }

    private JComponent createSuccessfulDownloadMessagePane(Collection<AreaObjectModel> areaObjects) {
        JPanel messagePanel = new JPanel(new BorderLayout());
        messagePanel.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.pmd.downloaded", Integer.valueOf(areaObjects.size()))), "North");
        Vector<String> names = new Vector<String>(areaObjects.size());
        for (AreaObjectModel areaObjectModel : areaObjects) {
            names.add(areaObjectModel.getShortcut());
        }
        JList list = new JList(names);
        messagePanel.add(new JScrollPane(list));
        return messagePanel;
    }
}

