/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.pmd;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.exception.ClientImportException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class PmdDownloadAreaChooserPane
extends JPanel {
    private static final long serialVersionUID = 4337457623129651178L;
    private JTree tree;

    public PmdDownloadAreaChooserPane(ModelEnviroment modelEnviroment) throws ClientImportException {
        super(new BorderLayout());
        this.buildLayout(modelEnviroment);
    }

    private void buildLayout(ModelEnviroment modelEnviroment) throws ClientImportException {
        this.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.pmd.avaiableAreas", new Serializable[0])), "North");
        Collection<Tripel<String, String, Collection<String>>> names = modelEnviroment.getAllCaller().getImportCaller().getPmdUploadedAreaNames();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (Tripel<String, String, Collection<String>> entry : names) {
            DefaultMutableTreeNode entryNode = new DefaultMutableTreeNode(new Tupel<String, String>(entry.getElement1(), entry.getElement2()));
            for (String client : entry.getElement3()) {
                DefaultMutableTreeNode cNode = new DefaultMutableTreeNode(client);
                entryNode.add(cNode);
            }
            root.add(entryNode);
        }
        this.tree = new JTree(new DefaultTreeModel(root));
        this.tree.setRootVisible(false);
        this.tree.setEditable(false);
        this.tree.setCellRenderer(new PmdDownloadedAreaChooserTreeRenderer(this.tree.getCellRenderer()));
        this.tree.setSelectionModel(new DefaultTreeSelectionModel(){
            private static final long serialVersionUID = -3201088789011188275L;

            @Override
            public void addSelectionPaths(TreePath[] paths) {
                super.addSelectionPaths(this.filter(paths));
            }

            @Override
            public void setSelectionPaths(TreePath[] pPaths) {
                super.setSelectionPaths(this.filter(pPaths));
            }

            private TreePath[] filter(TreePath[] paths) {
                if (paths == null) {
                    return null;
                }
                LinkedList<TreePath> filtered = new LinkedList<TreePath>();
                for (TreePath path : paths) {
                    if (path.getPathCount() > 2) continue;
                    filtered.add(path);
                }
                TreePath[] nT = new TreePath[filtered.size()];
                return filtered.toArray(nT);
            }
        });
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public Collection<Tupel<String, String>> getSelected() {
        TreePath[] treePaths = this.tree.getSelectionPaths();
        LinkedList<Tupel<String, String>> selected = new LinkedList<Tupel<String, String>>();
        if (treePaths != null) {
            for (TreePath treePath : treePaths) {
                Object userObject;
                Object pathComponent = treePath.getPathComponent(1);
                if (!(pathComponent instanceof DefaultMutableTreeNode) || !((userObject = ((DefaultMutableTreeNode)pathComponent).getUserObject()) instanceof Tupel)) continue;
                selected.add((Tupel)userObject);
            }
        }
        return selected;
    }

    private class PmdDownloadedAreaChooserTreeRenderer
    implements TreeCellRenderer {
        private TreeCellRenderer parent;

        public PmdDownloadedAreaChooserTreeRenderer(TreeCellRenderer parent) {
            this.parent = parent;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object nValue = value;
            if (value instanceof DefaultMutableTreeNode && (nValue = ((DefaultMutableTreeNode)value).getUserObject()) instanceof Tupel) {
                Tupel tupel = (Tupel)nValue;
                String name = (String)tupel.getElement1();
                String internalName = (String)tupel.getElement2();
                nValue = StringUtil.isBlank(name) ? internalName : (StringUtil.isBlank(internalName) ? name : name + "/" + internalName);
            }
            return this.parent.getTreeCellRendererComponent(tree, nValue, selected, expanded, leaf, row, hasFocus);
        }
    }
}

