/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.menu;

import de.datomino.peppergis.client.gui.filter.pattern.legend.AbstractLegendPane;
import de.datomino.peppergis.client.gui.filter.pattern.legend.FilterPatternLegendDialog;
import de.datomino.peppergis.client.gui.filter.pattern.legend.ParcelFilterPatternLegendDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.filter.ParcelFilterModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternParameterModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternRelationAreaLayerRelationModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternRelationModel;
import de.datomino.peppergis.client.model.map.ParcelFilterPatternSetupModel;
import de.datomino.peppergis.client.util.wrapper.common.filter.ModelFilterPatternSetup;
import de.datomino.peppergis.client.util.wrapper.parcel.filter.ParcelFilterPatternSetupModelWrapper;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.SetParcelFilterPatternRendererAction;
import de.datomino.peppergis.simplebasearea.gui.menu.AbstractFilterPatternMenu;
import de.datomino.util.callback.CallBack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import org.ktde.swing.AbstractToggleAction;

public class ParcelFilterPatternMenu
extends AbstractFilterPatternMenu {
    private static final long serialVersionUID = -7136258603895617470L;
    private List<ModelFilterPatternSetup<ParcelFilterPatternSetupModel, ParcelFilterPatternRelationModel, ParcelFilterPatternParameterModel, ParcelFilterModel, ParcelFilterPatternRelationAreaLayerRelationModel>> parcelFilterPatternSetupModels = new ArrayList<ModelFilterPatternSetup<ParcelFilterPatternSetupModel, ParcelFilterPatternRelationModel, ParcelFilterPatternParameterModel, ParcelFilterModel, ParcelFilterPatternRelationAreaLayerRelationModel>>();
    private AbstractToggleAction showParcelLegend;

    public ParcelFilterPatternMenu(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.filter.parcel.filterPatternTitle", new Serializable[0]), baseLayerEditorPanel);
        this.createFilterParcelMenu();
    }

    private <T extends Model, S extends Model, U extends Model, V extends Model, W extends Model, X extends Model> void createFilterParcelMenu() {
        CallBack dialogCreator = new CallBack<FilterPatternLegendDialog<T, S, U, V, W, X>, Object>(){

            @Override
            public FilterPatternLegendDialog<T, S, U, V, W, X> execute(Object ... s) {
                return ParcelFilterPatternMenu.this.getBaseLayerEditorPanel().createIfNullParcelFilterPatternLegendDialog();
            }
        };
        CallBack dialogFetcher = new CallBack<FilterPatternLegendDialog<T, S, U, V, W, X>, Object>(){

            @Override
            public FilterPatternLegendDialog<T, S, U, V, W, X> execute(Object ... s) {
                return ParcelFilterPatternMenu.this.getBaseLayerEditorPanel().getParcelFilterPatternLegendDialog();
            }
        };
        CallBack modelFetcher = new CallBack<Collection<ModelFilterPatternSetup<S, T, U, V, X>>, Object>(){

            @Override
            public Collection<ModelFilterPatternSetup<S, T, U, V, X>> execute(Object ... s) {
                Collection<ParcelFilterPatternSetupModel> parcelFilterPatternSetups = ParcelFilterPatternMenu.this.getBaseLayerEditorPanel().getModelEnviroment().getAllCaller().getStreetNetCaller().fetchAllParcelFilterPatternSetupsForAreaLayer(Collections.singleton(ParcelFilterPatternMenu.this.getBaseLayerEditorPanel().getEditBaseLayer()));
                ArrayList list = new ArrayList(parcelFilterPatternSetups.size());
                for (ParcelFilterPatternSetupModel parcelFilterPatternSetupModel : parcelFilterPatternSetups) {
                    list.add(new ParcelFilterPatternSetupModelWrapper(parcelFilterPatternSetupModel));
                }
                return list;
            }
        };
        this.showParcelLegend = this.createShowLegendAction("messages.filter.showLegend", AbstractLegendPane.SymbolType.POINT, dialogCreator, dialogFetcher, modelFetcher);
        this.fillFilterParcelMenu();
        this.getItem(0).setSelected(true);
    }

    private void fillFilterParcelMenu() {
        this.fetchParcelFilterPatternSetups();
        this.fillFilterMenu(this.parcelFilterPatternSetupModels, new CreateSetParcelFilterActionCreator(), this.showParcelLegend);
    }

    private void fetchParcelFilterPatternSetups() {
        Collection<ParcelFilterPatternSetupModel> parcelFilterPatternSetupModels = this.getBaseLayerEditorPanel().getModelEnviroment().getAllCaller().getStreetNetCaller().fetchAllParcelFilterPatternSetupsForAreaLayer(Collections.singleton(this.getBaseLayerEditorPanel().getEditBaseLayer()));
        this.parcelFilterPatternSetupModels.clear();
        for (ParcelFilterPatternSetupModel subsriptionFilterPatternSetupModel : parcelFilterPatternSetupModels) {
            this.parcelFilterPatternSetupModels.add(new ParcelFilterPatternSetupModelWrapper(subsriptionFilterPatternSetupModel));
        }
    }

    public AbstractToggleAction getShowParcelLegend() {
        return this.showParcelLegend;
    }

    public void parcelFilterLegendDialogClosing() {
        this.showParcelLegend.setSelected(false);
    }

    public void refreshParcelFilterPatternMenu() {
        Long filterPatternSetupModelId = this.clearMenu(this.parcelFilterPatternSetupModels);
        this.fetchParcelFilterPatternSetups();
        this.refreshFilterPatternMenu(this.parcelFilterPatternSetupModels, new CreateSetParcelFilterActionCreator(), this.showParcelLegend, filterPatternSetupModelId);
    }

    @Override
    protected <T extends Model, S extends Model, U extends Model, V extends Model, W extends Model, X extends Model> boolean isDialogVisible() {
        ParcelFilterPatternLegendDialog dialog = this.getBaseLayerEditorPanel().getParcelFilterPatternLegendDialog();
        return dialog != null && dialog.isVisible();
    }

    private class CreateSetParcelFilterActionCreator
    implements CallBack<Action, Object> {
        private CreateSetParcelFilterActionCreator() {
        }

        @Override
        public Action execute(Object ... s) {
            ModelFilterPatternSetup modelFilterPatternSetup = (ModelFilterPatternSetup)s[1];
            return new SetParcelFilterPatternRendererAction((BaseLayerEditorPanel)s[0], modelFilterPatternSetup == null ? null : (ParcelFilterPatternSetupModel)modelFilterPatternSetup.getAttachedObject());
        }
    }
}

