/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.menu;

import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.gui.menu.BaseLayerEditorPanelMenuBar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class BaseLayerEditorPanelMenuBarComboBoxAdapter
extends BaseLayerEditorPanelMenuBar {
    private static final long serialVersionUID = -6683707616864641759L;
    private JComboBox filterAreaPatternBox;
    private JComboBox filterSubscriptionPatternBox;
    private JComboBox filterPoiPatternBox;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public BaseLayerEditorPanelMenuBarComboBoxAdapter(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(baseLayerEditorPanel);
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.filterAreaPatternBox = new JComboBox(new DefaultComboBoxModel());
        this.filterSubscriptionPatternBox = new JComboBox(new DefaultComboBoxModel());
        this.filterPoiPatternBox = new JComboBox(new DefaultComboBoxModel());
        this.refresh();
        this.filterAreaPatternBox.addActionListener(new PatternActionListener(this.filterAreaPatternBox));
        this.filterSubscriptionPatternBox.addActionListener(new PatternActionListener(this.filterSubscriptionPatternBox));
        this.filterPoiPatternBox.addActionListener(new PatternActionListener(this.filterPoiPatternBox));
    }

    private void refresh() {
        this.refresh(this.filterAreaPatternBox, this.getFilterAreaPatternMenu(this.baseLayerEditorPanel.getEditBaseLayer()));
        this.refresh(this.filterSubscriptionPatternBox, this.getFilterSubscriptionPatternMenu());
        this.refresh(this.filterPoiPatternBox, this.getFilterPoiPatternMenu());
    }

    private void refresh(JComboBox filterPatternBox, JMenu filterPatternMenu) {
        DefaultComboBoxModel dcm = (DefaultComboBoxModel)filterPatternBox.getModel();
        dcm.removeAllElements();
        ComboBoxItem selected = null;
        int itemCount = filterPatternMenu.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            JMenuItem item = filterPatternMenu.getItem(i);
            if (!(item instanceof JRadioButtonMenuItem)) continue;
            ComboBoxItem comboBoxItem = new ComboBoxItem(item);
            dcm.addElement(comboBoxItem);
            if (!item.isSelected()) continue;
            selected = comboBoxItem;
        }
        if (selected != null) {
            filterPatternBox.setSelectedItem(selected);
        }
    }

    @Override
    public void refreshAreaFilterPatternMenu() {
        super.refreshAreaFilterPatternMenu();
        this.refresh();
    }

    @Override
    public void refreshSubscriptionFilterPatternMenu() {
        super.refreshSubscriptionFilterPatternMenu();
        this.refresh();
    }

    @Override
    public void refreshPoiFilterPatternMenu() {
        super.refreshPoiFilterPatternMenu();
        this.refresh();
    }

    public JComboBox getFilterAreaPatternBox() {
        return this.filterAreaPatternBox;
    }

    public JComboBox getFilterSubscriptionPatternBox() {
        return this.filterSubscriptionPatternBox;
    }

    public JComboBox getFilterPoiPatternBox() {
        return this.filterPoiPatternBox;
    }

    private class ComboBoxItem {
        private JMenuItem radioButtonMenuItem;

        public ComboBoxItem(JMenuItem radioButtonMenuItem) {
            this.radioButtonMenuItem = radioButtonMenuItem;
        }

        public String toString() {
            return this.radioButtonMenuItem.getAction().getValue("Name").toString();
        }

        public JMenuItem getRadioButtonMenuItem() {
            return this.radioButtonMenuItem;
        }
    }

    private class PatternActionListener
    implements ActionListener {
        private JComboBox comboBox;

        public PatternActionListener(JComboBox comboBox) {
            this.comboBox = comboBox;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComboBoxItem item = (ComboBoxItem)this.comboBox.getSelectedItem();
            if (item != null) {
                JMenuItem radioButtonMenuItem = item.getRadioButtonMenuItem();
                radioButtonMenuItem.getAction().actionPerformed(null);
                radioButtonMenuItem.setSelected(true);
            }
        }
    }
}

