/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.legend;

import de.datomino.peppergis.client.gui.filter.pattern.legend.AreaFilterPatternLegendDialog;
import de.datomino.peppergis.client.gui.filter.pattern.legend.listener.PatterLegendSelectionEvent;
import de.datomino.peppergis.client.gui.filter.pattern.legend.listener.PatternLegendSelectionListener;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.filter.AreaFilterModel;
import de.datomino.peppergis.client.model.filter.AttributeValueFilterModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.ShowAreaLayerAction;
import de.datomino.peppergis.type.filter.ObjectFilter;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.swing.SwingUtils;
import java.awt.event.WindowEvent;
import java.util.Set;
import org.ktde.util.datatypes.Tripel;

public class BaseAreaAreaFilterPatternLegendDialog
extends AreaFilterPatternLegendDialog
implements PatternLegendSelectionListener<AreaFilterModel> {
    private static final long serialVersionUID = 4481955969311299896L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public BaseAreaAreaFilterPatternLegendDialog(BaseLayerEditorPanel baseLayerEditorPanel, AreaLayerModel layer) {
        super(SwingUtils.findWindowParent(baseLayerEditorPanel), layer, true, SwingUtils.findInternalFrameParent(baseLayerEditorPanel));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.updateSelectedFiltersList(this.getSelectedFiltersList());
        this.addPatternLegendSelectionListener(this);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.updateSelectedFiltersList(this.getAllInitiallySelectedFilters());
            AreaLayerModel areaLayerModel = this.getAreaLayerModel();
            if (this.baseLayerEditorPanel.getEditBaseLayer().equals(areaLayerModel)) {
                this.baseLayerEditorPanel.getEditBaseLayerRenderer().clearFilterVisibility();
            } else {
                Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>> tripel = this.baseLayerEditorPanel.getShowLayerActions().get(areaLayerModel);
                tripel.getElement2().clearFilterVisibility();
            }
            this.baseLayerEditorPanel.getMenuBar().areaFilterLegendDialogClosing(areaLayerModel);
            this.baseLayerEditorPanel.removeAreaFilterPatternLegendDialog(areaLayerModel);
        }
        super.processWindowEvent(e);
    }

    protected void updateSelectedFiltersList(Set<AreaFilterModel> selectedFilters) {
        this.baseLayerEditorPanel.setSelectedFiltersList(selectedFilters);
    }

    @Override
    public void defaultSelectionChanged(PatterLegendSelectionEvent<AreaFilterModel> event) {
        AreaLayerModel areaLayerModel = this.getAreaLayerModel();
        Boolean selected = event.isSelected();
        if (this.baseLayerEditorPanel.getEditBaseLayer().equals(areaLayerModel)) {
            this.baseLayerEditorPanel.getEditBaseLayerRenderer().setShowFilterDefault(selected);
        } else {
            Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>> tripel = this.baseLayerEditorPanel.getShowLayerActions().get(areaLayerModel);
            tripel.getElement2().setShowFilterDefault(selected);
        }
        this.updateSelectedFiltersList(this.getSelectedFiltersList());
    }

    @Override
    public void filterSelectionChanged(PatterLegendSelectionEvent<AreaFilterModel> event) {
        AreaLayerModel areaLayerModel = this.getAreaLayerModel();
        ObjectFilter<AreaFilterModel, AttributeValueFilterModel> objectFilter = event.getObjectFilter();
        Boolean selected = event.isSelected();
        if (this.baseLayerEditorPanel.getEditBaseLayer().equals(areaLayerModel)) {
            this.baseLayerEditorPanel.getEditBaseLayerRenderer().setShowFilter(objectFilter, selected);
        } else {
            Tripel<ShowAreaLayerAction, AreaLayerRenderer, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>> tripel = this.baseLayerEditorPanel.getShowLayerActions().get(areaLayerModel);
            tripel.getElement2().setShowFilter(objectFilter, selected);
        }
        this.updateSelectedFiltersList(this.getSelectedFiltersList());
    }
}

