/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui.attribute;

import de.datomino.peppergis.client.gui.attribute.AbstractAttributeValuePane;
import de.datomino.peppergis.client.gui.subscription.SubscriptionAttributeValuePane;
import de.datomino.peppergis.client.gui.subscription.SubscriptionDialog;
import de.datomino.peppergis.client.gui.subscription.SubscriptionListCellRenderer;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.base.SubscriptionStaticChoiceAttributeValueModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.subscription.RemoveSubscriptionSelectionAction;
import de.datomino.peppergis.simplebasearea.gui.attribute.AbstractAttributeValueSumPane;
import de.datomino.peppergis.simplebasearea.gui.attribute.AbstractListBasedAttributeValueSumPane;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SwingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;

public class SubscriptionAttributeValueSumPane
extends AbstractListBasedAttributeValueSumPane<SubscriptionModel, SubscriptionAttributeValueModel, SubscriptionAttributeValueDescriptorModel, SubscriptionStaticChoiceAttributeValueModel> {
    private static final long serialVersionUID = 6173892805396227602L;
    private static final AbstractAttributeValueSumPane.SumCalculator<SubscriptionModel, SubscriptionAttributeValueDescriptorModel, SubscriptionStaticChoiceAttributeValueModel> VALUE_SUM_CALCULATOR = new AbstractAttributeValueSumPane.ValueSumCalculator<SubscriptionModel, SubscriptionAttributeValueDescriptorModel, SubscriptionStaticChoiceAttributeValueModel>(){

        @Override
        protected Integer getIntValue(SubscriptionModel t, SubscriptionAttributeValueDescriptorModel u) {
            Integer values = 0;
            Iterator<SubscriptionAttributeValueModel> valueIter = t.iterateSubscriptionAttributeValues();
            while (valueIter.hasNext()) {
                Integer integerValue;
                SubscriptionAttributeValueModel value = valueIter.next();
                if (!value.getSubscriptionAttributeValueDescriptor().equals(u) || (integerValue = value.getIntegerValue()) == null) continue;
                values = values + integerValue;
            }
            return values;
        }

        @Override
        protected Double getDoubleValue(SubscriptionModel t, SubscriptionAttributeValueDescriptorModel u) {
            Double values = 0.0;
            Iterator<SubscriptionAttributeValueModel> valueIter = t.iterateSubscriptionAttributeValues();
            while (valueIter.hasNext()) {
                Double doubleValue;
                SubscriptionAttributeValueModel value = valueIter.next();
                if (!value.getSubscriptionAttributeValueDescriptor().equals(u) || (doubleValue = value.getFloatValue()) == null) continue;
                values = values + doubleValue;
            }
            return values;
        }
    };

    public SubscriptionAttributeValueSumPane(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(baseLayerEditorPanel, "messages.subscriptions.sum.selectedSubscriptions", "subscription.attributes.aggregate.sum");
    }

    @Override
    protected AbstractAttributeValuePane<SubscriptionModel, SubscriptionAttributeValueModel, SubscriptionAttributeValueDescriptorModel, SubscriptionStaticChoiceAttributeValueModel> getValuePane(String aggregate) {
        HashSet atrributesForSum = aggregate == null ? new HashSet() : CollectionUtil.buildHashSet(aggregate.replaceAll(" ", "").split(","));
        Collection<SubscriptionAttributeValueDescriptorModel> descriptorModels = this.getBaseLayerEditorPanel().getModelEnviroment().getAllCaller().getSubscriptionCaller().getAllSubscriptionAttributeValueDescriptors();
        ArrayList<SubscriptionAttributeValueDescriptorModel> descriptors = new ArrayList<SubscriptionAttributeValueDescriptorModel>();
        for (SubscriptionAttributeValueDescriptorModel descriptor : descriptorModels) {
            AttributeValueType attributeValueType = descriptor.getAttributeValueType();
            if (attributeValueType != AttributeValueType.INTEGER && attributeValueType != AttributeValueType.FLOAT || !atrributesForSum.contains(descriptor.getKey())) continue;
            descriptors.add(descriptor);
        }
        return new SubscriptionAttributeValuePane(descriptors, this.getBaseLayerEditorPanel().getModelEnviroment(), false){
            private static final long serialVersionUID = -5741664133497720016L;

            @Override
            public void clearValues(AbstractAttributeValuePane.ComponentType componentType) {
                SubscriptionAttributeValueSumPane.this.clear();
                super.clearValues(componentType);
            }
        };
    }

    @Override
    protected AbstractAttributeValueSumPane.SumCalculator<SubscriptionModel, SubscriptionAttributeValueDescriptorModel, SubscriptionStaticChoiceAttributeValueModel> getValueSumCalculator() {
        return VALUE_SUM_CALCULATOR;
    }

    @Override
    public void loadValues(Collection<SubscriptionModel> ts) {
        if (ts == null) {
            return;
        }
        DefaultListModel listModel = this.getListModel();
        listModel.clear();
        for (SubscriptionModel subscription : ts) {
            listModel.addElement(subscription);
        }
        super.loadValues(ts);
    }

    @Override
    protected ListCellRenderer createListRenderer() {
        SubscriptionListCellRenderer renderer = new SubscriptionListCellRenderer();
        renderer.setWithIndex(true);
        return renderer;
    }

    @Override
    protected Action[] getPopupActions(Collection<Object> selected) {
        if (!selected.isEmpty()) {
            ArrayList<SubscriptionModel> subscriptions = new ArrayList<SubscriptionModel>(selected.size());
            for (Object object : selected) {
                if (!(object instanceof SubscriptionModel)) continue;
                SubscriptionModel subscriptionModel = (SubscriptionModel)object;
                subscriptions.add(subscriptionModel);
            }
            if (!subscriptions.isEmpty()) {
                return new Action[]{new RemoveSubscriptionSelectionAction(this.getBaseLayerEditorPanel(), subscriptions)};
            }
        }
        return new Action[0];
    }

    @Override
    protected void showDialogForModel(Object selected) {
        if (selected instanceof SubscriptionModel) {
            SubscriptionModel subscriptionModel = (SubscriptionModel)selected;
            BaseLayerEditorPanel baseLayerEditorPanel = this.getBaseLayerEditorPanel();
            SubscriptionDialog subscriptionDialog = new SubscriptionDialog(SwingUtils.findWindowParent(baseLayerEditorPanel), Collections.singletonList(subscriptionModel), baseLayerEditorPanel.getModelEnviroment());
            subscriptionDialog.setInternalFrame(this.getBaseLayerEditorPanel().getInternalFrame());
            subscriptionDialog.setVisible(true);
        }
    }
}

