/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui;

import de.datomino.peppergis.client.gui.attribute.AttributeDescriptorComboBox;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.util.wrapper.area.attribute.AreaAttributeValueDescriptorModelAttributeWrapper;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import org.ktde.math.projection.Coordinate;

public class CircleSearchPane
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -857281972577138147L;
    private JPanel sPanel1;
    private JPanel sPanel2;
    private JPanel sPanel3;
    private JRadioButton plainCircle;
    private JRadioButton attributeCircle;
    private JRadioButton drivingDistanceTimeCircle;
    private JRadioButton foot;
    private JRadioButton car;
    private JRadioButton bike;
    private JRadioButton distance;
    private JRadioButton time;
    private JSpinner distanceTimeValueSpinner;
    private JSpinner attributeLimitSpinner;
    private JSpinner radiusSpinner;
    private JCheckBox includedCheckBox;
    private AttributeDescriptorComboBox<AreaAttributeValueDescriptorModel> descriptorComboBox;
    private int circleSearchOption;
    private static int PROP_PLAIN_CIRCLE = 1;
    private static int PROP_ATTRIBUTE_AGGREGATION = 2;
    private static int PROP_DISTANCE_TIME = 3;

    public CircleSearchPane(ModelEnviroment modelEnviroment, Coordinate coord) {
        super(new BorderLayout());
        ButtonGroup mainBG = new ButtonGroup();
        JPanel pPanel = new JPanel(new SpringLayout());
        this.plainCircle = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.plainCircle", new Serializable[0]));
        this.plainCircle.setVerticalAlignment(1);
        this.plainCircle.addActionListener(this);
        JPanel nPanel = new JPanel(new BorderLayout());
        nPanel.add((Component)this.plainCircle, "North");
        pPanel.add(nPanel);
        mainBG.add(this.plainCircle);
        this.sPanel1 = new JPanel();
        this.sPanel1.setLayout(new SpringLayout());
        JPanel sPanel1Part1 = new JPanel();
        sPanel1Part1.setLayout(new SpringLayout());
        SpinnerNumberModel snm = new SpinnerNumberModel(new Integer(1), new Integer(0), null, new Integer(1));
        this.radiusSpinner = new JSpinner(snm);
        sPanel1Part1.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.radiusSpinner", new Serializable[0])));
        sPanel1Part1.add(this.radiusSpinner);
        SpringUtilities.makeCompactGrid(sPanel1Part1, 1, 2, 2, 5, 2, 2);
        this.sPanel1.add(sPanel1Part1);
        this.includedCheckBox = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.included", new Serializable[0]));
        this.includedCheckBox.setSelected(false);
        this.sPanel1.add(this.includedCheckBox);
        SpringUtilities.makeCompactGrid(this.sPanel1, 2, 1, 2, 5, 2, 2);
        pPanel.add(this.sPanel1);
        this.attributeCircle = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.attributeAggregation", new Serializable[0]));
        this.attributeCircle.setVerticalAlignment(1);
        this.attributeCircle.addActionListener(this);
        nPanel = new JPanel(new BorderLayout());
        nPanel.add((Component)this.attributeCircle, "North");
        pPanel.add(nPanel);
        mainBG.add(this.attributeCircle);
        this.sPanel2 = new JPanel(new SpringLayout());
        this.sPanel2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.attributeDescriptor", new Serializable[0])));
        Collection<AreaAttributeValueDescriptorModel> allAreaAttributeValueDescriptors = modelEnviroment.getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
        LinkedList<AreaAttributeValueDescriptorModelAttributeWrapper> list = new LinkedList<AreaAttributeValueDescriptorModelAttributeWrapper>();
        for (AreaAttributeValueDescriptorModel areaAttributeValueDescriptorModel : allAreaAttributeValueDescriptors) {
            AttributeValueType attributeValueType = areaAttributeValueDescriptorModel.getAttributeValueType();
            if (attributeValueType != AttributeValueType.INTEGER && attributeValueType != AttributeValueType.FLOAT) continue;
            list.add(new AreaAttributeValueDescriptorModelAttributeWrapper(areaAttributeValueDescriptorModel));
        }
        this.descriptorComboBox = new AttributeDescriptorComboBox(list);
        this.sPanel2.add(this.descriptorComboBox);
        SpinnerNumberModel snm1 = new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1));
        this.attributeLimitSpinner = new JSpinner(snm1);
        this.sPanel2.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.attributeValueLimit", new Serializable[0])));
        this.sPanel2.add(this.attributeLimitSpinner);
        SpringUtilities.makeCompactGrid(this.sPanel2, 2, 2, 2, 5, 2, 2);
        pPanel.add(this.sPanel2);
        this.drivingDistanceTimeCircle = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.distanceTimeCircle", new Serializable[0]));
        this.drivingDistanceTimeCircle.setVerticalAlignment(1);
        this.drivingDistanceTimeCircle.addActionListener(this);
        nPanel = new JPanel(new BorderLayout());
        nPanel.add((Component)this.drivingDistanceTimeCircle, "North");
        pPanel.add(nPanel);
        mainBG.add(this.drivingDistanceTimeCircle);
        ButtonGroup footCarBG = new ButtonGroup();
        ButtonGroup distanceTimeBG = new ButtonGroup();
        this.sPanel3 = new JPanel(new SpringLayout());
        this.foot = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.foot", new Serializable[0]));
        this.sPanel3.add(this.foot);
        footCarBG.add(this.foot);
        this.distance = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.distance", new Serializable[0]));
        this.sPanel3.add(this.distance);
        distanceTimeBG.add(this.distance);
        this.car = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.car", new Serializable[0]));
        this.sPanel3.add(this.car);
        footCarBG.add(this.car);
        this.time = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.time", new Serializable[0]));
        this.sPanel3.add(this.time);
        distanceTimeBG.add(this.time);
        this.bike = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.bike", new Serializable[0]));
        this.sPanel3.add(this.bike);
        footCarBG.add(this.bike);
        this.sPanel3.add(new JLabel());
        SpinnerNumberModel snm2 = new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1));
        this.distanceTimeValueSpinner = new JSpinner(snm2);
        this.sPanel3.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.circle.distanceOrTimeValue", new Serializable[0])));
        this.sPanel3.add(this.distanceTimeValueSpinner);
        SpringUtilities.makeCompactGrid(this.sPanel3, 4, 2, 2, 5, 2, 2);
        pPanel.add(this.sPanel3);
        SpringUtilities.makeCompactGrid(pPanel, 3, 2, 2, 5, 3, 7);
        this.add((Component)pPanel, "North");
        this.plainCircle.setSelected(true);
        this.foot.setSelected(true);
        this.distance.setSelected(true);
        this.circleSearchOption = PROP_PLAIN_CIRCLE;
        JPanel[] pList = new JPanel[]{this.sPanel2, this.sPanel3};
        this.disableEnablePanelWidgets(pList, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.plainCircle) {
            JPanel[] disablePanelList = new JPanel[]{this.sPanel2, this.sPanel3};
            this.disableEnablePanelWidgets(disablePanelList, false);
            JPanel[] enablePanelList = new JPanel[]{this.sPanel1};
            this.disableEnablePanelWidgets(enablePanelList, true);
            this.setCircleSearchOption(PROP_PLAIN_CIRCLE);
        } else if (source == this.attributeCircle) {
            JPanel[] disablePanelList = new JPanel[]{this.sPanel1, this.sPanel3};
            this.disableEnablePanelWidgets(disablePanelList, false);
            JPanel[] enablePanelList = new JPanel[]{this.sPanel2};
            this.disableEnablePanelWidgets(enablePanelList, true);
            this.setCircleSearchOption(PROP_ATTRIBUTE_AGGREGATION);
        } else if (source == this.drivingDistanceTimeCircle) {
            JPanel[] disablePanelList = new JPanel[]{this.sPanel1, this.sPanel2};
            this.disableEnablePanelWidgets(disablePanelList, false);
            JPanel[] enablePanelList = new JPanel[]{this.sPanel3};
            this.disableEnablePanelWidgets(enablePanelList, true);
            this.setCircleSearchOption(PROP_DISTANCE_TIME);
        }
    }

    private void disableEnablePanelWidgets(JPanel[] panelList, boolean enable) {
        for (JPanel panel : panelList) {
            for (Component widget : panel.getComponents()) {
                if (widget instanceof JPanel) {
                    JPanel[] tempList = new JPanel[]{(JPanel)widget};
                    this.disableEnablePanelWidgets(tempList, enable);
                    continue;
                }
                widget.setEnabled(enable);
            }
        }
    }

    public int getCircleSearchOption() {
        return this.circleSearchOption;
    }

    public void setCircleSearchOption(int circleSearchOption) {
        this.circleSearchOption = circleSearchOption;
    }

    public boolean isIncluded() {
        return this.includedCheckBox.isSelected();
    }

    public int getRadius() {
        return (Integer)this.radiusSpinner.getValue();
    }

    public AreaAttributeValueDescriptorModel getDescriptor() {
        return this.descriptorComboBox.getSelectedDescriptor();
    }

    public int getAttributeLimit() {
        return (Integer)this.attributeLimitSpinner.getValue();
    }

    public boolean isFoot() {
        return this.foot.isSelected();
    }

    public boolean isCar() {
        return this.car.isSelected();
    }

    public boolean isBike() {
        return this.bike.isSelected();
    }

    public boolean isDistance() {
        return this.distance.isSelected();
    }

    public boolean isTime() {
        return this.time.isSelected();
    }

    public int getDistanceOrTimeValue() {
        return (Integer)this.distanceTimeValueSpinner.getValue();
    }
}

