/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.gui;

import de.datomino.peppergis.client.gui.area.AreaObjectChooserTableModel;
import de.datomino.peppergis.client.gui.area.DefaultAreaObjectChooserPane;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.UndoManager;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.exception.ValidateException;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class AreaObjectChooserPane
extends DefaultAreaObjectChooserPane {
    public static final String AREA_SELECT_CENTER_KEY = "area.select.center";
    private static final long serialVersionUID = 2221597521682133170L;
    private JCheckBox center;
    private boolean duplicateAreasActive;

    public AreaObjectChooserPane(AreaLayerModel areaLayerModel, ModelEnviroment modelEnviroment, boolean duplicateAreasActive) {
        super(areaLayerModel, modelEnviroment);
        this.duplicateAreasActive = duplicateAreasActive;
        this.setAreaLayerModel(areaLayerModel);
    }

    @Override
    protected JPanel createSouthPanel(boolean copyAndPasteWindow) {
        JPanel panel = new JPanel(new BorderLayout());
        boolean isGenArea = this.areaLayerModel.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT;
        this.center = new JCheckBox(ModelEnviroment.getMessageResolver().resolveMessage(isGenArea ? "messages.area.centerAreaObjects.order" : "messages.area.centerAreaObjects", new Serializable[0]), StringUtil.isTrue(ModelEnviroment.getProperties().getProperty(AREA_SELECT_CENTER_KEY)));
        panel.add((Component)this.center, "West");
        JPanel panel2 = new JPanel(new FlowLayout());
        panel2.add(new JButton(new DefaultAreaObjectChooserPane.InsertFromClipboardAction(this)));
        if (this.duplicateAreasActive) {
            panel2.add((Component)new JButton(new DuplicateAreasAction()), "East");
        }
        panel.add((Component)panel2, "East");
        return panel;
    }

    public boolean isCenterAreas() {
        return this.center.isSelected();
    }

    private class DuplicateAreasAction
    extends AbstractAction {
        private static final long serialVersionUID = 5451265781118031886L;

        public DuplicateAreasAction() {
            super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.duplicate", new Serializable[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Set<Long> selectedIds = ((AreaObjectChooserTableModel)AreaObjectChooserPane.this.areaList.getModel()).getSelectedIds();
            Collection<AreaObjectModel> areas = AreaObjectChooserPane.this.modelEnviroment.getAllCaller().getAreaCaller().fetchAreaObjectsById(selectedIds);
            areas = new ArrayList<AreaObjectModel>(areas);
            ArrayList<Tupel<String, String>> newNames = new ArrayList<Tupel<String, String>>();
            for (AreaObjectModel areaObject : areas) {
                Tupel<String, String> names = this.getNames(areaObject);
                if (names == null) {
                    return;
                }
                String shortcut = names.getElement1();
                String display = names.getElement2();
                if (shortcut != null && display != null) {
                    newNames.add(names);
                    continue;
                }
                newNames.add(null);
            }
            UndoManager undoManager = AreaObjectChooserPane.this.modelEnviroment.getUndoManager();
            undoManager.startTransaction();
            Iterator iter = newNames.iterator();
            ArrayList<AreaObjectModel> newAreas = new ArrayList<AreaObjectModel>(areas.size());
            for (AreaObjectModel areaObject : areas) {
                Tupel names = (Tupel)iter.next();
                if (names == null) continue;
                AreaObjectModel newArea = AreaObjectModelUtil.cloneAreaObject(areaObject);
                newArea.setAreaLayer(AreaObjectChooserPane.this.areaLayerModel);
                newArea.setShortcut((String)names.getElement1());
                newArea.setDisplayname((String)names.getElement2());
                newAreas.add(newArea);
            }
            undoManager.finishTransaction("");
            try {
                undoManager.storeTransactions();
            }
            catch (ValidateException ex) {
                throw new RuntimeException(ex);
            }
            ArrayList<Tripel<Long, String, String>> tripels = new ArrayList<Tripel<Long, String, String>>(newAreas.size());
            for (AreaObjectModel newArea : newAreas) {
                tripels.add(new Tripel<Long, String, String>(newArea.getId(), newArea.getShortcut(), newArea.getDisplayname()));
            }
            ((AreaObjectChooserTableModel)AreaObjectChooserPane.this.areaList.getModel()).insertElements(tripels);
        }

        private Tupel<String, String> getNames(AreaObjectModel areaObject) {
            Window parent = SwingUtils.findWindowParent(AreaObjectChooserPane.this);
            JPanel panel = new JPanel(new SpringLayout());
            String messageKey = areaObject.getAreaLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.shortcut.order" : "messages.area.shortcut";
            panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage(messageKey, new Serializable[0])));
            JTextField shortcut = new JTextField(20);
            panel.add(shortcut);
            panel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.displayName", new Serializable[0])));
            JTextField display = new JTextField(20);
            display.setText(areaObject.getDisplayname());
            panel.add(display);
            SpringUtilities.makeCompactGrid(panel, 2, 2, 5, 5, 2, 2);
            block5: while (true) {
                int d = JOptionPane.showConfirmDialog(parent, panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.duplicate.insertNewNames", new Serializable[]{areaObject.getShortcut(), areaObject.getDisplayname()}), 1, 3);
                switch (d) {
                    case 2: {
                        return null;
                    }
                    case 1: {
                        return new Tupel<Object, Object>(null, null);
                    }
                    case 0: {
                        String areaKey = shortcut.getText().trim();
                        if (StringUtil.isBlank(areaKey)) {
                            JOptionPane.showMessageDialog(parent, "Schl\u00fcssel darf nicht leer sein", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                            continue block5;
                        }
                        if ((areaKey = areaKey.trim()).matches(".*\\s.*") || areaKey.matches(".*%.*")) {
                            JOptionPane.showMessageDialog(parent, "Schl\u00fcssel " + areaKey + " enth\u00e4lt ung\u00fcltige Zeichen", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                            continue block5;
                        }
                        Map<Long, Tripel<String, String, Boolean>> all = ((AreaObjectChooserTableModel)AreaObjectChooserPane.this.areaList.getModel()).getAll();
                        for (Tripel<String, String, Boolean> tripel : all.values()) {
                            String eShortcut = tripel.getElement1();
                            if (!eShortcut.equals(areaKey)) continue;
                            JOptionPane.showMessageDialog(parent, "Schl\u00fcssel " + areaKey + " existiert bereits", ModelEnviroment.getMessageResolver().resolveMessage("messages.default.error", new Serializable[0]), 0);
                            continue block5;
                        }
                        return new Tupel<String, String>(areaKey, display.getText());
                    }
                }
            }
        }
    }
}

