/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.subscription;

import de.datomino.peppergis.client.gui.common.CommonDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.util.SubscriptionModelUtil;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.gui.search.SubscriptionSearchPane;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class SubscriptionSearchAction
extends AbstractAction {
    private static final long serialVersionUID = -8127320114015883999L;
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private ModelEnviroment modelEnviroment;

    public SubscriptionSearchAction(BaseLayerEditorPanel baseLayerEditorPanel, ModelEnviroment modelEnvironment) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.modelEnviroment = modelEnvironment;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final SubscriptionSearchPane subscriptionSearchPane = new SubscriptionSearchPane(this.modelEnviroment, this.baseLayerEditorPanel);
        CommonDialog subSearchDialog = new CommonDialog(this.baseLayerEditorPanel.getParentWindow(), ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.search", new Serializable[0]), null){
            private static final long serialVersionUID = -3661624213929148588L;

            @Override
            protected Action getOkAction() {
                return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.ok", new Serializable[0])){
                    private static final long serialVersionUID = 8001289613741121390L;

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        ImmutablePoint subscriptionGeom;
                        SubscriptionModel subscriptionModelObj = subscriptionSearchPane.getSelectedSubscription();
                        if (subscriptionModelObj != null && (subscriptionGeom = SubscriptionModelUtil.getGeom(subscriptionModelObj)) != null) {
                            SubscriptionSearchAction.this.baseLayerEditorPanel.getNavigatorPanel().center(subscriptionGeom.getCoordinate());
                        }
                        this.dispose();
                    }
                };
            }

            @Override
            protected Component getMainComponent() {
                return subscriptionSearchPane;
            }

            @Override
            protected Action getCancelAction() {
                return new AbstractAction(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.cancel", new Serializable[0])){
                    private static final long serialVersionUID = 7386658925101183668L;

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        this.dispose();
                    }
                };
            }
        };
        subSearchDialog.buildLayout();
        subSearchDialog.pack();
        SwingUtils.center((Window)subSearchDialog, this.baseLayerEditorPanel.getParentWindow());
        subSearchDialog.setVisible(true);
    }
}

