/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.sourcearea;

import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.swing.FreeHandMarkerNavigatorRenderer;
import de.datomino.util.geo.swing.ObjectMarkerNavigatorRenderer;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.ktde.swing.navigator.NavigatorPanel;

public class SourceAreaMarkerActionNavigatorRenderer
extends ObjectMarkerNavigatorRenderer<AreaObjectModel, ImmutablePolygonKind> {
    private static final long serialVersionUID = 5710546318934788642L;
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private AreaLayerModel areaLayer;
    private AreaLayerRenderer areaLayerRenderer;
    private boolean on = false;

    public SourceAreaMarkerActionNavigatorRenderer(String name, NavigatorPanel navigatorPanel, AreaLayerRenderer objectRenderer, Double maxUpp, String title, GeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel, Collection<AreaObjectModel> markedObjects, BaseLayerEditorPanel baseLayerEditorPanel, AreaLayerModel areaLayer) {
        super(name, navigatorPanel, objectRenderer, maxUpp, title, bucketsModel, markedObjects);
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.areaLayer = areaLayer;
        this.areaLayerRenderer = objectRenderer;
    }

    @Override
    protected void turnedOff() {
        super.turnedOff();
        this.areaLayerRenderer.setActive(false);
        this.baseLayerEditorPanel.getEditBaseLayerRenderer().removeAllowedAreaLayer(this.areaLayer);
        this.on = false;
    }

    @Override
    protected void turnedOn() {
        super.turnedOn();
        this.areaLayerRenderer.setActive(true);
        this.baseLayerEditorPanel.getEditBaseLayerRenderer().addAllowedAreaLayer(this.areaLayer);
        this.on = true;
    }

    @Override
    public void prepare(Point2D.Double realBoundaryBottomLeft, Point2D.Double realBoundaryTopRight, double upp) {
        super.prepare(realBoundaryBottomLeft, realBoundaryTopRight, upp);
    }

    @Override
    protected Color getMarkColor() {
        return FreeHandMarkerNavigatorRenderer.getMarkColor();
    }

    @Override
    protected void markedObjectsChanged() {
        super.markedObjectsChanged();
        this.baseLayerEditorPanel.updateMarkSets();
    }

    @Override
    protected double getClickedRadius() {
        return 0.0;
    }

    public AreaLayerModel getAreaLayer() {
        return this.areaLayer;
    }

    public boolean isOn() {
        return this.on;
    }
}

