/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.parcel;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.SegmentModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.util.geo.ImmutableLineString;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygon;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.exception.IllegalPointCountException;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.util.GeoUtils;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SpringLayout;
import org.ktde.util.datatypes.Tupel;

public class ConvexHullCalculation {
    public static boolean calculateConvexHull(Collection<AreaObjectModel> selectedObjects, BaseLayerEditorPanel baseLayerEditorPanel) {
        Tupel<Boolean, Boolean> tupel = ConvexHullCalculation.getIncludingMode(baseLayerEditorPanel);
        if (tupel != null) {
            boolean includeSegment = tupel.getElement2();
            if (selectedObjects != null && !selectedObjects.isEmpty()) {
                HashMap<AreaObjectModel, Object> map = new HashMap<AreaObjectModel, Object>();
                for (AreaObjectModel areaObjectModel : selectedObjects) {
                    ArrayList pointList = new ArrayList(areaObjectModel.countAreaObjectParcelRel());
                    for (AreaObjectParcelRelModel areaObjectParcelRelModel : areaObjectModel.iterableAreaObjectParcelRel()) {
                        ImmutablePoint point;
                        ParcelModel parcel = areaObjectParcelRelModel.getParcel();
                        if (parcel == null || (point = parcel.getGeom()) == null) continue;
                        pointList.add(point);
                        if (!includeSegment) continue;
                        ImmutablePoint basePoint = ConvexHullCalculation.getBasePoint(parcel.getMotorSegment(), point, baseLayerEditorPanel);
                        if (basePoint != null) {
                            pointList.add(basePoint);
                        }
                        if ((basePoint = ConvexHullCalculation.getBasePoint(parcel.getFootSegment(), point, baseLayerEditorPanel)) != null) {
                            pointList.add(basePoint);
                        }
                        if ((basePoint = ConvexHullCalculation.getBasePoint(parcel.getBikeSegment(), point, baseLayerEditorPanel)) == null) continue;
                        pointList.add(basePoint);
                    }
                    map.put(areaObjectModel, pointList);
                }
                HashMap<AreaObjectModel, ImmutablePolygon> result = new HashMap<AreaObjectModel, ImmutablePolygon>();
                HashSet<AreaObjectModel> nullPolygons = new HashSet<AreaObjectModel>();
                for (Map.Entry entry : map.entrySet()) {
                    Object var9_15 = null;
                    AreaObjectModel area = (AreaObjectModel)entry.getKey();
                    try {
                        ImmutablePolygon immutablePolygon = GeoUtils.getConvexHull((Collection)entry.getValue());
                        result.put(area, immutablePolygon);
                    }
                    catch (IllegalPointCountException e) {
                        nullPolygons.add(area);
                    }
                }
                GeoObjectBucketsModel bucketsModel = baseLayerEditorPanel.getEditBaseLayerRenderer().getBucketsModel();
                for (Map.Entry entry : result.entrySet()) {
                    AreaObjectModel areaObjectModel = (AreaObjectModel)entry.getKey();
                    areaObjectModel.setGeom((ImmutablePolygonKind)entry.getValue());
                    bucketsModel.remove(areaObjectModel);
                    bucketsModel.addGeom(areaObjectModel);
                }
                for (AreaObjectModel areaObjectModel : nullPolygons) {
                    areaObjectModel.setGeom(null);
                    bucketsModel.remove(areaObjectModel);
                    bucketsModel.addGeom(areaObjectModel);
                }
                return true;
            }
        }
        return false;
    }

    private static ImmutablePoint getBasePoint(SegmentModel segment, ImmutablePoint point, BaseLayerEditorPanel baseLayerEditorPanel) {
        if (segment != null) {
            ImmutableLineString geom = segment.getGeom();
            if (geom != null) {
                return geom.getBasePoint(point, null);
            }
            baseLayerEditorPanel.getModelEnviroment().getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.areasCreatedByConvexHull", new Serializable[0]));
        }
        return null;
    }

    private static Tupel<Boolean, Boolean> getIncludingMode(BaseLayerEditorPanel baseLayerEditorPanel) {
        JRadioButton includeLogical = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.createAreaByConvexHull.includeLogical", new Serializable[0]), true);
        JRadioButton includeSegment = new JRadioButton(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.createAreaByConvexHull.includeSegment", new Serializable[0]));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(includeLogical);
        buttonGroup.add(includeSegment);
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(includeLogical);
        panel.add(includeSegment);
        SpringUtilities.makeCompactGrid(panel, 2, 1, 5, 5, 5, 5);
        int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(baseLayerEditorPanel), panel, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.createAreaByConvexHull", new Serializable[0]), 0, 3);
        return d == 0 ? new Tupel<Boolean, Boolean>(includeLogical.isSelected(), includeSegment.isSelected()) : null;
    }
}

