/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.parcel;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.CityModel;
import de.datomino.peppergis.client.model.map.DistrictModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.model.map.PostcodeDistrictRelationModel;
import de.datomino.peppergis.client.model.map.PostcodeModel;
import de.datomino.peppergis.client.model.map.StreetModel;
import de.datomino.peppergis.client.util.LetterModelUtil;
import de.datomino.peppergis.client.util.model.parcel.ParcelLocationObject;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.parcel.ConvexHullCalculation;
import de.datomino.util.international.country.Country;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Quad;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractParcelMovingAction
extends AbstractAction {
    private static final long serialVersionUID = 1199787380042540310L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    protected AbstractParcelMovingAction(BaseLayerEditorPanel baseLayerEditorPanel, String actionName) {
        super(actionName);
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    protected BaseLayerEditorPanel getBaseLayerEditorPanel() {
        return this.baseLayerEditorPanel;
    }

    @Override
    public final void actionPerformed(ActionEvent e) {
        Collection<ParcelLocationObject> markedObjects = this.getBaseLayerEditorPanel().getParcelRenderer().getMarkedObjects();
        if (markedObjects != null && !markedObjects.isEmpty()) {
            this.getBaseLayerEditorPanel().getModelEnviroment().getUndoManager().startTransaction();
            Quad<AreaLayerModel, AreaObjectModel, Set<ParcelModel>, Collection<AreaObjectModel>> quad = this.moveParcels(markedObjects);
            boolean commit = this.moveObjects(quad.getElement1(), quad.getElement2(), quad.getElement3());
            if (commit) {
                this.createAreaGeom(quad.getElement4());
                this.getBaseLayerEditorPanel().getModelEnviroment().getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage(this.getFinishMessageKey(), new Serializable[0]));
            } else {
                this.getBaseLayerEditorPanel().getModelEnviroment().getUndoManager().rollbackTransaction();
            }
        }
    }

    private void createAreaGeom(Collection<AreaObjectModel> areaObjects) {
        String ask = ModelEnviroment.getProperties().getProperty("area.moveParcel.askForGeom");
        if (StringUtil.isBlank(ask) || StringUtil.isTrue(ask)) {
            ConvexHullCalculation.calculateConvexHull(areaObjects, this.baseLayerEditorPanel);
        }
    }

    protected abstract Quad<AreaLayerModel, AreaObjectModel, Set<ParcelModel>, Collection<AreaObjectModel>> moveParcels(Collection<ParcelLocationObject> var1);

    protected abstract String getFinishMessageKey();

    private boolean moveObjects(AreaLayerModel areaLayer, AreaObjectModel areaObjectModel, Set<ParcelModel> parcels) {
        ArrayList<SubscriptionModel> subList = new ArrayList<SubscriptionModel>(this.getBaseLayerEditorPanel().getModelEnviroment().getAllCaller().getBaseCaller().fetchSubscriptionsByParcels(parcels, areaLayer));
        ArrayList<LetterModel> letterList = new ArrayList<LetterModel>(this.getBaseLayerEditorPanel().getModelEnviroment().getAllCaller().getLetterCaller().fetchLettersByParcels(parcels, areaLayer));
        Tupel<JPanel, List<JCheckBox>> subscriptionPanel = this.createSubscriptionPanel(subList);
        Tupel<JPanel, List<JCheckBox>> letterPanel = this.createLetterPanel(letterList);
        if (subscriptionPanel == null && letterPanel == null) {
            return true;
        }
        boolean commit = true;
        JPanel mainPanel = new JPanel(new SpringLayout());
        int rowCount = 0;
        if (subscriptionPanel != null) {
            mainPanel.add(subscriptionPanel.getElement1());
            ++rowCount;
        }
        if (letterPanel != null) {
            mainPanel.add(letterPanel.getElement1());
            ++rowCount;
        }
        SpringUtilities.makeCompactGrid(mainPanel, 1, rowCount, 5, 5, 5, 5);
        int option = JOptionPane.showConfirmDialog(this.getBaseLayerEditorPanel(), mainPanel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 1, 3);
        switch (option) {
            case 0: {
                int index;
                if (subscriptionPanel != null) {
                    index = 0;
                    for (JCheckBox el : subscriptionPanel.getElement2()) {
                        if (el.isSelected()) {
                            ((SubscriptionModel)subList.get(index)).setAreaObject(areaObjectModel);
                        }
                        ++index;
                    }
                }
                if (letterPanel == null) break;
                index = 0;
                for (JCheckBox el : letterPanel.getElement2()) {
                    if (el.isSelected()) {
                        ((LetterModel)letterList.get(index)).setAreaObject(areaObjectModel);
                    }
                    ++index;
                }
                break;
            }
            case 1: {
                break;
            }
            default: {
                commit = false;
            }
        }
        return commit;
    }

    private Tupel<JPanel, List<JCheckBox>> createLetterPanel(List<LetterModel> letterList) {
        if (letterList.isEmpty()) {
            return null;
        }
        JPanel panel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(new SpringLayout());
        ArrayList<JCheckBox> cbList = new ArrayList<JCheckBox>(letterList.size());
        for (LetterModel el : letterList) {
            ParcelModel pm = el.getLocation().getParcel();
            StreetModel sm = pm.getStreet();
            PostcodeDistrictRelationModel postcodeDistrictRelation = sm.getPostcodeDistrictRelation();
            PostcodeModel postcode = postcodeDistrictRelation.getPostcode();
            DistrictModel district = postcodeDistrictRelation.getDistrict();
            CityModel city = district.getCity();
            Country country = postcode.getCountry();
            StringBuilder sb = new StringBuilder();
            sb.append(el.getLetterNumber());
            sb.append(", ");
            sb.append(LetterModelUtil.getName(el));
            sb.append(", ");
            sb.append(country.getVehicleSign());
            sb.append(" ");
            sb.append(postcode.getName());
            sb.append(" ");
            sb.append(city.getName());
            sb.append(" ");
            sb.append(district.getName());
            sb.append(" ");
            sb.append(sm.getName());
            sb.append(" ");
            sb.append(pm.getHouseNumber());
            sb.append(" ");
            sb.append(pm.getHouseNumberExtension());
            JCheckBox cb = new JCheckBox(sb.toString(), true);
            cbList.add(cb);
            innerPanel.add(cb);
        }
        SpringUtilities.makeCompactGrid(innerPanel, letterList.size(), 1, 5, 5, 2, 2);
        JScrollPane scroll = new JScrollPane(innerPanel);
        SwingUtils.setPreferredSizeToPercentageOfParent(scroll, SwingUtils.findInternalFrameParent(this.getBaseLayerEditorPanel()), null, 70.0);
        panel.add((Component)scroll, "Center");
        panel.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.parcelsToArea.moveLetters", new Serializable[0])), "North");
        return new Tupel<JPanel, List<JCheckBox>>(panel, cbList);
    }

    private Tupel<JPanel, List<JCheckBox>> createSubscriptionPanel(List<SubscriptionModel> subList) {
        if (subList.isEmpty()) {
            return null;
        }
        JPanel panel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel(new SpringLayout());
        ArrayList<JCheckBox> cbList = new ArrayList<JCheckBox>(subList.size());
        for (SubscriptionModel el : subList) {
            ParcelModel pm = el.getLocation().getParcel();
            StreetModel sm = pm.getStreet();
            PostcodeDistrictRelationModel postcodeDistrictRelation = sm.getPostcodeDistrictRelation();
            PostcodeModel postcode = postcodeDistrictRelation.getPostcode();
            DistrictModel district = postcodeDistrictRelation.getDistrict();
            CityModel city = district.getCity();
            Country country = postcode.getCountry();
            StringBuilder sb = new StringBuilder();
            sb.append(el.getSubscriptionNumber());
            sb.append(", ");
            sb.append(el.getCustomer().getCustomerNumber());
            sb.append(", ");
            sb.append(el.getCustomer().getName());
            sb.append(", ");
            sb.append(country.getVehicleSign());
            sb.append(" ");
            sb.append(postcode.getName());
            sb.append(" ");
            sb.append(city.getName());
            sb.append(" ");
            sb.append(district.getName());
            sb.append(" ");
            sb.append(sm.getName());
            sb.append(" ");
            sb.append(pm.getHouseNumber());
            sb.append(" ");
            sb.append(pm.getHouseNumberExtension());
            JCheckBox cb = new JCheckBox(sb.toString(), true);
            cbList.add(cb);
            innerPanel.add(cb);
        }
        SpringUtilities.makeCompactGrid(innerPanel, subList.size(), 1, 5, 5, 2, 2);
        JScrollPane scroll = new JScrollPane(innerPanel);
        SwingUtils.setPreferredSizeToPercentageOfParent(scroll, SwingUtils.findInternalFrameParent(this.getBaseLayerEditorPanel()), null, 70.0);
        panel.add((Component)scroll, "Center");
        panel.add((Component)new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.parcelsToArea.moveSubscriptions", new Serializable[0])), "North");
        return new Tupel<JPanel, List<JCheckBox>>(panel, cbList);
    }
}

