/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.letter;

import de.datomino.peppergis.client.gui.common.DatePicker;
import de.datomino.peppergis.client.gui.letter.LetterFilterableMarkerRenderer;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.util.geo.model.time.TimeRange;
import de.datomino.util.swing.SpringUtilities;
import de.datomino.util.swing.WidthUnifier;
import de.datomino.util.time.TimeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LetterShowObjectDateDialog
extends JDialog {
    private static final long serialVersionUID = 2939155998849455618L;
    private LetterFilterableMarkerRenderer letterFilterableMarkerRenderer;
    private DatePicker from;
    private DatePicker till;

    public LetterShowObjectDateDialog(Window parent, LetterFilterableMarkerRenderer renderer) {
        super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.letter.dateFilter", new Serializable[0]), null);
        this.letterFilterableMarkerRenderer = renderer;
        this.buildLayout();
        this.pack();
        this.setLocation(parent.getWidth() - this.getWidth(), 0);
        this.setAlwaysOnTop(true);
    }

    private void buildLayout() {
        try {
            this.setIconImage(ImageIO.read(LetterShowObjectDateDialog.class.getResourceAsStream("/images/pepper.png")));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        this.getContentPane().setLayout(new BorderLayout());
        WidthUnifier widthUnifier1 = new WidthUnifier();
        WidthUnifier widthUnifier2 = new WidthUnifier();
        JPanel panel = new JPanel(new SpringLayout());
        JLabel l = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.from", new Serializable[0]));
        panel.add(l);
        widthUnifier1.add(l);
        this.from = new DatePicker();
        panel.add(this.from);
        widthUnifier2.add(this.from);
        l = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.till", new Serializable[0]));
        panel.add(l);
        widthUnifier1.add(l);
        this.till = new DatePicker();
        panel.add(this.till);
        widthUnifier2.add(this.till);
        widthUnifier1.unifyWidth();
        widthUnifier2.unifyWidth();
        SpringUtilities.makeCompactGrid(panel, 1, 4, 5, 5, 5, 5);
        this.getContentPane().add((Component)panel, "North");
        LetterShowChangeListener letterShowChangeListener = new LetterShowChangeListener();
        this.from.addChangeListener(letterShowChangeListener);
        this.till.addChangeListener(letterShowChangeListener);
    }

    public TimeRange getTimeRange() {
        Date till;
        Date from = this.from.getSelectedItem();
        if (TimeUtil.isSameDay(from, till = this.till.getSelectedItem()) || from.before(till)) {
            return new TimeRange(from, till);
        }
        return null;
    }

    private class LetterShowChangeListener
    implements ChangeListener {
        private LetterShowChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Date from = LetterShowObjectDateDialog.this.from.getSelectedItem();
            Date till = LetterShowObjectDateDialog.this.till.getSelectedItem();
            TimeRange timeRange = null;
            if (TimeUtil.isSameDay(from, till) || from.before(till)) {
                timeRange = new TimeRange(from, till);
            }
            LetterShowObjectDateDialog.this.letterFilterableMarkerRenderer.setTimeRange(timeRange);
        }
    }
}

