/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action.clipboard;

import de.datomino.peppergis.client.dataflavor.ImmutableGeoObjectTransferable;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.dto.ImmutablePolygonKindDto;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class CopyAreaAction
extends AbstractAction {
    private static final long serialVersionUID = 3405271298952590520L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public CopyAreaAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.copy", new Serializable[0]));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 128));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Set<AreaObjectModel> selectedObjects = this.baseLayerEditorPanel.getSelectedObjects();
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Collection<ImmutablePolygonKind> polygons = AreaObjectModelUtil.getImmutablePolygonKindsFromAreas(selectedObjects);
        ArrayList<ImmutablePolygonKindDto> dtos = new ArrayList<ImmutablePolygonKindDto>(polygons.size());
        for (ImmutablePolygonKind polygon : polygons) {
            dtos.add(ImmutablePolygonKindDto.create(polygon));
        }
        ImmutableGeoObjectTransferable contents = new ImmutableGeoObjectTransferable(dtos);
        clipboard.setContents(contents, new ClipboardOwner(){

            @Override
            public void lostOwnership(Clipboard clipboard, Transferable contents) {
            }
        });
    }
}

