/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.gui.AreaObjectChooserPane;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.geo.ImmutablePoint;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.FetchingGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.swing.SwingUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.AbstractToggleAction;
import org.ktde.swing.ToggleAction;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;

public class ShowAreaLayerAction
extends AbstractToggleAction {
    private static final long serialVersionUID = -1562013877004694096L;
    private AreaLayerModel areaLayerModel;
    private AreaLayerRenderer areaLayerRenderer;
    private List<ToggleAction> linkedToggleActions = new LinkedList<ToggleAction>();
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public ShowAreaLayerAction(AreaLayerModel areaLayerModel, AreaLayerRenderer areaLayerRenderer, BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.show", new Serializable[]{areaLayerModel.getDisplayname()}), false);
        this.areaLayerRenderer = areaLayerRenderer;
        this.areaLayerModel = areaLayerModel;
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    public void turnOn() {
        this.calcLayerActive();
    }

    @Override
    public void turnOff() {
        this.calcLayerActive();
    }

    public AreaLayerRenderer getAreaLayerRenderer() {
        return this.areaLayerRenderer;
    }

    public void addToggleAction(ToggleAction toggleAction) {
        this.linkedToggleActions.add(toggleAction);
        toggleAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                ShowAreaLayerAction.this.calcLayerActive();
            }
        });
    }

    public AreaLayerModel getAreaLayerModel() {
        return this.areaLayerModel;
    }

    private void calcLayerActive() {
        boolean toActivate = false;
        if (this.isSelected()) {
            toActivate = true;
        } else {
            for (ToggleAction toggleAction : this.linkedToggleActions) {
                if (!toggleAction.isSelected()) continue;
                toActivate = true;
                break;
            }
        }
        if (toActivate != this.areaLayerRenderer.isActive()) {
            if (StringUtil.isTrue(ModelEnviroment.getProperties().getProperty("areas.showOtherLayers.selectAreas")) && toActivate) {
                Tupel<ImmutablePoint, ImmutablePoint> tupel;
                Set<Long> notSelectedAreaObjects;
                AreaObjectChooserPane areaObjectChooserPane = new AreaObjectChooserPane(this.areaLayerModel, this.baseLayerEditorPanel.getModelEnviroment(), false);
                int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this.baseLayerEditorPanel), areaObjectChooserPane, ModelEnviroment.getMessageResolver().resolveMessage(this.areaLayerModel.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.preselectAreas.order" : "messages.area.preselectAreas", new Serializable[0]), 0);
                GeoObjectBucketsModel bucketsModel = this.areaLayerRenderer.getBucketsModel();
                bucketsModel.clear();
                final Set<Long> fNotSelectedAreaObjects = notSelectedAreaObjects = areaObjectChooserPane.getNotSelectedAreaObjects();
                if (bucketsModel instanceof FetchingGeoObjectBucketsModel) {
                    FetchingGeoObjectBucketsModel fetchingGeoObjectBucketsModel = (FetchingGeoObjectBucketsModel)bucketsModel;
                    if (d == 0) {
                        fetchingGeoObjectBucketsModel.setFetchCallback(new BucketsFetchCallback<AreaObjectModel, ImmutablePolygonKind>(){

                            @Override
                            public Collection<AreaObjectModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                                return ShowAreaLayerAction.this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller().fetchAreaObjectsWithoutIds(ShowAreaLayerAction.this.areaLayerModel, topLeft, bottomRight, fNotSelectedAreaObjects);
                            }
                        });
                    } else {
                        fetchingGeoObjectBucketsModel.setFetchCallback(new BucketsFetchCallback<AreaObjectModel, ImmutablePolygonKind>(){

                            @Override
                            public Collection<AreaObjectModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                                return ShowAreaLayerAction.this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller().fetchAreaObjects(ShowAreaLayerAction.this.areaLayerModel, topLeft, bottomRight);
                            }
                        });
                        notSelectedAreaObjects = null;
                    }
                }
                if (areaObjectChooserPane.isCenterAreas() && (tupel = this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller().getTopLeftAndBottomRightForLayer(this.areaLayerModel, notSelectedAreaObjects)) != null) {
                    ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>(2);
                    coordinates.add(tupel.getElement1().getCoordinate());
                    coordinates.add(tupel.getElement2().getCoordinate());
                    this.baseLayerEditorPanel.getNavigatorPanel().center(coordinates, 10);
                }
            }
            this.areaLayerRenderer.setActive(toActivate);
            if (toActivate) {
                this.baseLayerEditorPanel.getNavigatorPanel().addMouseMotionListener(this.areaLayerRenderer);
            } else {
                this.baseLayerEditorPanel.getNavigatorPanel().removeMouseMotionListener(this.areaLayerRenderer);
            }
        }
    }
}

