/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action;

import de.datomino.peppergis.client.export.AbstractExportFileAction;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.map.ParcelModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.client.util.PoiModelUtil;
import de.datomino.peppergis.exception.ClientExportException;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.message.error.ErrorMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tupel;
import org.ktde.util.io.CsvWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportAreaLegendAction
extends AbstractExportFileAction<Object> {
    private static final long serialVersionUID = 8611173196554668822L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportAreaLegendAction.class);
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private Collection<AreaAttributeValueDescriptorModel> descriptors;
    private List<Column> columns;

    public ExportAreaLegendAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage(baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.exporter.area.legend.order" : "messages.exporter.area.legend", new Serializable[0]), baseLayerEditorPanel.getParentWindow(), "csv");
        this.baseLayerEditorPanel = baseLayerEditorPanel;
    }

    @Override
    protected Tupel<Map<String, byte[]>, ErrorMessages> getContent(Object o) throws ClientExportException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            CsvWriter csvWriter = new CsvWriter(baos, "UTF-8");
            csvWriter.writeLine(this.getHeader());
            Tupel<Set<AreaObjectModel>, Set<AreaObjectModel>> areaObjectsForLegend = this.baseLayerEditorPanel.getAreaObjectsForLegend();
            LinkedList<AreaObjectModel> merged = new LinkedList<AreaObjectModel>((Collection)areaObjectsForLegend.getElement1());
            merged.addAll((Collection)areaObjectsForLegend.getElement2());
            ErrorMessages errorMessages = this.transformSource(merged, csvWriter);
            csvWriter.flush();
            csvWriter.close();
            return new Tupel<Map<String, byte[]>, ErrorMessages>(Collections.singletonMap("", baos.toByteArray()), errorMessages);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ErrorMessages transformSource(List<AreaObjectModel> areaObjects, CsvWriter csvWriter) {
        ErrorMessages errorMessages = new ErrorMessages();
        for (AreaObjectModel areaObject : areaObjects) {
            ArrayList<String> line = new ArrayList<String>();
            block11: for (Column column : this.columns) {
                switch (column) {
                    case SHORTCUT: {
                        line.add(StringUtil.nullToEmpty(areaObject.getShortcut()));
                        break;
                    }
                    case DISPLAYNAME: {
                        line.add(StringUtil.nullToEmpty(areaObject.getDisplayname()));
                        break;
                    }
                    case POI: {
                        line.add(PoiModelUtil.getName(areaObject.getPoi()));
                        break;
                    }
                    case PARCELS: {
                        List<ParcelModel> parcels = this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getTourCaller().fetchParcelsByAreaObject(areaObject, true);
                        line.add(String.valueOf(parcels.size()));
                        break;
                    }
                    case SUBSCRIPTIONS: {
                        List<SubscriptionModel> subscriptions = this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getTourCaller().fetchSubscriptionsByAreaObject(areaObject, null);
                        line.add(String.valueOf(subscriptions.size()));
                        break;
                    }
                    case ATTRIBUTES: {
                        HashMap<AreaAttributeValueDescriptorModel, AreaAttributeValueModel> attributeMap = new HashMap<AreaAttributeValueDescriptorModel, AreaAttributeValueModel>();
                        for (AreaAttributeValueModel attribute : areaObject.iterableAreaAttributeValues()) {
                            attributeMap.put(attribute.getAreaAttributeValueDescriptor(), attribute);
                        }
                        for (AreaAttributeValueDescriptorModel descriptor : this.descriptors) {
                            AreaAttributeValueModel areaAttributeValueModel = (AreaAttributeValueModel)attributeMap.get(descriptor);
                            if (areaAttributeValueModel == null) {
                                line.add("");
                                continue;
                            }
                            line.add(AreaObjectModelUtil.getStringRepresantation(areaAttributeValueModel));
                        }
                        continue block11;
                    }
                }
            }
            try {
                csvWriter.writeLine(line);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), e);
                errorMessages.addErrorMessage(e.getMessage(), new Serializable[0]);
            }
        }
        return errorMessages;
    }

    private List<String> getHeader() {
        if (this.descriptors == null || this.columns == null) {
            this.descriptors = this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getAreaCaller().fetchAllAreaAttributeValueDescriptors();
            String property = ModelEnviroment.getProperties().getProperty("area.export.legend.columns");
            if (property == null) {
                this.columns = CollectionUtil.buildArrayList(Column.SHORTCUT, Column.DISPLAYNAME, Column.ATTRIBUTES);
            } else {
                String[] cs = property.replaceAll(" ", "").split(",");
                this.columns = new ArrayList<Column>();
                try {
                    for (String c : cs) {
                        this.columns.add(Column.valueOf(c));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("invalid property - area.export.legend.columns");
                    this.columns = CollectionUtil.buildArrayList(Column.SHORTCUT, Column.DISPLAYNAME, Column.ATTRIBUTES);
                }
            }
        }
        ArrayList<String> header = new ArrayList<String>();
        block6: for (Column column : this.columns) {
            switch (column) {
                case ATTRIBUTES: {
                    for (AreaAttributeValueDescriptorModel descriptor : this.descriptors) {
                        AttributeValueType attributeValueType = descriptor.getAttributeValueType();
                        if (attributeValueType == AttributeValueType.IMAGE || attributeValueType == AttributeValueType.PDF_DOWN) continue;
                        header.add(this.getMessageForEnum(column) + " " + descriptor.getKey());
                    }
                    continue block6;
                }
                default: {
                    header.add(this.getMessageForEnum(column));
                }
            }
        }
        return header;
    }

    private String getMessageForEnum(Enum<?> value) {
        return ModelEnviroment.getMessageResolver().resolveMessage(value.getClass().getName().replace('$', '.') + "." + value.name(), new Serializable[0]);
    }

    private static enum Column {
        SHORTCUT,
        DISPLAYNAME,
        POI,
        ATTRIBUTES,
        PARCELS,
        SUBSCRIPTIONS;

    }
}

