/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action;

import de.datomino.peppergis.client.communication.TourCaller;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaDeliveryRoundModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenAreaObjectRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenInfoModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentModel;
import de.datomino.peppergis.client.model.area.AreaObjectGenSegmentRelModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.area.AreaObjectParcelRelModel;
import de.datomino.peppergis.client.model.area.DetaillessAreaObjectGeometryModel;
import de.datomino.peppergis.client.model.base.LetterModel;
import de.datomino.peppergis.client.model.base.PoiAttributeValueModel;
import de.datomino.peppergis.client.model.base.PoiModel;
import de.datomino.peppergis.client.model.base.SubscriptionAttributeValueModel;
import de.datomino.peppergis.client.model.base.SubscriptionBreakTimeModel;
import de.datomino.peppergis.client.model.base.SubscriptionModel;
import de.datomino.peppergis.client.model.offer.OfferAreaRelationModel;
import de.datomino.peppergis.client.model.tour.AreaTourModel;
import de.datomino.peppergis.client.util.AreaTourModelUtil;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.collection.CollectionUtil;
import de.datomino.util.swing.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.ktde.util.StringUtil;
import org.ktde.util.cache.ChangeSet;
import org.ktde.util.datatypes.Tripel;

public class DeleteSelectedAreaAction
extends AbstractAction {
    private static final long serialVersionUID = 6202273896284759526L;
    private BaseLayerEditorPanel baseLayerEditorPanel;

    public DeleteSelectedAreaAction(BaseLayerEditorPanel baseLayerEditorPanel) {
        super(ModelEnviroment.getMessageResolver().resolveMessage(baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.delete.order" : "messages.area.delete", new Serializable[0]));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 512));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Set<AreaObjectModel> selectedObjects = this.baseLayerEditorPanel.getSelectedObjects();
        if (selectedObjects != null && !selectedObjects.isEmpty()) {
            String messageArgument = this.createMessageArgument(selectedObjects);
            String key = this.baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.question.deleteAreas.order" : "messages.area.question.deleteAreas";
            String message = ModelEnviroment.getMessageResolver().resolveMessage(key, new Serializable[]{messageArgument});
            JPanel innerPanel = new JPanel(new BorderLayout());
            JTextArea textArea = new JTextArea(message, 10, 30);
            textArea.setEditable(false);
            innerPanel.add((Component)new JScrollPane(textArea), "Center");
            int d = JOptionPane.showConfirmDialog(SwingUtils.findWindowParent(this.baseLayerEditorPanel), innerPanel, ModelEnviroment.getMessageResolver().resolveMessage("messages.default.question", new Serializable[0]), 0, 3);
            if (d == 0) {
                this.baseLayerEditorPanel.getModelEnviroment().getUndoManager().startTransaction();
                try {
                    for (AreaObjectModel areaObject : selectedObjects) {
                        this.deleteAreaObject(areaObject, selectedObjects);
                    }
                    this.baseLayerEditorPanel.clearSelection();
                    String messageKey = this.baseLayerEditorPanel.getEditBaseLayer().getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT ? "messages.area.deleted.order" : "messages.area.deleted";
                    this.baseLayerEditorPanel.getModelEnviroment().getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage(messageKey, new Serializable[0]));
                }
                catch (RuntimeException ex) {
                    this.baseLayerEditorPanel.getModelEnviroment().getUndoManager().rollbackTransaction();
                    throw ex;
                }
                this.baseLayerEditorPanel.clearSelection();
                this.baseLayerEditorPanel.getModelEnviroment().getUndoManager().finishTransaction(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.deleted", new Serializable[0]));
            }
        }
    }

    private String createMessageArgument(Set<AreaObjectModel> selectedObjects) {
        ArrayList<Tripel<String, Integer, Boolean>> elements = new ArrayList<Tripel<String, Integer, Boolean>>(selectedObjects.size());
        for (AreaObjectModel areaObjectModel : selectedObjects) {
            elements.add(new Tripel<String, Integer, Boolean>(areaObjectModel.getShortcut(), areaObjectModel.countSubscriptions(), this.checkPoiRefs(areaObjectModel, selectedObjects)));
        }
        Collections.sort(elements);
        ArrayList<String> messageElements = new ArrayList<String>(elements.size());
        String subscriptionMessage = ModelEnviroment.getMessageResolver().resolveMessage("messages.subscription.subscriptions", new Serializable[0]);
        String poiMessage = ModelEnviroment.getMessageResolver().resolveMessage("messages.poi.pois", new Serializable[0]);
        for (Tripel tripel : elements) {
            messageElements.add((String)tripel.getElement1() + "(" + tripel.getElement2() + " " + subscriptionMessage + ")" + ((Boolean)tripel.getElement3() != false ? " + " + poiMessage : ""));
        }
        String messageArgument = StringUtil.implode(messageElements, "\n");
        return messageArgument;
    }

    private boolean checkPoiRefs(AreaObjectModel areaObjectModel, Set<AreaObjectModel> selectedObjects) {
        PoiModel poi = areaObjectModel.getPoi();
        if (poi != null) {
            for (AreaObjectModel area : poi.iterableAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                return false;
            }
            for (AreaObjectModel area : poi.iterableFirstThrowAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                return false;
            }
            for (AreaObjectModel area : poi.iterableLastThrowAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                return false;
            }
        }
        if ((poi = areaObjectModel.getFirstPickPoint()) != null) {
            for (AreaObjectModel area : poi.iterableAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                return false;
            }
            for (AreaObjectModel area : poi.iterableFirstThrowAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                return false;
            }
            for (AreaObjectModel area : poi.iterableLastThrowAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                return false;
            }
        }
        if ((poi = areaObjectModel.getLastPickPoint()) != null) {
            for (AreaObjectModel area : poi.iterableAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                return false;
            }
            for (AreaObjectModel area : poi.iterableFirstThrowAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                return false;
            }
            for (AreaObjectModel area : poi.iterableLastThrowAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                return false;
            }
        }
        return true;
    }

    private void deleteAreaObject(AreaObjectModel areaObject, Set<AreaObjectModel> selectedAreaObjects) {
        if (areaObject != null) {
            areaObject.setGeom(null);
            areaObject.setAreaLayer(null);
            areaObject.setPoi(null);
            areaObject.setFirstPickPoint(null);
            areaObject.setLastPickPoint(null);
            this.deleteAreaObject(areaObject.getGenInfo());
            this.deleteAreaObjectRels(areaObject.iterableAreaObjectParcelRel());
            this.deleteAreaObjectAttributes(areaObject.iterableAreaAttributeValues());
            this.deleteAreaObjectDetaillessGeoms(areaObject.iterableDetaillessAreaObjectGeometries());
            this.deleteAreaObjectSubscriptionRels(areaObject);
            this.deleteAreaObjectTours(areaObject);
            this.deleteAreaObjectOfferRels(areaObject);
            this.deletePoisIfUnreffed(areaObject, selectedAreaObjects);
            this.deleteLetters(areaObject.iterableLetters());
            this.deleteDeliveryRound(areaObject.iterableAreaDeliveryRounds());
            this.deleteFilters(areaObject);
            this.deleteOffer(areaObject);
            areaObject.delete();
        }
    }

    private void deleteOffer(AreaObjectModel areaObject) {
        this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getOfferCaller().getOfferAreaRelationsForAreaObject(areaObject).forEach(o -> o.delete());
    }

    private void deleteFilters(AreaObjectModel areaObject) {
        this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getSubscriptionCaller().fetchAllSubscriptionFilters().forEach(o -> o.iterableSubscriptionFilterAreaRelation().forEach(r -> {
            if (areaObject.equals(r.getAreaObject())) {
                r.delete();
            }
        }));
    }

    private void deleteDeliveryRound(Iterable<AreaDeliveryRoundModel> deliveryRounds) {
        deliveryRounds.forEach(dr -> {
            dr.iterableReplacements().forEach(r -> r.delete());
            dr.delete();
        });
    }

    private void deleteLetters(Iterable<LetterModel> letters) {
        letters.forEach(l -> {
            l.iterableLetterAttributeValues().forEach(o -> o.delete());
            l.iterableSortOrders().forEach(o -> o.delete());
            l.delete();
        });
    }

    private void deletePoisIfUnreffed(AreaObjectModel areaObjectModel, Set<AreaObjectModel> selectedObjects) {
        boolean delete;
        PoiModel poi = areaObjectModel.getPoi();
        if (poi != null) {
            delete = true;
            for (AreaObjectModel area : poi.iterableAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                delete = false;
                break;
            }
            if (delete) {
                for (AreaObjectModel area : poi.iterableFirstThrowAreaObjects()) {
                    if (selectedObjects.contains(area)) continue;
                    delete = false;
                    break;
                }
            }
            if (delete) {
                for (AreaObjectModel area : poi.iterableLastThrowAreaObjects()) {
                    if (selectedObjects.contains(area)) continue;
                    delete = false;
                    break;
                }
            }
            if (delete) {
                this.deletePoi(poi);
            }
        }
        if ((poi = areaObjectModel.getFirstPickPoint()) != null) {
            delete = true;
            for (AreaObjectModel area : poi.iterableAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                delete = false;
                break;
            }
            if (delete) {
                for (AreaObjectModel area : poi.iterableFirstThrowAreaObjects()) {
                    if (selectedObjects.contains(area)) continue;
                    delete = false;
                    break;
                }
            }
            if (delete) {
                for (AreaObjectModel area : poi.iterableLastThrowAreaObjects()) {
                    if (selectedObjects.contains(area)) continue;
                    delete = false;
                    break;
                }
            }
            if (delete) {
                this.deletePoi(poi);
            }
        }
        if ((poi = areaObjectModel.getLastPickPoint()) != null) {
            delete = true;
            for (AreaObjectModel area : poi.iterableAreaObjects()) {
                if (selectedObjects.contains(area)) continue;
                delete = false;
                break;
            }
            if (delete) {
                for (AreaObjectModel area : poi.iterableFirstThrowAreaObjects()) {
                    if (selectedObjects.contains(area)) continue;
                    delete = false;
                    break;
                }
            }
            if (delete) {
                for (AreaObjectModel area : poi.iterableLastThrowAreaObjects()) {
                    if (selectedObjects.contains(area)) continue;
                    delete = false;
                    break;
                }
            }
            if (delete) {
                this.deletePoi(poi);
            }
        }
    }

    private void deletePoi(PoiModel poi) {
        for (PoiAttributeValueModel poiAttribute : poi.iterablePoiAttributeValues()) {
            poiAttribute.delete();
        }
        poi.delete();
    }

    private void deleteAreaObjectAttributes(Iterable<AreaAttributeValueModel> iterableAreaAttributeValues) {
        for (AreaAttributeValueModel areaAttributeValueModel : iterableAreaAttributeValues) {
            areaAttributeValueModel.delete();
        }
    }

    private void deleteAreaObjectRels(Iterable<AreaObjectParcelRelModel> iterableAreaObjectParcelRel) {
        for (AreaObjectParcelRelModel areaObjectParcelRelModel : iterableAreaObjectParcelRel) {
            areaObjectParcelRelModel.iterableSortOrders().forEach(o -> o.delete());
            areaObjectParcelRelModel.delete();
        }
    }

    private void deleteAreaObjectDetaillessGeoms(Iterable<DetaillessAreaObjectGeometryModel> iterableAreaObjectDetaillessGeoms) {
        for (DetaillessAreaObjectGeometryModel detaillessAreaGeom : iterableAreaObjectDetaillessGeoms) {
            detaillessAreaGeom.delete();
        }
    }

    private void deleteAreaObjectSubscriptionRels(AreaObjectModel areaObject) {
        for (SubscriptionModel subscription : areaObject.iterableSubscriptions()) {
            for (SubscriptionBreakTimeModel subscriptionBreakTime : subscription.iterableBreakTimes()) {
                subscriptionBreakTime.delete();
            }
            for (SubscriptionAttributeValueModel attribute : subscription.iterableSubscriptionAttributeValues()) {
                attribute.delete();
            }
            subscription.iterableSortOrders().forEach(o -> o.delete());
            subscription.delete();
        }
    }

    private void deleteAreaObjectTours(AreaObjectModel areaObject) {
        TourCaller tc = this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getTourCaller();
        Collection<AreaTourModel> areaTours = tc.fetchAreaTours(areaObject, null, null, null);
        for (AreaTourModel areaTour : areaTours) {
            AreaTourModelUtil.deleteAreaTour(areaTour, this.baseLayerEditorPanel.getModelEnviroment());
        }
        tc.fetchAreaTourSchedulesWithTimeWindow(CollectionUtil.buildHashSet(areaObject), null, null).forEach(o -> ((Collection)o.getElement1()).forEach(s -> s.delete()));
    }

    private void deleteAreaObjectOfferRels(AreaObjectModel areaObject) {
        for (OfferAreaRelationModel offerAreaRel : this.baseLayerEditorPanel.getModelEnviroment().getAllCaller().getOfferCaller().getOfferAreaRelationsForAreaObject(areaObject)) {
            offerAreaRel.delete();
        }
    }

    private void deleteAreaObject(AreaObjectGenInfoModel genInfo) {
        if (genInfo != null) {
            genInfo.setAreaObject(null);
            this.deleteAreaObject(genInfo.getAreaObjectGenAreaObject());
            this.deleteAreaObject(genInfo.getAreaObjectGenSegment());
            ChangeSet.delete(genInfo);
        }
    }

    private void deleteAreaObject(AreaObjectGenSegmentModel areaObjectGenSegment) {
        if (areaObjectGenSegment != null) {
            areaObjectGenSegment.setGenInfo(null);
            ArrayList<AreaObjectGenSegmentRelModel> segments = new ArrayList<AreaObjectGenSegmentRelModel>(areaObjectGenSegment.countSegments());
            for (AreaObjectGenSegmentRelModel segment : areaObjectGenSegment.iterableSegments()) {
                segments.add(segment);
            }
            for (AreaObjectGenSegmentRelModel segment : segments) {
                this.deleteAreaObject(segment);
            }
            ChangeSet.delete(areaObjectGenSegment);
        }
    }

    private void deleteAreaObject(AreaObjectGenSegmentRelModel segment) {
        if (segment != null) {
            segment.setGenInfoSegment(null);
            ChangeSet.delete(segment);
        }
    }

    private void deleteAreaObject(AreaObjectGenAreaObjectModel genInfo) {
        if (genInfo != null) {
            genInfo.setGenInfo(null);
            ArrayList<AreaObjectGenAreaObjectRelModel> rels = new ArrayList<AreaObjectGenAreaObjectRelModel>(genInfo.countAreaObjects());
            for (AreaObjectGenAreaObjectRelModel rel : genInfo.iterableAreaObjects()) {
                rels.add(rel);
            }
            for (AreaObjectGenAreaObjectRelModel rel : rels) {
                this.deleteAreaObject(rel);
            }
            ChangeSet.delete(genInfo);
        }
    }

    private void deleteAreaObject(AreaObjectGenAreaObjectRelModel rel) {
        if (rel != null) {
            rel.setAreaObject(null);
            rel.setGenInfoAreaObject(null);
            ChangeSet.delete(rel);
        }
    }
}

