/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.simplebasearea.action;

import de.datomino.logistic.LogisticException;
import de.datomino.logistic.type.RouteType;
import de.datomino.logistic.type.RouteVehicleType;
import de.datomino.peppergis.client.action.search.CommonSearchAction;
import de.datomino.peppergis.client.gui.asynchronous.AbstractGeneralAsynchronousDialog;
import de.datomino.peppergis.client.gui.filter.pattern.legend.AreaFilterPatternLegendDialog;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.dto.asynchronous.AsynchronousGeneralDto;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.action.sourcearea.SourceAreaMarkerActionNavigatorRenderer;
import de.datomino.peppergis.simplebasearea.gui.CircleSearchPane;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.util.geo.swing.AbstractMarkerNavigatorRenderer;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.ktde.math.projection.Coordinate;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.datatypes.Tupel;

public class CircleSearchingAction
extends AbstractAction {
    private static final long serialVersionUID = -2111819106598067267L;
    private Window parent;
    private ModelEnviroment modelEnviroment;
    private static int PROP_PLAIN_CIRCLE = 1;
    private static int PROP_ATTRIBUTE_AGGREGATION = 2;
    private static int PROP_DISTANCE_TIME = 3;
    private BaseLayerEditorPanel baseLayerEditorPanel;
    private List<AbstractMarkerNavigatorRenderer> markerActions;

    public CircleSearchingAction(BaseLayerEditorPanel baseLayerEditorPanel, Window parent, ModelEnviroment modelEnviroment, List<AbstractMarkerNavigatorRenderer> markerActions) {
        super(ModelEnviroment.getMessageResolver().resolveMessage("messages.area.perimeterSearch", new Serializable[0]));
        this.baseLayerEditorPanel = baseLayerEditorPanel;
        this.parent = parent;
        this.modelEnviroment = modelEnviroment;
        this.markerActions = markerActions;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        final Coordinate coordinate = this.getCenterCoordinateForSearch();
        AreaLayerModel areaLayerTemp = this.baseLayerEditorPanel.getCurrentAreaLayer();
        if (areaLayerTemp.getDiscriminator() == AreaObjectGenInfoDiscriminator.AREA_OBJECT_GEN_AREA_OBJECT) {
            for (AbstractMarkerNavigatorRenderer marker : this.markerActions) {
                SourceAreaMarkerActionNavigatorRenderer sourceAreaMarkerActionNavigatorRenderer = (SourceAreaMarkerActionNavigatorRenderer)marker;
                if (!sourceAreaMarkerActionNavigatorRenderer.isOn()) continue;
                areaLayerTemp = sourceAreaMarkerActionNavigatorRenderer.getAreaLayer();
                break;
            }
        }
        final AreaLayerModel areaLayer = areaLayerTemp;
        ArrayList<AreaObjectModel> areas = new ArrayList();
        final CircleSearchPane circleSearchPaneObj = new CircleSearchPane(this.modelEnviroment, coordinate);
        int d = JOptionPane.showConfirmDialog(this.parent, circleSearchPaneObj, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.perimeterSearch", new Serializable[0]), 2);
        if (d == 0) {
            AbstractGeneralAsynchronousDialog asynchronousDialog;
            Boolean showDefault;
            ArrayList selectedFilters;
            List allFilters;
            int option = circleSearchPaneObj.getCircleSearchOption();
            AreaFilterPatternLegendDialog areaFilterPatternLegendDialog = this.baseLayerEditorPanel.getAreaFilterPatternLegendDialog(areaLayer);
            if (areaFilterPatternLegendDialog != null) {
                allFilters = areaFilterPatternLegendDialog.getAllFilters();
                selectedFilters = new ArrayList(areaFilterPatternLegendDialog.getSelectedFiltersList());
                showDefault = areaFilterPatternLegendDialog.isShowDefaultSelected();
            } else {
                selectedFilters = null;
                allFilters = null;
                showDefault = null;
            }
            if (option == PROP_PLAIN_CIRCLE) {
                asynchronousDialog = new AbstractAsynchronousCircleSearchDialog(this.baseLayerEditorPanel.getParentWindow(), this.modelEnviroment){
                    private static final long serialVersionUID = 896936098528489060L;

                    @Override
                    protected String startAsynchronous() {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().findAreasByEuclideanCircleSearch(coordinate, circleSearchPaneObj.getRadius(), areaLayer, circleSearchPaneObj.isIncluded(), selectedFilters, allFilters, showDefault);
                    }
                };
            } else if (option == PROP_ATTRIBUTE_AGGREGATION) {
                asynchronousDialog = new AbstractAsynchronousCircleSearchDialog(this.baseLayerEditorPanel.getParentWindow(), this.modelEnviroment){
                    private static final long serialVersionUID = 705660538784020720L;

                    @Override
                    protected String startAsynchronous() {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().findAreasByAttributeAggregation(coordinate, circleSearchPaneObj.getDescriptor(), circleSearchPaneObj.getAttributeLimit(), areaLayer, CircleSearchingAction.this.baseLayerEditorPanel.getAreaObjectIdsNotToShow(), selectedFilters, allFilters, showDefault);
                    }
                };
            } else if (option == PROP_DISTANCE_TIME) {
                final RouteVehicleType carOrFoot = circleSearchPaneObj.isCar() ? RouteVehicleType.MOTORCAR : (circleSearchPaneObj.isFoot() ? RouteVehicleType.FOOT : (circleSearchPaneObj.isBike() ? RouteVehicleType.BIKE : null));
                final RouteType routeType = circleSearchPaneObj.isDistance() ? RouteType.SHORTEST : (circleSearchPaneObj.isTime() ? RouteType.FASTEST : null);
                asynchronousDialog = new AbstractAsynchronousCircleSearchDialog(this.baseLayerEditorPanel.getParentWindow(), this.modelEnviroment){
                    private static final long serialVersionUID = 839745368832844376L;

                    @Override
                    protected String startAsynchronous() {
                        return this.modelEnviroment.getAllCaller().getAsynchronousCaller().findAreasWithFootOrCarDistance(areaLayer, coordinate, carOrFoot, routeType, circleSearchPaneObj.getDistanceOrTimeValue(), selectedFilters, allFilters, showDefault);
                    }
                };
            } else {
                asynchronousDialog = null;
            }
            try {
                areas = (Collection)asynchronousDialog.run().getElement1();
            }
            catch (LogisticException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Option not implemented! / Bad fetch!", e);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            boolean markSource = areaLayer != this.baseLayerEditorPanel.getCurrentAreaLayer();
            this.showCircleSearchArea(this.filterNotShowing(areas, markSource), markSource);
        }
    }

    private Coordinate getCenterCoordinateForSearch() {
        CommonSearchAction searchAction = this.baseLayerEditorPanel.getSearchActionMenu();
        Coordinate coordinate = searchAction.getCoordinate();
        if (coordinate == null) {
            NavigatorPanel navigatorPanel = this.baseLayerEditorPanel.getNavigatorPanel();
            Point2D.Double centerPixel = navigatorPanel.getCenterPixel();
            Point2D.Double real = navigatorPanel.getReal(centerPixel);
            coordinate = navigatorPanel.getCoordinateFactory().createCoordinate(real);
        }
        return coordinate;
    }

    private Collection<AreaObjectModel> filterNotShowing(Collection<AreaObjectModel> areas, boolean markSource) {
        Set<Long> areaObjectIdsNotToShow = this.baseLayerEditorPanel.getAreaObjectIdsNotToShow();
        if (markSource || areaObjectIdsNotToShow == null) {
            return areas;
        }
        HashSet<AreaObjectModel> filtered = new HashSet<AreaObjectModel>();
        for (AreaObjectModel area : areas) {
            if (areaObjectIdsNotToShow.contains(area.getId())) continue;
            filtered.add(area);
        }
        return filtered;
    }

    private void showCircleSearchArea(Collection<AreaObjectModel> objects, boolean markSource) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (AreaObjectModel areaObjectModel : objects) {
            coordinates.addAll(AreaObjectModelUtil.getAreaRectangle(areaObjectModel));
        }
        if (markSource) {
            Map<AreaLayerModel, Set<AreaObjectModel>> objectMarkSetsHash = this.baseLayerEditorPanel.getObjectMarkSetsHash();
            Map<AreaLayerModel, SourceAreaMarkerActionNavigatorRenderer> areaObjectMarkers = this.baseLayerEditorPanel.getAreaObjectMarkers();
            HashMap rendererMap = new HashMap();
            for (AreaObjectModel areaObjectModel : objects) {
                AreaLayerModel areaLayer = areaObjectModel.getAreaLayer();
                Set<AreaObjectModel> set = objectMarkSetsHash.get(areaLayer);
                if (set == null) {
                    set = new HashSet<AreaObjectModel>();
                    objectMarkSetsHash.put(areaLayer, set);
                }
                set.add(areaObjectModel);
                Tupel tupel = (Tupel)rendererMap.get(areaLayer);
                if (tupel == null) {
                    SourceAreaMarkerActionNavigatorRenderer sourceAreaMarkerActionNavigatorRenderer = areaObjectMarkers.get(areaLayer);
                    tupel = new Tupel(sourceAreaMarkerActionNavigatorRenderer, new LinkedList());
                    rendererMap.put(areaLayer, tupel);
                }
                ((Collection)tupel.getElement2()).add(areaObjectModel);
            }
            for (Map.Entry entry : rendererMap.entrySet()) {
                Tupel tupel = (Tupel)entry.getValue();
                ((SourceAreaMarkerActionNavigatorRenderer)tupel.getElement1()).addMarkedObjects((Collection)tupel.getElement2(), false);
            }
            this.baseLayerEditorPanel.updateMarkSets();
        } else {
            this.baseLayerEditorPanel.select(objects);
        }
        if (!objects.isEmpty()) {
            this.baseLayerEditorPanel.getNavigatorPanel().center(coordinates, 1.0, false);
        }
        this.baseLayerEditorPanel.repaint(10L);
    }

    private abstract class AbstractAsynchronousCircleSearchDialog
    extends AbstractGeneralAsynchronousDialog<Collection<AreaObjectModel>, AsynchronousGeneralDto<Collection<AreaObjectModel>>> {
        private static final long serialVersionUID = 1358896189483972846L;

        public AbstractAsynchronousCircleSearchDialog(Window parent, ModelEnviroment modelEnvironment) {
            super(parent, ModelEnviroment.getMessageResolver().resolveMessage("messages.area.perimeterSearch", new Serializable[0]), ModelEnviroment.getMessageResolver().resolveMessage("messages.area.perimeterSearch", new Serializable[0]), 0, true, modelEnvironment, false);
        }

        @Override
        protected AsynchronousGeneralDto<Collection<AreaObjectModel>> getAsynchronousDto(String token) {
            return this.modelEnviroment.getAllCaller().getAsynchronousCaller().getFindAreasResult(token);
        }
    }
}

