/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.prototypes;

import de.datomino.client.local.message.AreaKey;
import de.datomino.client.local.message.ClientMessage;
import de.datomino.client.local.message.MarkArea;
import de.datomino.client.local.message.ObjectFactory;
import de.datomino.client.local.message.Pdf;
import de.datomino.peppergis.prototypes.CrossmediaCallPeppergis;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;

public class CrossmediaCallPeppergisImpl
implements CrossmediaCallPeppergis {
    public static final String GET_AREAS_OPERATION = "markArea";
    public static final String GET_AREA_PDF_OPERATION = "getPdf";
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private static final JAXBContext JAXB_CONTEXT;
    public static final String MAGIC_END = "<!-- END -->";
    private int port;

    public CrossmediaCallPeppergisImpl() {
        this(60000);
    }

    public CrossmediaCallPeppergisImpl(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientMessage send(ClientMessage clientMessage) throws Exception {
        Socket socket = null;
        ClientMessage response = null;
        try {
            socket = new Socket("localhost", this.port);
            OutputStream out = socket.getOutputStream();
            JAXB_CONTEXT.createMarshaller().marshal((Object)clientMessage, out);
            out.write(MAGIC_END.getBytes());
            out.flush();
            InputStream in = socket.getInputStream();
            response = (ClientMessage)JAXB_CONTEXT.createUnmarshaller().unmarshal(in);
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
        finally {
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
        }
        return response;
    }

    @Override
    public Set<String> editMark(Set<String> inputKeys) {
        ClientMessage response;
        ClientMessage clientMessage = OBJECT_FACTORY.createClientMessage();
        clientMessage.setOperation(GET_AREAS_OPERATION);
        MarkArea markArea = OBJECT_FACTORY.createMarkArea();
        markArea.getAreaId().addAll(inputKeys);
        clientMessage.setMarkArea(markArea);
        try {
            response = this.send(clientMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<String>(inputKeys);
        }
        return response == null ? new HashSet<String>(inputKeys) : new HashSet<String>(response.getMarkArea().getAreaId());
    }

    @Override
    public InputStream generatePdf(Set<String> inputKeys) {
        ClientMessage response;
        ClientMessage clientMessage = OBJECT_FACTORY.createClientMessage();
        clientMessage.setOperation(GET_AREA_PDF_OPERATION);
        AreaKey areaKey = OBJECT_FACTORY.createAreaKey();
        areaKey.getAreaId().addAll(inputKeys);
        clientMessage.setAreaKey(areaKey);
        try {
            response = this.send(clientMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ByteArrayInputStream(new byte[0]);
        }
        if (response == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        Pdf pdf = response.getPdf();
        return new ByteArrayInputStream(pdf.getPdf());
    }

    static {
        try {
            JAXB_CONTEXT = JAXBContext.newInstance(ClientMessage.class);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }
}

