/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.properties;

import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.properties.PropertyDescriptor;
import de.datomino.peppergis.properties.single.AbstractPropertyEditorPanel;
import de.datomino.peppergis.properties.single.BooleanPropertyEditorPanel;
import de.datomino.peppergis.properties.single.CronPropertyEditorPanel;
import de.datomino.peppergis.properties.single.DoublePropertyEditorPanel;
import de.datomino.peppergis.properties.single.IntegerPropertyEditorPanel;
import de.datomino.peppergis.properties.single.SelectableChainPropertyEditorPanel;
import de.datomino.peppergis.properties.single.SelectablePropertyEditorPanel;
import de.datomino.peppergis.properties.single.TextPropertyEditorPanel;
import de.datomino.util.swing.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class SinglePropertyEditor
extends JPanel {
    private static final long serialVersionUID = -5447660413828402177L;
    private PropertyDescriptor propertyDescriptor;
    private JTextField name;
    private JTextField type;
    private JTextArea description;
    private JTextField defaultValue;
    private JPanel editorPanel;
    private CardLayout cardLayout;
    private Properties properties;
    private Map<PropertyDescriptor.PropertyType, AbstractPropertyEditorPanel> editorMap = new EnumMap<PropertyDescriptor.PropertyType, AbstractPropertyEditorPanel>(PropertyDescriptor.PropertyType.class);

    public SinglePropertyEditor(Properties properties) {
        super(new BorderLayout());
        this.properties = properties;
        this.buildLayout();
    }

    private void buildLayout() {
        JPanel upperPanel = new JPanel(new SpringLayout());
        upperPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.name", new Serializable[0])));
        this.name = new JTextField();
        this.name.setEditable(false);
        upperPanel.add(this.name);
        upperPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.type", new Serializable[0])));
        this.type = new JTextField();
        this.type.setEditable(false);
        upperPanel.add(this.type);
        JLabel label = new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.information", new Serializable[0]));
        label.setVerticalAlignment(1);
        upperPanel.add(label);
        this.description = new JTextArea(20, 70);
        this.description.setEditable(false);
        upperPanel.add(new JScrollPane(this.description));
        upperPanel.add(new JLabel(ModelEnviroment.getMessageResolver().resolveMessage("messages.default.defaultValue", new Serializable[0])));
        this.defaultValue = new JTextField();
        this.defaultValue.setEditable(false);
        upperPanel.add(this.defaultValue);
        SpringUtilities.makeCompactGrid(upperPanel, 4, 2, 5, 5, 2, 2);
        this.add((Component)upperPanel, "North");
        this.cardLayout = new CardLayout();
        this.editorPanel = new JPanel(this.cardLayout);
        this.editorPanel.add((Component)new JPanel(), "");
        TextPropertyEditorPanel comp = new TextPropertyEditorPanel();
        this.editorPanel.add((Component)comp, PropertyDescriptor.PropertyType.TEXT.name());
        this.editorMap.put(PropertyDescriptor.PropertyType.TEXT, comp);
        IntegerPropertyEditorPanel integerPropertyEditorPanel = new IntegerPropertyEditorPanel();
        this.editorPanel.add((Component)integerPropertyEditorPanel, PropertyDescriptor.PropertyType.INTEGER.name());
        this.editorMap.put(PropertyDescriptor.PropertyType.INTEGER, integerPropertyEditorPanel);
        SelectablePropertyEditorPanel selectablePropertyEditorPanel = new SelectablePropertyEditorPanel();
        this.editorPanel.add((Component)selectablePropertyEditorPanel, PropertyDescriptor.PropertyType.SELECTABLE.name());
        this.editorMap.put(PropertyDescriptor.PropertyType.SELECTABLE, selectablePropertyEditorPanel);
        SelectableChainPropertyEditorPanel selectableChainPropertyEditorPanel = new SelectableChainPropertyEditorPanel();
        this.editorPanel.add((Component)selectableChainPropertyEditorPanel, PropertyDescriptor.PropertyType.SELECTABLE_CHAIN.name());
        this.editorMap.put(PropertyDescriptor.PropertyType.SELECTABLE_CHAIN, selectableChainPropertyEditorPanel);
        BooleanPropertyEditorPanel booleanPropertyEditorPanel = new BooleanPropertyEditorPanel();
        this.editorPanel.add((Component)booleanPropertyEditorPanel, PropertyDescriptor.PropertyType.BOOLEAN.name());
        this.editorMap.put(PropertyDescriptor.PropertyType.BOOLEAN, booleanPropertyEditorPanel);
        DoublePropertyEditorPanel doublePropertyEditorPanel = new DoublePropertyEditorPanel();
        this.editorPanel.add((Component)doublePropertyEditorPanel, PropertyDescriptor.PropertyType.DOUBLE.name());
        this.editorMap.put(PropertyDescriptor.PropertyType.DOUBLE, doublePropertyEditorPanel);
        CronPropertyEditorPanel cronPropertyEditorPanel = new CronPropertyEditorPanel();
        this.editorPanel.add((Component)cronPropertyEditorPanel, PropertyDescriptor.PropertyType.CRON.name());
        this.editorMap.put(PropertyDescriptor.PropertyType.CRON, cronPropertyEditorPanel);
        this.add((Component)this.editorPanel, "Center");
    }

    public void setPropertyGroupDescriptor(PropertyDescriptor propertyGroupDescriptor) {
        this.saveValue();
        this.propertyDescriptor = propertyGroupDescriptor;
        if (this.propertyDescriptor == null) {
            this.name.setText("");
            this.type.setText("");
            this.defaultValue.setText("");
            this.description.setText("");
            this.cardLayout.show(this.editorPanel, "");
        } else {
            String name = this.propertyDescriptor.getName();
            this.name.setText(name);
            PropertyDescriptor.PropertyType type = this.propertyDescriptor.getPropertyType();
            this.type.setText(type.name());
            String defaultValue = this.propertyDescriptor.getDefaultValue();
            this.defaultValue.setText(defaultValue);
            this.description.setText(this.propertyDescriptor.getDescription());
            this.description.setCaretPosition(0);
            this.cardLayout.show(this.editorPanel, type.name());
            AbstractPropertyEditorPanel abstractPropertyEditorPanel = this.editorMap.get((Object)this.propertyDescriptor.getPropertyType());
            abstractPropertyEditorPanel.setElements(this.propertyDescriptor.getElements());
            String value = this.properties.getProperty(name);
            abstractPropertyEditorPanel.setValue(value == null ? defaultValue : value);
        }
    }

    public void saveValue() {
        if (this.propertyDescriptor != null) {
            String value = this.editorMap.get((Object)this.propertyDescriptor.getPropertyType()).getValue();
            if (value == null) {
                value = "";
            }
            this.properties.setProperty(this.propertyDescriptor.getName(), value);
        }
    }

    public void refresh() {
        if (this.propertyDescriptor != null) {
            String value = this.properties.getProperty(this.propertyDescriptor.getName());
            AbstractPropertyEditorPanel abstractPropertyEditorPanel = this.editorMap.get((Object)this.propertyDescriptor.getPropertyType());
            abstractPropertyEditorPanel.setValue(value == null ? this.propertyDescriptor.getDefaultValue() : value);
        }
    }
}

