/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.print;

import de.datomino.peppergis.print.TableCellEntity;
import de.datomino.peppergis.util.FormUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ktde.util.datatypes.Tripel;

public class TableRowEntity
extends ArrayList<TableCellEntity> {
    private static final long serialVersionUID = 6520338654977922140L;
    private List<String> infos = new ArrayList<String>();

    @Override
    public boolean add(TableCellEntity cell) {
        boolean b = super.add(cell);
        if (b) {
            Collections.sort(this, new Comparator<TableCellEntity>(){

                @Override
                public int compare(TableCellEntity o1, TableCellEntity o2) {
                    int i1 = o1.getSortOrder() == null ? Integer.MAX_VALUE : o1.getSortOrder();
                    int i2 = o2.getSortOrder() == null ? Integer.MAX_VALUE : o2.getSortOrder();
                    return i1 - i2;
                }
            });
        }
        return b;
    }

    public void addCell(int width, String text, Color color, Integer sortOrder) {
        TableCellEntity cell = new TableCellEntity(width, FormUtil.getStringWithLength(text, width), color, sortOrder);
        this.add(cell);
    }

    public List<String> getInfos() {
        return this.infos;
    }

    public List<Tripel<Integer, String, Color>> getHeader() {
        ArrayList<Tripel<Integer, String, Color>> list = new ArrayList<Tripel<Integer, String, Color>>();
        for (TableCellEntity cell : this) {
            list.add(new Tripel<Integer, String, Color>(cell.getWidth(), cell.getText(), cell.getColor()));
        }
        return list;
    }

    public Tripel<List<String>, List<String>, Color> getRow(Color color) {
        ArrayList<String> list = new ArrayList<String>();
        for (TableCellEntity cell : this) {
            list.add(cell.getText());
        }
        return new Tripel<List<String>, List<String>, Color>(list, this.getInfos(), color);
    }
}

