/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.offer.print.esslinger;

import de.datomino.pdf.engine.PdfCreatorImpl;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.model.area.AreaAttributeValueDescriptorModel;
import de.datomino.peppergis.client.model.area.AreaAttributeValueModel;
import de.datomino.peppergis.client.model.area.AreaLayerModel;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.model.base.CustomerModel;
import de.datomino.peppergis.client.model.offer.AgentModel;
import de.datomino.peppergis.client.model.offer.MediaModel;
import de.datomino.peppergis.client.model.offer.OfferAreaRelationModel;
import de.datomino.peppergis.client.model.offer.OfferDeliveryInformationModel;
import de.datomino.peppergis.client.model.offer.OfferDeliveryRelationModel;
import de.datomino.peppergis.client.model.offer.OfferExtension1Model;
import de.datomino.peppergis.client.model.offer.OfferModel;
import de.datomino.peppergis.client.pdf.PeppergisCommonPdfHelper;
import de.datomino.peppergis.client.util.LocationModelUtil;
import de.datomino.peppergis.offer.print.AbstractOfferPrinterImpl;
import de.datomino.peppergis.offer.print.OfferPrinterHelper;
import de.datomino.peppergis.type.AreaObjectGenInfoDiscriminator;
import de.datomino.peppergis.type.AttributeValueType;
import de.datomino.peppergis.type.OfferType;
import de.datomino.peppergis.type.Salutation;
import de.datomino.peppergis.util.FormUtil;
import de.datomino.util.common.PrimitiveUtil;
import de.datomino.util.time.TimeUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringEscapeUtils;
import org.ktde.util.StringUtil;
import org.ktde.util.datatypes.Tripel;
import org.ktde.util.datatypes.Tupel;

public class EsslingerOfferPrinterImpl
extends AbstractOfferPrinterImpl<OfferExtension1Model> {
    private static final String TEMPLATE = "fo/offer2pdf.vm";
    private static final int LENGTH1 = 10;
    private static final int LENGTH2 = 30;
    private static final int LENGTH3 = 30;
    private static final int LENGTH4 = 10;
    private static final int LENGTH5 = 20;

    @Override
    public InputStream printOffer(OfferModel offer, OfferExtension1Model esslingerOfferExtension, ModelEnviroment modelEnviroment) throws Exception {
        HashMap<String, Image> inputImages = new HashMap<String, Image>(1);
        HashMap<String, Object> inputDatas = new HashMap<String, Object>(1);
        String logoPath = "/logo/pz/logo_PZ-Zeitung.png";
        BufferedImage logo = ImageIO.read(EsslingerOfferPrinterImpl.class.getResourceAsStream(logoPath));
        inputImages.put("logo", logo);
        inputDatas.put("offer", offer);
        inputDatas.put("esslingerOfferExtension", esslingerOfferExtension);
        OfferPrinterHelper offerPrinterHelper = new OfferPrinterHelper();
        inputDatas.put("offerPrinterHelper", offerPrinterHelper);
        if (offerPrinterHelper.shouldPrintAreaImage(offer, esslingerOfferExtension)) {
            Map<String, String[]> printrunCountAttrMap = this.getAttributesToShow(modelEnviroment);
            ArrayList<AreaObjectModel> list = new ArrayList<AreaObjectModel>(offer.countOfferAreaRelations());
            HashMap map = new HashMap();
            int sumPrintRunCounts = 0;
            for (OfferAreaRelationModel offerAreaRelation : offer.iterableOfferAreaRelations()) {
                AreaObjectModel area = offerAreaRelation.getArea();
                if (area == null) continue;
                list.add(area);
                AreaLayerModel areaLayer = area.getAreaLayer();
                String layerName = areaLayer == null ? "" : areaLayer.getDisplayname();
                LinkedList<Tripel<String, String, Integer>> layerList = (LinkedList<Tripel<String, String, Integer>>)map.get(layerName);
                if (layerList == null) {
                    layerList = new LinkedList<Tripel<String, String, Integer>>();
                    map.put(layerName, layerList);
                }
                int printRunCount = this.getPrintRunCount(area, printrunCountAttrMap);
                layerList.add(new Tripel<String, String, Integer>(area.getShortcut(), area.getDisplayname(), printRunCount));
                sumPrintRunCounts += printRunCount;
            }
            Image areaImage = this.printAreaObjectsInOnePage(list, PdfCreatorImpl.A4_PORTRAIT_PAGEWIDTH.intValue(), PdfCreatorImpl.A4_PORTRAIT_PAGEHEIGHT.intValue(), modelEnviroment);
            inputImages.put("areaImage", areaImage);
            Integer setPrintRunCount = esslingerOfferExtension.getPrintRunCount();
            boolean otherPrintRunCount = setPrintRunCount != null && sumPrintRunCounts != setPrintRunCount;
            ArrayList<Tupel<String, List>> areaList = new ArrayList<Tupel<String, List>>(map.size());
            TreeSet layerNames = new TreeSet(map.keySet());
            for (String layerName : layerNames) {
                List tripelList = (List)map.get(layerName);
                if (otherPrintRunCount) {
                    for (Tripel tripel : tripelList) {
                        tripel.setElement3(null);
                    }
                }
                Collections.sort(tripelList);
                areaList.add(new Tupel<String, List>(layerName, tripelList));
            }
            if (!areaList.isEmpty()) {
                inputDatas.put("areaTableInformation", areaList);
            }
        }
        inputDatas.put("peppergisCommonPdfHelper", new PeppergisCommonPdfHelper());
        inputDatas.put("offerPrinterHelper", new OfferPrinterHelper());
        PdfCreatorImpl pdfCreator = new PdfCreatorImpl();
        return pdfCreator.createPdf(TEMPLATE, inputDatas, inputImages, ModelEnviroment.getMessageResolver());
    }

    private int getPrintRunCount(AreaObjectModel area, Map<String, String[]> map) {
        AreaLayerModel areaLayer = area.getAreaLayer();
        String layername = areaLayer == null ? "" : areaLayer.getDisplayname();
        String[] attributes = map.get(layername);
        int sum = 0;
        if (attributes != null) {
            HashMap<String, Integer> intAttributeValues = new HashMap<String, Integer>();
            for (AreaAttributeValueModel areaAttributeValueModel : area.iterableAreaAttributeValues()) {
                AreaAttributeValueDescriptorModel areaAttributeValueDescriptor = areaAttributeValueModel.getAreaAttributeValueDescriptor();
                if (areaAttributeValueDescriptor.getAttributeValueType() != AttributeValueType.INTEGER) continue;
                intAttributeValues.put(areaAttributeValueDescriptor.getKey(), areaAttributeValueModel.getIntegerValue());
            }
            for (String attr : attributes) {
                Integer value = (Integer)intAttributeValues.get(attr);
                if (value == null) continue;
                sum += value.intValue();
            }
        }
        return sum;
    }

    private Map<String, String[]> getAttributesToShow(ModelEnviroment modelEnviroment) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Collection<AreaLayerModel> layers = modelEnviroment.getAllCaller().getAreaCaller().getAreaLayersForType(AreaObjectGenInfoDiscriminator.values());
        for (AreaLayerModel layer : layers) {
            String attribute;
            String layerName = layer.getDisplayname();
            String propLayerName = layerName.replace(' ', '_');
            LinkedList<String> attributes = new LinkedList<String>();
            int i = 1;
            while ((attribute = ModelEnviroment.getProperties().getProperty("offer.area.attributeToShow." + propLayerName + "." + i)) != null) {
                attributes.add(attribute);
                ++i;
            }
            String[] a = new String[attributes.size()];
            a = attributes.toArray(a);
            map.put(layerName, a);
        }
        return map;
    }

    private String getContact(AgentModel agent, String greeting, OfferType offerType) {
        String contact = "";
        switch (offerType) {
            case OFFER: {
                contact = "Ich freue mich auf eine positive R\u00fcckmeldung und bin bei R\u00fcckfragen gerne f\u00fcr Sie da./n/n";
                break;
            }
            case CONFIRMATION: {
                contact = "Ich freue mich auf den n\u00e4chsten Kontakt mit Ihnen./n/n";
            }
        }
        contact = contact + greeting + "/n/n";
        contact = contact + agent.getFirstName() + " " + agent.getLastName() + "/n";
        contact = contact + agent.getFunction() + "/n/n" + agent.getCompany() + "/n";
        contact = contact + agent.getStreet() + " " + agent.getHousenumber() + " " + (agent.getHousenumberExtension() == null ? "" : agent.getHousenumberExtension());
        contact = contact + " - " + agent.getPostcode() + " " + agent.getCity() + "/n";
        contact = contact + "Tel.: " + agent.getPhone() + " - Fax: " + agent.getFax() + "/n";
        contact = contact + "mailto: " + agent.getEmail() + " - " + agent.getWww() + "/n/n";
        return contact;
    }

    private String getMediaString(List<MediaModel> medias) {
        String mediaString = "Verteilart: ";
        for (MediaModel media : medias) {
            mediaString = mediaString + media.getName();
        }
        return mediaString;
    }

    private String getMoreInfo(OfferModel offer, OfferExtension1Model esslingerOfferExtension) {
        String moreInfo = "Technische Angaben:/n" + esslingerOfferExtension.getTechnicalInformation().replace("\n", "/n") + "/n";
        moreInfo = moreInfo + "Anlieferung: " + offer.getDeliveryInformation() + "/n";
        moreInfo = moreInfo + "Verteiltermin: " + TimeUtil.formatDate(esslingerOfferExtension.getDistributorsTime(), "yyyy-MM-dd") + "/n/n";
        Iterator<OfferDeliveryRelationModel> iter = offer.iterateOfferDeliveryRelations();
        while (iter.hasNext()) {
            OfferDeliveryRelationModel next = iter.next();
            OfferDeliveryInformationModel information = next.getOfferDeliveryInformation();
            moreInfo = moreInfo + "Lieferanschrift: " + this.getAddress(information);
            Integer quantity = next.getQuantity();
            if (quantity != null) {
                moreInfo = moreInfo + ", " + quantity + " St.";
            }
            moreInfo = moreInfo + "/n";
        }
        return moreInfo;
    }

    private String getAddress(OfferDeliveryInformationModel information) {
        String info = information.getName() + ", " + information.getDeliveryStreet();
        info = info + " " + information.getDeliveryHousenumber() + (information.getDeliveryHousenumberExtension() == null ? "" : information.getDeliveryHousenumberExtension());
        info = info + ", " + information.getDeliveryPostcode() + " " + information.getDeliveryCity();
        return StringEscapeUtils.escapeXml(info);
    }

    private String getfAreaTable(OfferModel offer) {
        String header = this.getHeader();
        String tableString = "";
        int index = 1;
        Iterator<OfferAreaRelationModel> iter = offer.iterateOfferAreaRelations();
        while (iter.hasNext()) {
            OfferAreaRelationModel relation = iter.next();
            tableString = tableString + FormUtil.getStringWithLength(String.valueOf(index), 10);
            tableString = tableString + FormUtil.getStringWithLength(relation.getArea().getDisplayname(), 30);
            tableString = tableString + FormUtil.getStringWithLength("1", 30);
            tableString = tableString + FormUtil.getStringWithLength("2", 10);
            tableString = tableString + FormUtil.getStringWithLength("3", 20) + "/n";
            ++index;
        }
        return header + "/n" + tableString;
    }

    private String getHeader() {
        String header = FormUtil.getStringWithLength("Pos.", 10);
        header = header + FormUtil.getStringWithLength("Gebiete-Name", 30);
        header = header + FormUtil.getStringWithLength("Auflage", 30);
        header = header + FormUtil.getStringWithLength("Preis", 10);
        header = header + FormUtil.getStringWithLength("Summe", 20);
        return header;
    }

    private String getTitel(OfferType offerType) {
        if (offerType == OfferType.OFFER) {
            return "Angebot";
        }
        if (offerType == OfferType.CONFIRMATION) {
            return "Auftragsbest\u00e4tigung";
        }
        return "";
    }

    private String getOfferInformation(OfferModel offer) {
        String offerInfo = "Nummer: " + offer.getOfferNumber() + "/n";
        offerInfo = offerInfo + "Kunden-Nummer: " + offer.getCustomer().getCustomerNumber() + "/n";
        offerInfo = offerInfo + "Bearbeiter: " + offer.getAgent().getFirstName() + " " + offer.getAgent().getLastName() + "/n";
        return offerInfo;
    }

    private String getCustomerString(CustomerModel customer) {
        String customerString = "";
        customerString = PrimitiveUtil.nullToFalse(customer.getCompany()) ? customerString + "Firma/n" + customer.getCompanyName() + "/n" : customerString + this.getSalutationString(customer.getSalutation()) + StringUtil.nullToEmpty(customer.getFirstName()) + " " + StringUtil.nullToEmpty(customer.getLastName()) + "/n";
        customerString = customerString + LocationModelUtil.getAddressForPrint(customer.getDefaultLocation()) + "/n";
        return customerString;
    }

    private String getSalutationString(Salutation salutation) {
        if (salutation == null || salutation == Salutation.MR) {
            return "Herr/n";
        }
        if (salutation == Salutation.MRS) {
            return "Frau/n";
        }
        return "";
    }
}

