/*
 * Decompiled with CFR 0.152.
 */
package de.datomino.peppergis.offer.print;

import de.datomino.pdf.engine.PdfCreatorImpl;
import de.datomino.peppergis.client.gui.main.ModelEnviroment;
import de.datomino.peppergis.client.gui.osm.NotThreadingOsmNavigatorRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRenderer;
import de.datomino.peppergis.client.gui.renderer.area.AreaLayerRendererPrintTypeDecider;
import de.datomino.peppergis.client.model.Model;
import de.datomino.peppergis.client.model.area.AreaObjectModel;
import de.datomino.peppergis.client.util.AreaObjectModelUtil;
import de.datomino.peppergis.offer.print.OfferPrinter;
import de.datomino.peppergis.simplebasearea.BaseLayerEditorPanel;
import de.datomino.peppergis.simplebasearea.print.AreaPrintAreaLayerPrintTypeDecider;
import de.datomino.util.geo.ImmutablePolygonKind;
import de.datomino.util.geo.model.BucketsFetchCallback;
import de.datomino.util.geo.model.DefaultGeoObjectBucketsModel;
import de.datomino.util.geo.model.GeoObjectBucketsModel;
import de.datomino.util.geo.model.GeomExtractor;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import org.ktde.math.projection.Coordinate;
import org.ktde.math.projection.OpenStreetmapViewFactory;
import org.ktde.swing.navigator.NavigatorPanel;
import org.ktde.util.datatypes.Tupel;

public abstract class AbstractOfferPrinterImpl<T extends Model>
implements OfferPrinter<T> {
    private Tupel<NavigatorPanel, AreaLayerRenderer> createPrintNavigatorPanel(int width, int height, ModelEnviroment modelEnviroment) {
        NotThreadingOsmNavigatorRenderer osmNavigatorRenderer = new NotThreadingOsmNavigatorRenderer(ModelEnviroment.getProperties());
        NavigatorPanel printNavigatorPanel = new NavigatorPanel(0.0, 0.0, OpenStreetmapViewFactory.INSTANCE, null);
        printNavigatorPanel.addRenderer(osmNavigatorRenderer);
        printNavigatorPanel.setSize((int)(((double)width - (double)PdfCreatorImpl.DPI.intValue() / PdfCreatorImpl.INCH_PER_CM) * 2.0), (int)(((double)height - (double)PdfCreatorImpl.DPI.intValue() / PdfCreatorImpl.INCH_PER_CM) * 2.0));
        printNavigatorPanel.forceCalcTransform();
        GeomExtractor<AreaObjectModel, ImmutablePolygonKind> geomExtractor = new GeomExtractor<AreaObjectModel, ImmutablePolygonKind>(){

            @Override
            public ImmutablePolygonKind getGeom(AreaObjectModel object) {
                return object.getGeom();
            }
        };
        DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> defaultGeoObjectBucketsModel = new DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(printNavigatorPanel.getCoordinateFactory(), geomExtractor);
        AreaLayerRenderer areaLayerRenderer = AreaLayerRenderer.createDefaultAreaLayerRenderer("OfferPrinter", defaultGeoObjectBucketsModel, geomExtractor, "offer", modelEnviroment, 10000.0, 25, false, printNavigatorPanel);
        printNavigatorPanel.addRenderer(areaLayerRenderer);
        return new Tupel<NavigatorPanel, AreaLayerRenderer>(printNavigatorPanel, areaLayerRenderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image printAreaObjectsInOnePage(final Collection<AreaObjectModel> areaObjectModels, int width, int height, ModelEnviroment modelEnviroment) throws InterruptedException {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (AreaObjectModel areaObjectModel : areaObjectModels) {
            coordinates.addAll(AreaObjectModelUtil.getAreaRectangle(areaObjectModel));
        }
        Tupel<NavigatorPanel, AreaLayerRenderer> tupel = this.createPrintNavigatorPanel(width, height, modelEnviroment);
        NavigatorPanel navigatorPanel = tupel.getElement1();
        AreaLayerRenderer areaLayerRenderer = tupel.getElement2();
        GeoObjectBucketsModel regularBucktesModel = areaLayerRenderer.getBucketsModel();
        AreaLayerRendererPrintTypeDecider areaLayerRendererPrintTypeDecider = areaLayerRenderer.getAreaLayerRendererPrintTypeDecider();
        try {
            Image image;
            DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind> bucketsModel = new DefaultGeoObjectBucketsModel<AreaObjectModel, ImmutablePolygonKind>(navigatorPanel.getCoordinateFactory(), BaseLayerEditorPanel.createAreaGeomExtractor());
            bucketsModel.setFetchCallback(new BucketsFetchCallback<AreaObjectModel, ImmutablePolygonKind>(){

                @Override
                public Collection<AreaObjectModel> fetch(Coordinate topLeft, Coordinate bottomRight) {
                    return areaObjectModels;
                }
            });
            areaLayerRenderer.setBucketsModel(bucketsModel);
            areaLayerRenderer.setEmphasizeSelected(false);
            areaLayerRenderer.setAreaLayerRendererPrintTypeDecider(new AreaPrintAreaLayerPrintTypeDecider(true));
            navigatorPanel.center(coordinates, 1.0, true);
            navigatorPanel.paintImage();
            Image image2 = image = this.getImageFromNavigatorPanel(navigatorPanel);
            return image2;
        }
        finally {
            areaLayerRenderer.setBucketsModel(regularBucktesModel);
            areaLayerRenderer.setEmphasizeSelected(true);
            areaLayerRenderer.setAreaLayerRendererPrintTypeDecider(areaLayerRendererPrintTypeDecider);
        }
    }

    private Image getImageFromNavigatorPanel(NavigatorPanel printNavigatorPanel) throws InterruptedException {
        return printNavigatorPanel.paintImage();
    }
}

